/*
 * Decompiled with CFR 0.152.
 */
package net.snowflake.client.jdbc;

import java.io.File;
import java.sql.BatchUpdateException;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.SQLFeatureNotSupportedException;
import java.sql.Statement;
import java.util.List;
import net.snowflake.client.AbstractDriverIT;
import net.snowflake.client.ConditionalIgnoreRule;
import net.snowflake.client.RunningOnGithubAction;
import net.snowflake.client.category.TestCategoryStatement;
import net.snowflake.client.jdbc.BaseJDBCTest;
import net.snowflake.client.jdbc.ErrorCode;
import net.snowflake.client.jdbc.SnowflakeConnectionV1;
import net.snowflake.client.jdbc.SnowflakeResultSet;
import net.snowflake.client.jdbc.SnowflakeSQLException;
import net.snowflake.client.jdbc.SnowflakeStatement;
import net.snowflake.client.jdbc.SnowflakeStatementV1;
import net.snowflake.client.jdbc.telemetry.Telemetry;
import net.snowflake.client.jdbc.telemetry.TelemetryClient;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.junit.Assert;
import org.junit.Ignore;
import org.junit.Rule;
import org.junit.Test;
import org.junit.experimental.categories.Category;
import org.junit.rules.TemporaryFolder;

@Category(value={TestCategoryStatement.class})
public class StatementIT
extends BaseJDBCTest {
    protected static String queryResultFormat = "json";
    @Rule
    public TemporaryFolder tmpFolder = new TemporaryFolder();

    public static Connection getConnection() throws SQLException {
        Connection conn = BaseJDBCTest.getConnection();
        Statement stmt = conn.createStatement();
        stmt.execute("alter session set jdbc_query_result_format = '" + queryResultFormat + "'");
        stmt.close();
        return conn;
    }

    @Test
    public void testFetchDirection() throws SQLException {
        Connection connection = StatementIT.getConnection();
        Statement statement = connection.createStatement();
        Assert.assertEquals((long)1000L, (long)statement.getFetchDirection());
        try {
            statement.setFetchDirection(1001);
        }
        catch (SQLFeatureNotSupportedException e) {
            Assert.assertTrue((boolean)true);
        }
        statement.close();
        connection.close();
    }

    @Ignore(value="Not working for setFetchSize")
    @Test
    public void testFetchSize() throws SQLException {
        Connection connection = StatementIT.getConnection();
        Statement statement = connection.createStatement();
        Assert.assertEquals((long)50L, (long)statement.getFetchSize());
        statement.setFetchSize(1);
        ResultSet rs = statement.executeQuery("select * from JDBC_STATEMENT");
        Assert.assertEquals((long)1L, (long)this.getSizeOfResultSet(rs));
        statement.close();
        connection.close();
    }

    @Test
    public void testMaxRows() throws SQLException {
        Connection connection = StatementIT.getConnection();
        Statement statement = connection.createStatement();
        String sqlSelect = "select seq4() from table(generator(rowcount=>3))";
        Assert.assertEquals((long)0L, (long)statement.getMaxRows());
        ResultSet rs = statement.executeQuery(sqlSelect);
        int resultSizeCount = this.getSizeOfResultSet(rs);
        statement.setMaxRows(0);
        rs = statement.executeQuery(sqlSelect);
        statement.setMaxRows(-1);
        rs = statement.executeQuery(sqlSelect);
        statement.close();
        connection.close();
    }

    @Test
    public void testQueryTimeOut() throws SQLException {
        Connection connection = StatementIT.getConnection();
        Statement statement = connection.createStatement();
        Assert.assertEquals((long)0L, (long)statement.getQueryTimeout());
        statement.setQueryTimeout(5);
        Assert.assertEquals((long)5L, (long)statement.getQueryTimeout());
        try {
            statement.executeQuery("select count(*) from table(generator(timeLimit => 100))");
        }
        catch (SQLException e) {
            Assert.assertTrue((boolean)true);
            Assert.assertEquals((Object)"57014", (Object)e.getSQLState());
            Assert.assertEquals((Object)"SQL execution canceled", (Object)e.getMessage());
        }
        statement.close();
        connection.close();
    }

    @Test
    public void testStatementClose() throws SQLException {
        Connection connection = StatementIT.getConnection();
        Statement statement = connection.createStatement();
        Assert.assertEquals((Object)connection, (Object)statement.getConnection());
        Assert.assertTrue((!statement.isClosed() ? 1 : 0) != 0);
        statement.close();
        Assert.assertTrue((boolean)statement.isClosed());
        connection.close();
    }

    @Test
    public void testExecuteSelect() throws SQLException {
        Connection connection = StatementIT.getConnection();
        Statement statement = connection.createStatement();
        String sqlSelect = "select seq4() from table(generator(rowcount=>3))";
        boolean success = statement.execute(sqlSelect);
        Assert.assertTrue((boolean)success);
        String queryID1 = statement.unwrap(SnowflakeStatement.class).getQueryID();
        Assert.assertNotNull((Object)queryID1);
        ResultSet rs = statement.getResultSet();
        Assert.assertEquals((long)3L, (long)this.getSizeOfResultSet(rs));
        Assert.assertEquals((long)-1L, (long)statement.getUpdateCount());
        Assert.assertEquals((long)-1L, (long)statement.getLargeUpdateCount());
        String queryID2 = rs.unwrap(SnowflakeResultSet.class).getQueryID();
        Assert.assertEquals((Object)queryID2, (Object)queryID1);
        rs = statement.executeQuery(sqlSelect);
        Assert.assertEquals((long)3L, (long)this.getSizeOfResultSet(rs));
        String queryID4 = rs.unwrap(SnowflakeResultSet.class).getQueryID();
        Assert.assertNotEquals((Object)queryID4, (Object)queryID1);
        rs.close();
        statement.close();
        connection.close();
    }

    @Test
    public void testExecuteInsert() throws SQLException {
        Connection connection = StatementIT.getConnection();
        Statement statement = connection.createStatement();
        statement.execute("create or replace table test_insert(cola number)");
        String insertSQL = "insert into test_insert values(2),(3)";
        int updateCount = statement.executeUpdate(insertSQL);
        Assert.assertEquals((long)2L, (long)updateCount);
        boolean success = statement.execute(insertSQL);
        Assert.assertFalse((boolean)success);
        Assert.assertEquals((long)2L, (long)statement.getUpdateCount());
        Assert.assertEquals((long)2L, (long)statement.getLargeUpdateCount());
        Assert.assertNull((Object)statement.getResultSet());
        ResultSet rs = statement.executeQuery("select count(*) from test_insert");
        rs.next();
        Assert.assertEquals((long)4L, (long)rs.getInt(1));
        rs.close();
        Assert.assertTrue((boolean)statement.execute("select 1"));
        ResultSet rs0 = statement.getResultSet();
        rs0.next();
        Assert.assertEquals((long)rs0.getInt(1), (long)1L);
        rs0.close();
        statement.execute("drop table if exists test_insert");
        statement.close();
        connection.close();
    }

    @Test
    public void testExecuteUpdateAndDelete() throws SQLException {
        Connection connection = StatementIT.getConnection();
        Statement statement = connection.createStatement();
        statement.execute("create or replace table test_update(cola number, colb string) as select 1, 'str1'");
        statement.execute("insert into test_update values(2, 'str2')");
        int updateCount = statement.executeUpdate("update test_update set COLB = 'newStr' where COLA = 1");
        Assert.assertEquals((long)1L, (long)updateCount);
        boolean success = statement.execute("update test_update set COLB = 'newStr' where COLA = 2");
        Assert.assertFalse((boolean)success);
        Assert.assertEquals((long)1L, (long)statement.getUpdateCount());
        Assert.assertEquals((long)1L, (long)statement.getLargeUpdateCount());
        Assert.assertNull((Object)statement.getResultSet());
        updateCount = statement.executeUpdate("delete from test_update where colA = 1");
        Assert.assertEquals((long)1L, (long)updateCount);
        success = statement.execute("delete from test_update where colA = 2");
        Assert.assertFalse((boolean)success);
        Assert.assertEquals((long)1L, (long)statement.getUpdateCount());
        Assert.assertEquals((long)1L, (long)statement.getLargeUpdateCount());
        Assert.assertNull((Object)statement.getResultSet());
        statement.execute("drop table if exists test_update");
        statement.close();
        connection.close();
    }

    @Test
    public void testExecuteMerge() throws SQLException {
        Connection connection = StatementIT.getConnection();
        String mergeSQL = "merge into target using source on target.id = source.id when matched and source.sb =22 then update set ta = 'newStr' when not matched then insert (ta, tb) values (source.sa, source.sb)";
        Statement statement = connection.createStatement();
        statement.execute("create or replace table target(id integer, ta string, tb integer)");
        statement.execute("create or replace table source(id integer, sa string, sb integer)");
        statement.execute("insert into target values(1, 'str', 1)");
        statement.execute("insert into target values(2, 'str', 2)");
        statement.execute("insert into target values(3, 'str', 3)");
        statement.execute("insert into source values(1, 'str1', 11)");
        statement.execute("insert into source values(2, 'str2', 22)");
        statement.execute("insert into source values(3, 'str3', 33)");
        int updateCount = statement.executeUpdate(mergeSQL);
        Assert.assertEquals((long)1L, (long)updateCount);
        statement.execute("drop table if exists target");
        statement.execute("drop table if exists source");
        statement.close();
        connection.close();
    }

    @Test
    public void testAutogenerateKey() throws Throwable {
        try (Connection connection = StatementIT.getConnection();){
            Statement statement = connection.createStatement();
            statement.execute("create or replace table t(c1 int)");
            statement.execute("insert into t values(1)", 2);
            try {
                statement.execute("insert into t values(2)", 1);
                Assert.fail((String)"no autogenerate key is supported");
            }
            catch (SQLFeatureNotSupportedException sQLFeatureNotSupportedException) {
                // empty catch block
            }
            ResultSet rset = statement.getGeneratedKeys();
            Assert.assertFalse((boolean)rset.next());
            rset.close();
        }
    }

    @Test
    public void testExecuteMultiInsert() throws SQLException {
        Connection connection = StatementIT.getConnection();
        String multiInsertionSQL = " insert all into foo into foo1 into bar (b1, b2, b3) values (s3, s2, s1) select s1, s2, s3 from source";
        Statement statement = connection.createStatement();
        Assert.assertFalse((boolean)statement.execute("create or replace table foo (f1 integer, f2 integer, f3 integer)"));
        Assert.assertFalse((boolean)statement.execute("create or replace table foo1 (f1 integer, f2 integer, f3 integer)"));
        Assert.assertFalse((boolean)statement.execute("create or replace table bar (b1 integer, b2 integer, b3 integer)"));
        Assert.assertFalse((boolean)statement.execute("create or replace table source(s1 integer, s2 integer, s3 integer)"));
        Assert.assertFalse((boolean)statement.execute("insert into source values(1, 2, 3)"));
        Assert.assertFalse((boolean)statement.execute("insert into source values(11, 22, 33)"));
        Assert.assertFalse((boolean)statement.execute("insert into source values(111, 222, 333)"));
        int updateCount = statement.executeUpdate(multiInsertionSQL);
        Assert.assertEquals((long)9L, (long)updateCount);
        statement.execute("drop table if exists foo");
        statement.execute("drop table if exists foo1");
        statement.execute("drop table if exists bar");
        statement.execute("drop table if exists source");
        statement.close();
        connection.close();
    }

    @Test
    public void testExecuteBatch() throws Exception {
        Connection connection = StatementIT.getConnection();
        Statement statement = connection.createStatement();
        connection.setAutoCommit(false);
        statement.addBatch("create or replace table test_batch(a string, b integer)");
        statement.addBatch("insert into test_batch values('str1', 1), ('str2', 2)");
        statement.addBatch("update test_batch set test_batch.b = src.b + 5 from (select 'str1' as a, 2 as b) src where test_batch.a = src.a");
        int[] rowCounts = statement.executeBatch();
        connection.commit();
        MatcherAssert.assertThat((Object)rowCounts.length, (Matcher)CoreMatchers.is((Object)3));
        MatcherAssert.assertThat((Object)rowCounts[0], (Matcher)CoreMatchers.is((Object)0));
        MatcherAssert.assertThat((Object)rowCounts[1], (Matcher)CoreMatchers.is((Object)2));
        MatcherAssert.assertThat((Object)rowCounts[2], (Matcher)CoreMatchers.is((Object)1));
        List batchQueryIDs = statement.unwrap(SnowflakeStatement.class).getBatchQueryIDs();
        Assert.assertEquals((long)3L, (long)batchQueryIDs.size());
        Assert.assertEquals((Object)statement.unwrap(SnowflakeStatement.class).getQueryID(), batchQueryIDs.get(2));
        ResultSet resultSet = statement.executeQuery("select * from test_batch order by b asc");
        resultSet.next();
        MatcherAssert.assertThat((Object)resultSet.getInt("B"), (Matcher)CoreMatchers.is((Object)2));
        resultSet.next();
        MatcherAssert.assertThat((Object)resultSet.getInt("B"), (Matcher)CoreMatchers.is((Object)7));
        statement.clearBatch();
        try {
            statement.addBatch("insert into test_batch values('str3', 3)");
            statement.addBatch("select * from test_batch");
            statement.addBatch("select * from test_batch_not_exist");
            statement.addBatch("insert into test_batch values('str4', 4)");
            statement.executeBatch();
            Assert.fail();
        }
        catch (BatchUpdateException e) {
            rowCounts = e.getUpdateCounts();
            MatcherAssert.assertThat((Object)e.getErrorCode(), (Matcher)CoreMatchers.is((Object)2003));
            MatcherAssert.assertThat((Object)rowCounts[0], (Matcher)CoreMatchers.is((Object)1));
            MatcherAssert.assertThat((Object)rowCounts[1], (Matcher)CoreMatchers.is((Object)-2));
            MatcherAssert.assertThat((Object)rowCounts[2], (Matcher)CoreMatchers.is((Object)-3));
            MatcherAssert.assertThat((Object)rowCounts[3], (Matcher)CoreMatchers.is((Object)1));
            connection.rollback();
        }
        statement.clearBatch();
        statement.addBatch("put file://" + StatementIT.getFullPathFileInResource("orders_100.csv") + " @%test_batch auto_compress=false");
        File tempFolder = this.tmpFolder.newFolder("test_downloads_folder");
        statement.addBatch("get @%test_batch file://" + tempFolder);
        rowCounts = statement.executeBatch();
        MatcherAssert.assertThat((Object)rowCounts.length, (Matcher)CoreMatchers.is((Object)2));
        MatcherAssert.assertThat((Object)rowCounts[0], (Matcher)CoreMatchers.is((Object)-2));
        MatcherAssert.assertThat((Object)rowCounts[0], (Matcher)CoreMatchers.is((Object)-2));
        statement.clearBatch();
        statement.execute("drop table if exists test_batch");
        statement.close();
        connection.close();
    }

    @Test
    public void testExecuteLargeBatch() throws SQLException {
        Connection connection = StatementIT.getConnection();
        Statement statement = connection.createStatement();
        statement.execute("create or replace table test_large_batch (a number) as (select * from (select 5 from table(generator(rowcount => 15)) v));");
        statement.addBatch("update test_large_batch set a = 7 where a = 5;");
        long[] rowsUpdated = statement.executeLargeBatch();
        MatcherAssert.assertThat((Object)rowsUpdated.length, (Matcher)CoreMatchers.is((Object)1));
        long testVal = 15L;
        MatcherAssert.assertThat((Object)rowsUpdated[0], (Matcher)CoreMatchers.is((Object)testVal));
        statement.clearBatch();
        statement.execute("drop table if exists test_large_batch");
        statement.close();
        connection.close();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    @ConditionalIgnoreRule.ConditionalIgnore(condition=RunningOnGithubAction.class)
    public void testExecuteUpdateZeroCount() throws SQLException {
        try (Connection connection = StatementIT.getConnection();){
            String[] testCommands = new String[]{"use role accountadmin", "use database testdb", "use schema testschema", "create or replace table testExecuteUpdate(cola number)", "comment on table testExecuteUpdate is 'comments'", "alter table testExecuteUpdate rename column cola to colb", "create or replace role testRole", "create or replace user testuser", "grant SELECT on table testExecuteUpdate to role testrole", "grant role testrole to user testuser", "revoke SELECT on table testExecuteUpdate from role testrole", "revoke role testrole from user testuser", "truncate table testExecuteUpdate", "alter session set autocommit=false", "alter session unset autocommit", "drop table if exists testExecuteUpdate", "set v1 = 10", "unset v1", "undrop table testExecuteUpdate"};
            try {
                for (String testCommand : testCommands) {
                    Statement statement = connection.createStatement();
                    int updateCount = statement.executeUpdate(testCommand);
                    MatcherAssert.assertThat((Object)updateCount, (Matcher)CoreMatchers.is((Object)0));
                    statement.close();
                }
            }
            finally {
                Statement statement = connection.createStatement();
                statement.execute("use role accountadmin");
                statement.execute("drop table if exists testExecuteUpdate");
                statement.execute("drop role if exists testrole");
                statement.execute("drop user if exists testuser");
            }
        }
    }

    @Test
    public void testExecuteUpdateFail() throws Exception {
        try (Connection connection = StatementIT.getConnection();){
            String[] testCommands;
            for (String testCommand : testCommands = new String[]{"list @~", "ls @~", "remove @~/testfile", "rm @~/testfile", "select 1", "show databases", "desc database " + AbstractDriverIT.getConnectionParameters().get("database")}) {
                try {
                    Statement statement = connection.createStatement();
                    statement.executeUpdate(testCommand);
                    Assert.fail((String)("TestCommand: " + testCommand + " is expected to be failed to execute"));
                }
                catch (SQLException e) {
                    MatcherAssert.assertThat((String)testCommand, (Object)e.getErrorCode(), (Matcher)CoreMatchers.is((Object)ErrorCode.UNSUPPORTED_STATEMENT_TYPE_IN_EXECUTION_API.getMessageCode()));
                }
            }
        }
    }

    @Test
    public void testTelemetryBatch() throws SQLException {
        Connection connection = StatementIT.getConnection();
        Statement statement = connection.createStatement();
        String sqlSelect = "select seq4() from table(generator(rowcount=>3))";
        statement.execute(sqlSelect);
        ResultSet rs = statement.getResultSet();
        Assert.assertEquals((long)3L, (long)this.getSizeOfResultSet(rs));
        Assert.assertEquals((long)-1L, (long)statement.getUpdateCount());
        Assert.assertEquals((long)-1L, (long)statement.getLargeUpdateCount());
        rs = statement.executeQuery(sqlSelect);
        Assert.assertEquals((long)3L, (long)this.getSizeOfResultSet(rs));
        rs.close();
        Telemetry telemetryClient = ((SnowflakeStatementV1)statement).connection.getSfSession().getTelemetryClient();
        Assert.assertTrue((((TelemetryClient)telemetryClient).bufferSize() > 0 ? 1 : 0) != 0);
        statement.close();
        try {
            Thread.sleep(1000L);
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        Assert.assertEquals((long)((TelemetryClient)telemetryClient).bufferSize(), (long)0L);
        connection.close();
    }

    @Test
    public void testMultiStmtNotEnabled() throws SQLException {
        Connection connection = StatementIT.getConnection();
        Statement statement = connection.createStatement();
        String multiStmtQuery = "create or replace temporary table test_multi (cola int);\ninsert into test_multi VALUES (1), (2);\nselect cola from test_multi order by cola asc";
        try {
            statement.execute(multiStmtQuery);
            Assert.fail((String)"Using a multi-statement query without the parameter set should fail");
        }
        catch (SnowflakeSQLException ex) {
            Assert.assertEquals((Object)"0A000", (Object)ex.getSQLState());
        }
        statement.close();
        connection.close();
    }

    @Test
    public void testCallStoredProcedure() throws SQLException {
        Connection connection = StatementIT.getConnection();
        Statement statement = connection.createStatement();
        statement.execute("create or replace procedure SP()\nreturns string not null\nlanguage javascript\nas $$\n  snowflake.execute({sqlText:'select seq4() from table(generator(rowcount=>5))'});\n  return 'done';\n$$");
        Assert.assertTrue((boolean)statement.execute("call SP()"));
        ResultSet rs = statement.getResultSet();
        Assert.assertNotNull((Object)rs);
        Assert.assertTrue((boolean)rs.next());
        Assert.assertEquals((Object)"done", (Object)rs.getString(1));
        Assert.assertFalse((boolean)rs.next());
        Assert.assertFalse((boolean)statement.getMoreResults());
        Assert.assertEquals((long)-1L, (long)statement.getUpdateCount());
        Assert.assertEquals((long)-1L, (long)statement.getLargeUpdateCount());
        statement.close();
        connection.close();
    }

    @Test
    public void testCreateStatementWithParameters() throws Throwable {
        try (Connection connection = StatementIT.getConnection();){
            connection.createStatement(1003, 1007);
            try {
                connection.createStatement(1003, 1008);
                Assert.fail((String)"updateable cursor is not supported.");
            }
            catch (SQLException ex) {
                Assert.assertEquals((long)ErrorCode.FEATURE_UNSUPPORTED.getMessageCode().intValue(), (long)ex.getErrorCode());
            }
            connection.createStatement(1003, 1007, 2);
            try {
                connection.createStatement(1003, 1007, 1);
                Assert.fail((String)"hold cursor over commit is not supported.");
            }
            catch (SQLException ex) {
                Assert.assertEquals((long)ErrorCode.FEATURE_UNSUPPORTED.getMessageCode().intValue(), (long)ex.getErrorCode());
            }
        }
    }

    @Test
    public void testUnwrapper() throws Throwable {
        try (Connection connection = StatementIT.getConnection();){
            Statement statement = connection.createStatement();
            if (statement.isWrapperFor(SnowflakeStatementV1.class)) {
                statement.execute("select 1");
                SnowflakeStatement sfstatement = statement.unwrap(SnowflakeStatement.class);
                Assert.assertNotNull((Object)sfstatement.getQueryID());
            } else {
                Assert.fail((String)"should be able to unwrap");
            }
            try {
                statement.unwrap(SnowflakeConnectionV1.class);
                Assert.fail((String)"should fail to cast");
            }
            catch (SQLException sQLException) {
                // empty catch block
            }
        }
    }
}

