/*
 * Decompiled with CFR 0.152.
 */
package net.snowflake.client.jdbc;

import java.io.File;
import java.net.URL;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import net.snowflake.client.ConditionalIgnoreRule;
import net.snowflake.client.RunningOnGithubAction;
import net.snowflake.client.category.TestCategoryStatement;
import net.snowflake.client.core.SFSession;
import net.snowflake.client.core.bind.BindUploader;
import net.snowflake.client.jdbc.BaseJDBCTest;
import net.snowflake.client.jdbc.ErrorCode;
import net.snowflake.client.jdbc.SnowflakeConnectionV1;
import net.snowflake.client.jdbc.SnowflakePreparedStatementV1;
import net.snowflake.client.jdbc.SnowflakeStatementV1;
import net.snowflake.client.jdbc.StatementIT;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.junit.Assert;
import org.junit.Rule;
import org.junit.Test;
import org.junit.experimental.categories.Category;
import org.junit.rules.TemporaryFolder;

@Category(value={TestCategoryStatement.class})
public class StatementLatestIT
extends BaseJDBCTest {
    protected static String queryResultFormat = "json";
    @Rule
    public TemporaryFolder tmpFolder = new TemporaryFolder();

    public static Connection getConnection() throws SQLException {
        Connection conn = BaseJDBCTest.getConnection();
        Statement stmt = conn.createStatement();
        stmt.execute("alter session set jdbc_query_result_format = '" + queryResultFormat + "'");
        stmt.close();
        return conn;
    }

    @Test
    public void testExecuteCreateAndDrop() throws SQLException {
        Connection connection = StatementLatestIT.getConnection();
        Statement statement = connection.createStatement();
        boolean success = statement.execute("create or replace table test_create(colA integer)");
        Assert.assertFalse((boolean)success);
        Assert.assertEquals((long)0L, (long)statement.getUpdateCount());
        Assert.assertEquals((long)0L, (long)statement.getLargeUpdateCount());
        Assert.assertNull((Object)statement.getResultSet());
        int rowCount = statement.executeUpdate("create or replace table test_create_2(colA integer)");
        Assert.assertEquals((long)0L, (long)rowCount);
        Assert.assertEquals((long)0L, (long)statement.getUpdateCount());
        success = statement.execute("drop table if exists TEST_CREATE");
        Assert.assertFalse((boolean)success);
        Assert.assertEquals((long)0L, (long)statement.getUpdateCount());
        Assert.assertEquals((long)0L, (long)statement.getLargeUpdateCount());
        Assert.assertNull((Object)statement.getResultSet());
        rowCount = statement.executeUpdate("drop table if exists TEST_CREATE_2");
        Assert.assertEquals((long)0L, (long)rowCount);
        Assert.assertEquals((long)0L, (long)statement.getUpdateCount());
        Assert.assertEquals((long)0L, (long)statement.getLargeUpdateCount());
        Assert.assertNull((Object)statement.getResultSet());
        statement.close();
        connection.close();
    }

    @Test
    @ConditionalIgnoreRule.ConditionalIgnore(condition=RunningOnGithubAction.class)
    public void testCopyAndUpload() throws Exception {
        Connection connection = null;
        Statement statement = null;
        File tempFolder = this.tmpFolder.newFolder("test_downloads_folder");
        List<String> accounts = Arrays.asList(null, "s3testaccount", "azureaccount", "gcpaccount");
        for (int i = 0; i < accounts.size(); ++i) {
            String fileName = "test_copy.csv";
            URL resource = StatementIT.class.getResource(fileName);
            connection = StatementLatestIT.getConnection(accounts.get(i));
            statement = connection.createStatement();
            statement.execute("create or replace table test_copy(c1 number, c2 number, c3 string)");
            Assert.assertEquals((long)0L, (long)statement.getUpdateCount());
            Assert.assertEquals((long)0L, (long)statement.getLargeUpdateCount());
            String path = resource.getFile();
            ResultSet rset = statement.executeQuery("PUT file://" + path + " @%test_copy");
            try {
                rset.getString(1);
                Assert.fail((String)"Should raise No row found exception, because no next() is called.");
            }
            catch (SQLException ex) {
                MatcherAssert.assertThat((String)"No row found error", (Object)ex.getErrorCode(), (Matcher)CoreMatchers.equalTo((Object)ErrorCode.ROW_DOES_NOT_EXIST.getMessageCode()));
            }
            int cnt = 0;
            while (rset.next()) {
                MatcherAssert.assertThat((String)"uploaded file name", (Object)rset.getString(1), (Matcher)CoreMatchers.equalTo((Object)fileName));
                ++cnt;
            }
            Assert.assertEquals((long)0L, (long)statement.getUpdateCount());
            Assert.assertEquals((long)0L, (long)statement.getLargeUpdateCount());
            MatcherAssert.assertThat((String)"number of files", (Object)cnt, (Matcher)CoreMatchers.equalTo((Object)1));
            int numRows = statement.executeUpdate("copy into test_copy");
            Assert.assertEquals((long)2L, (long)numRows);
            Assert.assertEquals((long)2L, (long)statement.getUpdateCount());
            Assert.assertEquals((long)2L, (long)statement.getLargeUpdateCount());
            statement.executeQuery("get @%test_copy 'file://" + tempFolder.getCanonicalPath() + "' parallel=8");
            File downloaded = new File(tempFolder.getCanonicalPath() + File.separator + fileName + ".gz");
            assert (downloaded.exists());
            Process p = Runtime.getRuntime().exec("gzip -d " + tempFolder.getCanonicalPath() + File.separator + fileName + ".gz");
            p.waitFor();
            File newCopy = new File(tempFolder.getCanonicalPath() + File.separator + fileName);
            statement.execute("create or replace table test_copy_2(c1 number, c2 number, c3 string)");
            rset = statement.executeQuery("PUT file://" + newCopy.getPath() + " @%test_copy_2");
            rset = statement.executeQuery("select * from @%test_copy minus select * from @%test_copy_2");
            Assert.assertFalse((boolean)rset.next());
            rset = statement.executeQuery("select * from @%test_copy_2 minus select * from @%test_copy");
            Assert.assertFalse((boolean)rset.next());
            statement.execute("drop table if exists test_copy");
            statement.execute("drop table if exists test_copy_2");
        }
        statement.close();
        connection.close();
    }

    @Test
    public void testExecuteOpenResultSets() throws SQLException {
        int i;
        Connection con = StatementLatestIT.getConnection();
        Statement statement = con.createStatement();
        for (i = 0; i < 10; ++i) {
            statement.execute("select 1");
            statement.getResultSet();
        }
        Assert.assertEquals((long)9L, (long)statement.unwrap(SnowflakeStatementV1.class).getOpenResultSets().size());
        statement.close();
        statement = con.createStatement();
        for (i = 0; i < 10; ++i) {
            statement.execute("select 1");
            ResultSet resultSet = statement.getResultSet();
            resultSet.close();
        }
        Assert.assertEquals((long)0L, (long)statement.unwrap(SnowflakeStatementV1.class).getOpenResultSets().size());
        statement.close();
        con.close();
    }

    @Test
    @ConditionalIgnoreRule.ConditionalIgnore(condition=RunningOnGithubAction.class)
    public void testPreparedStatementLogging() throws SQLException {
        try (Connection con = StatementLatestIT.getConnection();
             Statement stmt = con.createStatement();){
            SFSession sfSession = con.unwrap(SnowflakeConnectionV1.class).getSfSession();
            sfSession.setPreparedStatementLogging(true);
            stmt.execute("ALTER SESSION SET CLIENT_STAGE_ARRAY_BINDING_THRESHOLD = 1");
            stmt.executeQuery("create or replace table mytab(cola int, colb int, colc int, cold int, cole int, colf int, colg int, colh int)");
            PreparedStatement pstatement = con.prepareStatement("INSERT INTO mytab(cola, colb, colc, cold, cole, colf, colg, colh) VALUES (?, ?, ?, ?, ?, ?, ?, ?)");
            for (int i = 1; i <= 1001; ++i) {
                pstatement.setInt(1, i);
                pstatement.setInt(2, i);
                pstatement.setInt(3, i);
                pstatement.setInt(4, i);
                pstatement.setInt(5, i);
                pstatement.setInt(6, i);
                pstatement.setInt(7, i);
                pstatement.setInt(8, i);
                pstatement.addBatch();
            }
            Map bindings = pstatement.unwrap(SnowflakePreparedStatementV1.class).getBatchParameterBindings();
            Assert.assertTrue((bindings.size() > 0 ? 1 : 0) != 0);
            int bindValues = BindUploader.arrayBindValueCount((Map)bindings);
            Assert.assertEquals((long)8008L, (long)bindValues);
            pstatement.executeBatch();
            stmt.execute("drop table if exists mytab");
        }
    }
}

