/*
 * Decompiled with CFR 0.152.
 */
package net.snowflake.client.jdbc;

import java.io.InputStream;
import java.io.StringWriter;
import java.io.Writer;
import java.nio.charset.StandardCharsets;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.Statement;
import java.util.Arrays;
import java.util.List;
import net.snowflake.client.ConditionalIgnoreRule;
import net.snowflake.client.RunningOnGithubAction;
import net.snowflake.client.category.TestCategoryOthers;
import net.snowflake.client.jdbc.BaseJDBCTest;
import net.snowflake.client.jdbc.FileBackedOutputStream;
import net.snowflake.client.jdbc.SnowflakeConnection;
import net.snowflake.client.jdbc.SnowflakeConnectionV1;
import org.apache.commons.io.IOUtils;
import org.junit.Assert;
import org.junit.Test;
import org.junit.experimental.categories.Category;

@Category(value={TestCategoryOthers.class})
public class StreamIT
extends BaseJDBCTest {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testUploadStream() throws Throwable {
        String DEST_PREFIX = TEST_UUID + "/testUploadStream";
        Connection connection = null;
        Statement statement = null;
        try {
            connection = StreamIT.getConnection();
            statement = connection.createStatement();
            FileBackedOutputStream outputStream = new FileBackedOutputStream(1000000);
            outputStream.write("hello".getBytes(StandardCharsets.UTF_8));
            outputStream.flush();
            connection.unwrap(SnowflakeConnection.class).uploadStream("~", DEST_PREFIX, outputStream.asByteSource().openStream(), "hello.txt", false);
            ResultSet rset = statement.executeQuery("SELECT $1 FROM @~/" + DEST_PREFIX);
            String ret = null;
            while (rset.next()) {
                ret = rset.getString(1);
            }
            rset.close();
            Assert.assertEquals((String)("Unexpected string value: " + ret + " expect: hello"), (Object)"hello", (Object)ret);
        }
        finally {
            if (statement != null) {
                statement.execute("rm @~/" + DEST_PREFIX);
                statement.close();
            }
            this.closeSQLObjects(statement, connection);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    @ConditionalIgnoreRule.ConditionalIgnore(condition=RunningOnGithubAction.class)
    public void testDownloadStream() throws Throwable {
        String DEST_PREFIX = TEST_UUID + "/testUploadStream";
        Connection connection = null;
        Statement statement = null;
        List<String> supportedAccounts = Arrays.asList("s3testaccount", "azureaccount");
        for (String accountName : supportedAccounts) {
            try {
                connection = StreamIT.getConnection(accountName);
                statement = connection.createStatement();
                ResultSet rset = statement.executeQuery("PUT file://" + StreamIT.getFullPathFileInResource("orders_100.csv") + " @~/" + DEST_PREFIX);
                Assert.assertTrue((boolean)rset.next());
                Assert.assertEquals((Object)"UPLOADED", (Object)rset.getString(7));
                InputStream out = connection.unwrap(SnowflakeConnection.class).downloadStream("~", DEST_PREFIX + "/" + "orders_100.csv" + ".gz", true);
                StringWriter writer = new StringWriter();
                IOUtils.copy((InputStream)out, (Writer)writer, (String)"UTF-8");
                String output = writer.toString();
                Assert.assertEquals((Object)"1|", (Object)output.substring(0, 2));
                String[] lines = output.split("\n");
                Assert.assertEquals((long)28L, (long)lines.length);
            }
            finally {
                if (statement != null) {
                    statement.execute("rm @~/" + DEST_PREFIX);
                    statement.close();
                }
                this.closeSQLObjects(statement, connection);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testCompressAndUploadStream() throws Throwable {
        String DEST_PREFIX = TEST_UUID + "/testCompressAndUploadStream";
        Connection connection = null;
        Statement statement = null;
        ResultSet resultSet = null;
        try {
            connection = StreamIT.getConnection();
            statement = connection.createStatement();
            FileBackedOutputStream outputStream = new FileBackedOutputStream(1000000);
            outputStream.write("hello".getBytes(StandardCharsets.UTF_8));
            outputStream.flush();
            connection.unwrap(SnowflakeConnectionV1.class).uploadStream("~", DEST_PREFIX, outputStream.asByteSource().openStream(), "hello.txt", true);
            ResultSet rset = statement.executeQuery("SELECT $1 FROM @~/" + DEST_PREFIX);
            String ret = null;
            while (rset.next()) {
                ret = rset.getString(1);
            }
            rset.close();
            Assert.assertEquals((String)("Unexpected string value: " + ret + " expect: hello"), (Object)"hello", (Object)ret);
        }
        finally {
            if (statement != null) {
                statement.execute("rm @~/" + DEST_PREFIX);
                statement.close();
            }
            this.closeSQLObjects(resultSet, statement, connection);
        }
    }
}

