/*
 * Decompiled with CFR 0.152.
 */
package net.snowflake.client.jdbc;

import java.io.BufferedWriter;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.StringWriter;
import java.io.Writer;
import java.nio.charset.StandardCharsets;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.Properties;
import net.snowflake.client.ConditionalIgnoreRule;
import net.snowflake.client.RunningOnGithubAction;
import net.snowflake.client.category.TestCategoryOthers;
import net.snowflake.client.jdbc.BaseJDBCTest;
import net.snowflake.client.jdbc.FileBackedOutputStream;
import net.snowflake.client.jdbc.SnowflakeConnection;
import org.apache.commons.io.IOUtils;
import org.junit.Assert;
import org.junit.Ignore;
import org.junit.Rule;
import org.junit.Test;
import org.junit.experimental.categories.Category;
import org.junit.rules.TemporaryFolder;

@Category(value={TestCategoryOthers.class})
public class StreamLatestIT
extends BaseJDBCTest {
    @Rule
    public TemporaryFolder tmpFolder = new TemporaryFolder();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testUnusualStageName() throws Throwable {
        Connection connection = StreamLatestIT.getConnection();
        Statement statement = connection.createStatement();
        try {
            statement.execute("CREATE or replace TABLE \"ice cream (nice)\" (types STRING)");
            FileBackedOutputStream outputStream = new FileBackedOutputStream(1000000);
            outputStream.write("hello".getBytes(StandardCharsets.UTF_8));
            outputStream.flush();
            connection.unwrap(SnowflakeConnection.class).uploadStream("'@%\"ice cream (nice)\"'", null, outputStream.asByteSource().openStream(), "hello.txt", false);
            ResultSet rset = statement.executeQuery("SELECT $1 FROM '@%\"ice cream (nice)\"/'");
            String ret = null;
            while (rset.next()) {
                ret = rset.getString(1);
            }
            rset.close();
            Assert.assertEquals((String)("Unexpected string value: " + ret + " expect: hello"), (Object)"hello", (Object)ret);
            statement.execute("CREATE or replace TABLE \"ice cream (nice)\" (types STRING)");
            connection.unwrap(SnowflakeConnection.class).uploadStream("$$@%\"ice cream (nice)\"$$", null, outputStream.asByteSource().openStream(), "hello.txt", false);
            rset = statement.executeQuery("SELECT $1 FROM $$@%\"ice cream (nice)\"/$$");
            ret = null;
            while (rset.next()) {
                ret = rset.getString(1);
            }
            rset.close();
            Assert.assertEquals((String)("Unexpected string value: " + ret + " expect: hello"), (Object)"hello", (Object)ret);
        }
        finally {
            statement.execute("DROP TABLE IF EXISTS \"ice cream (nice)\"");
            statement.close();
            connection.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    @ConditionalIgnoreRule.ConditionalIgnore(condition=RunningOnGithubAction.class)
    public void testDownloadToStreamBlobNotFoundGCS() throws SQLException {
        Statement statement;
        Connection connection;
        block5: {
            String DEST_PREFIX = TEST_UUID + "/testUploadStream";
            connection = null;
            statement = null;
            try {
                Properties paramProperties = new Properties();
                paramProperties.put("GCS_USE_DOWNSCOPED_CREDENTIAL", (Object)true);
                connection = StreamLatestIT.getConnection("gcpaccount", paramProperties);
                statement = connection.createStatement();
                connection.unwrap(SnowflakeConnection.class).downloadStream("~", DEST_PREFIX + "/abc.gz", true);
                Assert.fail((String)"should throw a storage provider exception for blob not found");
                if (statement == null) break block5;
            }
            catch (Exception ex) {
                block6: {
                    try {
                        Assert.assertTrue((boolean)(ex instanceof SQLException));
                        Assert.assertTrue((String)("Wrong exception message: " + ex.getMessage()), (boolean)ex.getMessage().matches(".*Blob.*not found in bucket.*"));
                        if (statement == null) break block6;
                    }
                    catch (Throwable throwable) {
                        if (statement != null) {
                            statement.execute("rm @~/" + DEST_PREFIX);
                            statement.close();
                        }
                        this.closeSQLObjects(statement, connection);
                        throw throwable;
                    }
                    statement.execute("rm @~/" + DEST_PREFIX);
                    statement.close();
                }
                this.closeSQLObjects(statement, connection);
            }
            statement.execute("rm @~/" + DEST_PREFIX);
            statement.close();
        }
        this.closeSQLObjects(statement, connection);
    }

    @Test
    @Ignore
    public void testDownloadToStreamGCSPresignedUrl() throws SQLException, IOException {
        String DEST_PREFIX = "testUploadStream";
        Connection connection = null;
        Statement statement = null;
        connection = StreamLatestIT.getConnection("gcpaccount");
        statement = connection.createStatement();
        statement.execute("create or replace stage testgcpstage");
        ResultSet rset = statement.executeQuery("PUT file://" + StreamLatestIT.getFullPathFileInResource("orders_100.csv") + " @testgcpstage/" + "testUploadStream");
        Assert.assertTrue((boolean)rset.next());
        Assert.assertEquals((String)("Error message:" + rset.getString(8)), (Object)"UPLOADED", (Object)rset.getString(7));
        InputStream out = connection.unwrap(SnowflakeConnection.class).downloadStream("@testgcpstage", "testUploadStream/orders_100.csv.gz", true);
        StringWriter writer = new StringWriter();
        IOUtils.copy((InputStream)out, (Writer)writer, (String)"UTF-8");
        String output = writer.toString();
        Assert.assertEquals((Object)"1|", (Object)output.substring(0, 2));
        String[] lines = output.split("\n");
        Assert.assertEquals((long)28L, (long)lines.length);
        statement.execute("rm @~/testUploadStream");
        statement.close();
        this.closeSQLObjects(statement, connection);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    @ConditionalIgnoreRule.ConditionalIgnore(condition=RunningOnGithubAction.class)
    public void testDownloadToStreamGCS() throws SQLException, IOException {
        String DEST_PREFIX = TEST_UUID + "/testUploadStream";
        Connection connection = null;
        Statement statement = null;
        Properties paramProperties = new Properties();
        paramProperties.put("GCS_USE_DOWNSCOPED_CREDENTIAL", (Object)true);
        try {
            connection = StreamLatestIT.getConnection("gcpaccount", paramProperties);
            statement = connection.createStatement();
            ResultSet rset = statement.executeQuery("PUT file://" + StreamLatestIT.getFullPathFileInResource("orders_100.csv") + " @~/" + DEST_PREFIX);
            Assert.assertTrue((boolean)rset.next());
            Assert.assertEquals((Object)"UPLOADED", (Object)rset.getString(7));
            InputStream out = connection.unwrap(SnowflakeConnection.class).downloadStream("~", DEST_PREFIX + "/" + "orders_100.csv" + ".gz", true);
            StringWriter writer = new StringWriter();
            IOUtils.copy((InputStream)out, (Writer)writer, (String)"UTF-8");
            String output = writer.toString();
            Assert.assertEquals((Object)"1|", (Object)output.substring(0, 2));
            String[] lines = output.split("\n");
            Assert.assertEquals((long)28L, (long)lines.length);
        }
        finally {
            if (statement != null) {
                statement.execute("rm @~/" + DEST_PREFIX);
                statement.close();
            }
            this.closeSQLObjects(statement, connection);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testSpecialCharactersInFileName() throws SQLException, IOException {
        Connection connection = null;
        Statement statement = null;
        try {
            connection = StreamLatestIT.getConnection();
            statement = connection.createStatement();
            File specialCharFile = this.tmpFolder.newFile("(special char@).txt");
            BufferedWriter bw = new BufferedWriter(new FileWriter(specialCharFile));
            bw.write("Creating test file for downloadStream test");
            bw.close();
            String sourceFilePath = specialCharFile.getCanonicalPath();
            String sourcePathEscaped = System.getProperty("file.separator").equals("\\") ? sourceFilePath.replace("\\", "\\\\") : sourceFilePath;
            statement.execute("CREATE OR REPLACE STAGE downloadStream_stage");
            statement.execute("PUT 'file://" + sourcePathEscaped + "' @~/downloadStream_stage auto_compress=false");
            InputStream out = connection.unwrap(SnowflakeConnection.class).downloadStream("~", "/downloadStream_stage/" + specialCharFile.getName(), false);
            StringWriter writer = new StringWriter();
            IOUtils.copy((InputStream)out, (Writer)writer, (String)"UTF-8");
            String output = writer.toString();
            Assert.assertEquals((Object)"Creating test file for downloadStream test", (Object)output);
        }
        finally {
            if (statement != null) {
                statement.execute("DROP STAGE IF EXISTS downloadStream_stage");
                statement.close();
            }
        }
    }
}

