/*
 * Decompiled with CFR 0.152.
 */
package net.snowflake.client.jdbc.cloud.storage;

import java.sql.Connection;
import java.sql.SQLException;
import net.snowflake.client.ConditionalIgnoreRule;
import net.snowflake.client.RunningOnGithubAction;
import net.snowflake.client.core.SFBaseSession;
import net.snowflake.client.core.SFSession;
import net.snowflake.client.core.SFStatement;
import net.snowflake.client.jdbc.BaseJDBCTest;
import net.snowflake.client.jdbc.SnowflakeConnectionV1;
import net.snowflake.client.jdbc.SnowflakeFileTransferAgent;
import net.snowflake.client.jdbc.SnowflakeSQLLoggedException;
import net.snowflake.client.jdbc.cloud.storage.SnowflakeAzureClient;
import net.snowflake.client.jdbc.cloud.storage.StageInfo;
import net.snowflake.common.core.RemoteStoreFileEncryptionMaterial;
import org.junit.Assert;
import org.junit.Test;

public class SnowflakeAzureClientLatestIT
extends BaseJDBCTest {
    @Test
    @ConditionalIgnoreRule.ConditionalIgnore(condition=RunningOnGithubAction.class)
    public void testAzureClientSetupInvalidEncryptionKeySize() throws SQLException {
        try (Connection connection = SnowflakeAzureClientLatestIT.getConnection("azureaccount");){
            SFSession sfSession = connection.unwrap(SnowflakeConnectionV1.class).getSfSession();
            String putCommand = "put file:///dummy/path/file1.gz @~";
            SnowflakeFileTransferAgent sfAgent = new SnowflakeFileTransferAgent(putCommand, sfSession, new SFStatement(sfSession));
            RemoteStoreFileEncryptionMaterial content = new RemoteStoreFileEncryptionMaterial("EXAMPLEQUERYSTAGEMASTERKEY", "EXAMPLEQUERYID", Long.valueOf(123L));
            try {
                SnowflakeAzureClient.createSnowflakeAzureClient((StageInfo)sfAgent.getStageInfo(), (RemoteStoreFileEncryptionMaterial)content, (SFBaseSession)sfSession);
                Assert.fail();
            }
            catch (SnowflakeSQLLoggedException ex) {
                Assert.assertEquals((long)200001L, (long)ex.getErrorCode());
            }
        }
    }
}

