/*
 * Decompiled with CFR 0.152.
 */
package net.snowflake.client.jdbc.cloud.storage;

import com.microsoft.azure.storage.StorageExtendedErrorInformation;
import java.util.LinkedHashMap;
import net.snowflake.client.jdbc.cloud.storage.SnowflakeAzureClient;
import org.junit.Assert;
import org.junit.Test;

public class SnowflakeAzureClientTest {
    @Test
    public void testFormatStorageExtendedErrorInformation() {
        String expectedStr0 = "StorageExceptionExtendedErrorInformation: {ErrorCode= 403, ErrorMessage= Server refuses to authorize the request, AdditionalDetails= {}}";
        String expectedStr1 = "StorageExceptionExtendedErrorInformation: {ErrorCode= 403, ErrorMessage= Server refuses to authorize the request, AdditionalDetails= { key1= helloworld,key2= ,key3= fakemessage}}";
        StorageExtendedErrorInformation info = new StorageExtendedErrorInformation();
        info.setErrorCode("403");
        info.setErrorMessage("Server refuses to authorize the request");
        String formatedStr = SnowflakeAzureClient.FormatStorageExtendedErrorInformation((StorageExtendedErrorInformation)info);
        Assert.assertEquals((Object)expectedStr0, (Object)formatedStr);
        LinkedHashMap<String, String[]> map = new LinkedHashMap<String, String[]>();
        map.put("key1", new String[]{"hello", "world"});
        map.put("key2", new String[0]);
        map.put("key3", new String[]{"fake", "message"});
        info.setAdditionalDetails(map);
        formatedStr = SnowflakeAzureClient.FormatStorageExtendedErrorInformation((StorageExtendedErrorInformation)info);
        Assert.assertEquals((Object)expectedStr1, (Object)formatedStr);
    }

    @Test
    public void testFormatStorageExtendedErrorEmptyInformation() {
        String formatedStr = SnowflakeAzureClient.FormatStorageExtendedErrorInformation(null);
        Assert.assertEquals((Object)"", (Object)formatedStr);
    }
}

