/*
 * Decompiled with CFR 0.152.
 */
package net.snowflake.client.jdbc.cloud.storage;

import com.amazonaws.AmazonServiceException;
import com.amazonaws.ClientConfiguration;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.Properties;
import net.snowflake.client.ConditionalIgnoreRule;
import net.snowflake.client.RunningOnGithubAction;
import net.snowflake.client.core.SFBaseSession;
import net.snowflake.client.core.SFSession;
import net.snowflake.client.core.SFStatement;
import net.snowflake.client.jdbc.BaseJDBCTest;
import net.snowflake.client.jdbc.SnowflakeConnectionV1;
import net.snowflake.client.jdbc.SnowflakeFileTransferAgent;
import net.snowflake.client.jdbc.cloud.storage.SnowflakeS3Client;
import net.snowflake.client.jdbc.cloud.storage.StageInfo;
import net.snowflake.common.core.RemoteStoreFileEncryptionMaterial;
import org.junit.Assert;
import org.junit.Ignore;
import org.junit.Test;
import org.mockito.Mockito;
import org.mockito.verification.VerificationMode;

public class SnowflakeS3ClientLatestIT
extends BaseJDBCTest {
    @Test
    @ConditionalIgnoreRule.ConditionalIgnore(condition=RunningOnGithubAction.class)
    public void testS3Client256Encryption() throws SQLException {
        try (Connection connection = SnowflakeS3ClientLatestIT.getConnection("s3testaccount");){
            SFSession sfSession = connection.unwrap(SnowflakeConnectionV1.class).getSfSession();
            String putCommand = "put file:///dummy/path/file1.gz @~";
            SnowflakeFileTransferAgent sfAgent = new SnowflakeFileTransferAgent(putCommand, sfSession, new SFStatement(sfSession));
            RemoteStoreFileEncryptionMaterial content = new RemoteStoreFileEncryptionMaterial("LHMTKHLETLKHPSTADDGAESLFKREYGHFHGHGSDHJKLMH", "123456", Long.valueOf(123L));
            StageInfo info = sfAgent.getStageInfo();
            ClientConfiguration config = new ClientConfiguration();
            SnowflakeS3Client client = new SnowflakeS3Client(info.getCredentials(), config, content, info.getProxyProperties(), info.getRegion(), info.getEndPoint(), info.getIsClientSideEncrypted(), (SFBaseSession)sfSession, info.getUseS3RegionalUrl());
            Assert.assertEquals((long)256L, (long)client.getEncryptionKeySize());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    @Ignore
    public void testS3ConnectionWithProxyEnvVariablesSet() throws SQLException {
        Connection connection = null;
        String testStageName = "s3TestStage";
        try {
            connection = SnowflakeS3ClientLatestIT.getConnection();
            Statement statement = connection.createStatement();
            ResultSet resultSet = statement.executeQuery("select 1");
            Assert.assertTrue((boolean)resultSet.next());
            statement.execute("create or replace stage " + testStageName);
            resultSet = connection.createStatement().executeQuery("PUT file://" + SnowflakeS3ClientLatestIT.getFullPathFileInResource("orders_100.csv") + " @" + testStageName);
            while (resultSet.next()) {
                Assert.assertEquals((Object)"UPLOADED", (Object)resultSet.getString("status"));
            }
        }
        finally {
            if (connection != null) {
                connection.createStatement().execute("DROP STAGE if exists " + testStageName);
                connection.close();
            }
        }
    }

    @Test
    @ConditionalIgnoreRule.ConditionalIgnore(condition=RunningOnGithubAction.class)
    public void testIsClientException400Or404() throws SQLException {
        AmazonServiceException servEx = new AmazonServiceException("S3 operation failed");
        servEx.setServiceName("Amazon S3");
        servEx.setErrorMessage("Bad Request");
        servEx.setStatusCode(400);
        servEx.setErrorCode("400 Bad Request");
        servEx.setErrorType(AmazonServiceException.ErrorType.Client);
        try (Connection connection = SnowflakeS3ClientLatestIT.getConnection("s3testaccount");){
            SFSession sfSession = connection.unwrap(SnowflakeConnectionV1.class).getSfSession();
            String getCommand = "GET '@~/testStage' 'file://C:/temp' PARALLEL=8";
            SnowflakeFileTransferAgent agent = new SnowflakeFileTransferAgent(getCommand, sfSession, new SFStatement(sfSession));
            RemoteStoreFileEncryptionMaterial content = new RemoteStoreFileEncryptionMaterial("LHMTKHLETLKHPSTADDGAESLFKREYGHFHGHGSDHJKLMH", "123456", Long.valueOf(123L));
            StageInfo info = agent.getStageInfo();
            ClientConfiguration clientConfig = new ClientConfiguration();
            SnowflakeS3Client client = new SnowflakeS3Client(info.getCredentials(), clientConfig, content, info.getProxyProperties(), info.getRegion(), info.getEndPoint(), info.getIsClientSideEncrypted(), (SFBaseSession)sfSession, info.getUseS3RegionalUrl());
            Assert.assertTrue((boolean)client.isClientException400Or404((Exception)servEx));
        }
    }

    @Test
    @ConditionalIgnoreRule.ConditionalIgnore(condition=RunningOnGithubAction.class)
    public void testPutGetMaxRetries() throws SQLException {
        Properties props = new Properties();
        props.put("putGetMaxRetries", (Object)1);
        try (Connection connection = SnowflakeS3ClientLatestIT.getConnection("s3testaccount", props);){
            SFSession sfSession = connection.unwrap(SnowflakeConnectionV1.class).getSfSession();
            String command = "GET '@~/testStage' 'file://C:/temp' PARALLEL=8";
            SnowflakeFileTransferAgent agent = new SnowflakeFileTransferAgent(command, sfSession, new SFStatement(sfSession));
            StageInfo info = agent.getStageInfo();
            ClientConfiguration clientConfig = new ClientConfiguration();
            RemoteStoreFileEncryptionMaterial content = new RemoteStoreFileEncryptionMaterial("LHMTKHLETLKHPSTADDGAESLFKREYGHFHGHGSDHJKLMH", "123456", Long.valueOf(123L));
            SnowflakeS3Client client = new SnowflakeS3Client(info.getCredentials(), clientConfig, content, info.getProxyProperties(), info.getRegion(), info.getEndPoint(), info.getIsClientSideEncrypted(), (SFBaseSession)sfSession, info.getUseS3RegionalUrl());
            SnowflakeS3Client spy = (SnowflakeS3Client)Mockito.spy((Object)client);
            try {
                spy.handleStorageException((Exception)new InterruptedException(), 0, "download", sfSession, command);
            }
            catch (Exception e) {
                Assert.fail((String)"Should not have exception here");
            }
            ((SnowflakeS3Client)Mockito.verify((Object)spy, (VerificationMode)Mockito.never())).renew(Mockito.anyMap());
            spy.handleStorageException((Exception)new InterruptedException(), 1, "download", sfSession, command);
        }
    }
}

