/*
 * Decompiled with CFR 0.152.
 */
package net.snowflake.client.jdbc.telemetry;

import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.node.ObjectNode;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.Paths;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.Map;
import net.snowflake.client.AbstractDriverIT;
import net.snowflake.client.ConditionalIgnoreRule;
import net.snowflake.client.RunningOnGithubAction;
import net.snowflake.client.category.TestCategoryCore;
import net.snowflake.client.core.HttpUtil;
import net.snowflake.client.core.SFException;
import net.snowflake.client.core.SessionUtil;
import net.snowflake.client.jdbc.telemetry.TelemetryClient;
import net.snowflake.client.jdbc.telemetry.TelemetryData;
import org.apache.http.impl.client.CloseableHttpClient;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Ignore;
import org.junit.Test;
import org.junit.experimental.categories.Category;

@Category(value={TestCategoryCore.class})
public class TelemetryIT
extends AbstractDriverIT {
    private Connection connection = null;
    private static final ObjectMapper mapper = new ObjectMapper();

    @Before
    public void init() throws SQLException, IOException {
        this.connection = TelemetryIT.getConnection();
    }

    @Test
    public void testTelemetry() throws Exception {
        TelemetryClient telemetry = (TelemetryClient)TelemetryClient.createTelemetry((Connection)this.connection, (int)100);
        this.testTelemetryInternal(telemetry);
    }

    @Ignore
    @Test
    @ConditionalIgnoreRule.ConditionalIgnore(condition=RunningOnGithubAction.class)
    public void testJWTSessionlessTelemetry() throws Exception, SFException {
        this.testTelemetryInternal(this.createJWTSessionlessTelemetry());
    }

    @Ignore
    @Test
    @ConditionalIgnoreRule.ConditionalIgnore(condition=RunningOnGithubAction.class)
    public void testOAuthSessionlessTelemetry() throws Exception, SFException {
        this.testTelemetryInternal(this.createOAuthSessionlessTelemetry());
    }

    private void testTelemetryInternal(TelemetryClient telemetry) throws Exception {
        ObjectNode node1 = mapper.createObjectNode();
        node1.put("type", "query");
        node1.put("query_id", "sdasdasdasdasds");
        ObjectNode node2 = mapper.createObjectNode();
        node2.put("type", "query");
        node2.put("query_id", "eqweqweqweqwe");
        telemetry.addLogToBatch(node1, 1234567L);
        telemetry.addLogToBatch(new TelemetryData(node2, 22345678L));
        Assert.assertEquals((long)telemetry.bufferSize(), (long)2L);
        Assert.assertTrue((boolean)((Boolean)telemetry.sendBatchAsync().get()));
        Assert.assertEquals((long)telemetry.bufferSize(), (long)0L);
        Assert.assertTrue((boolean)telemetry.sendLog(node1, 1234567L));
        Assert.assertEquals((long)telemetry.bufferSize(), (long)0L);
        Assert.assertTrue((boolean)telemetry.sendLog(new TelemetryData(node2, 22345678L)));
        Assert.assertEquals((long)telemetry.bufferSize(), (long)0L);
        for (int i = 0; i < 99; ++i) {
            telemetry.addLogToBatch(node1, 1111L);
        }
        Assert.assertEquals((long)telemetry.bufferSize(), (long)99L);
        telemetry.addLogToBatch(node1, 222L);
        Thread.sleep(1000L);
        Assert.assertEquals((long)telemetry.bufferSize(), (long)0L);
        telemetry.addLogToBatch(node1, 111L);
        Assert.assertEquals((long)telemetry.bufferSize(), (long)1L);
        Assert.assertFalse((boolean)telemetry.isClosed());
        telemetry.close();
        Assert.assertTrue((boolean)telemetry.isClosed());
        Assert.assertEquals((long)telemetry.bufferSize(), (long)0L);
    }

    @Test
    public void close1() {
        TelemetryClient telemetry = (TelemetryClient)TelemetryClient.createTelemetry((Connection)this.connection);
        telemetry.close();
        ObjectNode node = mapper.createObjectNode();
        node.put("type", "query");
        node.put("query_id", "sdasdasdasdasds");
        telemetry.addLogToBatch(node, 1234567L);
    }

    @Test
    public void close2() {
        TelemetryClient telemetry = (TelemetryClient)TelemetryClient.createTelemetry((Connection)this.connection);
        telemetry.close();
        ObjectNode node = mapper.createObjectNode();
        node.put("type", "query");
        node.put("query_id", "sdasdasdasdasds");
        telemetry.addLogToBatch(new TelemetryData(node, 1234567L));
    }

    @Test
    public void close3() {
        TelemetryClient telemetry = (TelemetryClient)TelemetryClient.createTelemetry((Connection)this.connection);
        telemetry.close();
        telemetry.close();
    }

    @Test
    public void testDisableTelemetry() throws Exception {
        TelemetryClient telemetry = (TelemetryClient)TelemetryClient.createTelemetry((Connection)this.connection, (int)100);
        this.testDisableTelemetryInternal(telemetry);
    }

    @Test
    @ConditionalIgnoreRule.ConditionalIgnore(condition=RunningOnGithubAction.class)
    public void testDisableJWTSessionlessTelemetry() throws Exception, SFException {
        this.testDisableTelemetryInternal(this.createJWTSessionlessTelemetry());
    }

    @Test
    @ConditionalIgnoreRule.ConditionalIgnore(condition=RunningOnGithubAction.class)
    public void testDisableOAuthSessionlessTelemetry() throws Exception, SFException {
        this.testDisableTelemetryInternal(this.createOAuthSessionlessTelemetry());
    }

    public void testDisableTelemetryInternal(TelemetryClient telemetry) throws Exception {
        ObjectNode node1 = mapper.createObjectNode();
        node1.put("type", "query");
        node1.put("query_id", "sdasdasdasdasds");
        ObjectNode node2 = mapper.createObjectNode();
        node2.put("type", "query");
        node2.put("query_id", "eqweqweqweqwe");
        telemetry.addLogToBatch(node1, 1234567L);
        Assert.assertEquals((long)telemetry.bufferSize(), (long)1L);
        telemetry.disableTelemetry();
        Assert.assertFalse((boolean)telemetry.isTelemetryEnabled());
        telemetry.addLogToBatch(new TelemetryData(node2, 22345678L));
        Assert.assertEquals((long)telemetry.bufferSize(), (long)1L);
        Assert.assertFalse((boolean)((Boolean)telemetry.sendBatchAsync().get()));
        Assert.assertEquals((long)telemetry.bufferSize(), (long)1L);
        Assert.assertFalse((boolean)telemetry.sendLog(node1, 1234567L));
        Assert.assertEquals((long)telemetry.bufferSize(), (long)1L);
        Assert.assertFalse((boolean)telemetry.sendLog(new TelemetryData(node2, 22345678L)));
        Assert.assertEquals((long)telemetry.bufferSize(), (long)1L);
    }

    @Test
    @ConditionalIgnoreRule.ConditionalIgnore(condition=RunningOnGithubAction.class)
    public void testClosedJWTSessionlessTelemetry() throws Exception, SFException {
        TelemetryClient telemetry = this.createJWTSessionlessTelemetry();
        telemetry.close();
        ObjectNode node = mapper.createObjectNode();
        node.put("type", "query");
        node.put("query_id", "sdasdasdasdasds");
        telemetry.addLogToBatch(node, 1234567L);
        Assert.assertFalse((boolean)((Boolean)telemetry.sendBatchAsync().get()));
    }

    @Test
    @ConditionalIgnoreRule.ConditionalIgnore(condition=RunningOnGithubAction.class)
    public void testClosedOAuthSessionlessTelemetry() throws Exception, SFException {
        TelemetryClient telemetry = this.createOAuthSessionlessTelemetry();
        telemetry.close();
        ObjectNode node = mapper.createObjectNode();
        node.put("type", "query");
        node.put("query_id", "sdasdasdasdasds");
        telemetry.addLogToBatch(node, 1234567L);
        Assert.assertFalse((boolean)((Boolean)telemetry.sendBatchAsync().get()));
    }

    private TelemetryClient createJWTSessionlessTelemetry() throws SFException, SQLException, IOException {
        this.setUpPublicKey();
        String privateKeyLocation = TelemetryIT.getFullPathFileInResource("rsa_key.p8");
        Map<String, String> parameters = TelemetryIT.getConnectionParameters();
        String jwtToken = SessionUtil.generateJWTToken(null, (String)privateKeyLocation, null, (String)parameters.get("account"), (String)parameters.get("user"));
        CloseableHttpClient httpClient = HttpUtil.buildHttpClient(null, null, (boolean)false);
        TelemetryClient telemetry = (TelemetryClient)TelemetryClient.createSessionlessTelemetry((CloseableHttpClient)httpClient, (String)String.format("%s:%s", parameters.get("host"), parameters.get("port")), (String)"KEYPAIR_JWT");
        telemetry.refreshToken(jwtToken);
        return telemetry;
    }

    private void setUpPublicKey() throws SQLException, IOException {
        Map<String, String> parameters = TelemetryIT.getConnectionParameters();
        String testUser = parameters.get("user");
        Connection connection = TelemetryIT.getConnection();
        Statement statement = connection.createStatement();
        statement.execute("use role accountadmin");
        String pathfile = TelemetryIT.getFullPathFileInResource("rsa_key.pub");
        String pubKey = new String(Files.readAllBytes(Paths.get(pathfile, new String[0])));
        pubKey = pubKey.replace("-----BEGIN PUBLIC KEY-----", "");
        pubKey = pubKey.replace("-----END PUBLIC KEY-----", "");
        statement.execute(String.format("alter user %s set rsa_public_key='%s'", testUser, pubKey));
        connection.close();
    }

    private TelemetryClient createOAuthSessionlessTelemetry() throws SFException, SQLException, IOException {
        String oAuthToken = this.getOAuthToken();
        Map<String, String> parameters = TelemetryIT.getConnectionParameters();
        CloseableHttpClient httpClient = HttpUtil.buildHttpClient(null, null, (boolean)false);
        TelemetryClient telemetry = (TelemetryClient)TelemetryClient.createSessionlessTelemetry((CloseableHttpClient)httpClient, (String)String.format("%s:%s", parameters.get("host"), parameters.get("port")), (String)"OAUTH");
        telemetry.refreshToken(oAuthToken);
        return telemetry;
    }

    private String getOAuthToken() throws SQLException {
        Map<String, String> parameters = TelemetryIT.getConnectionParameters();
        Connection connection = TelemetryIT.getConnection();
        Statement statement = connection.createStatement();
        statement.execute("use role accountadmin");
        statement.execute("create or replace security integration telemetry_oauth_integration\n  type=oauth\n  oauth_client=CUSTOM\n  oauth_client_type=CONFIDENTIAL\n  oauth_redirect_uri='https://localhost.com/oauth'\n  oauth_issue_refresh_tokens=true\n  enabled=true oauth_refresh_token_validity=86400;");
        String role = parameters.get("role");
        ResultSet resultSet = statement.executeQuery("select system$it('create_oauth_access_token', 'TELEMETRY_OAUTH_INTEGRATION', '" + role + "')");
        resultSet.next();
        String token = resultSet.getString(1);
        connection.close();
        return token;
    }
}

