/*
 * Decompiled with CFR 0.152.
 */
package net.snowflake.client.jdbc.telemetryOOB;

import java.sql.Connection;
import java.sql.SQLException;
import java.sql.SQLFeatureNotSupportedException;
import java.sql.Statement;
import java.util.Properties;
import java.util.concurrent.TimeUnit;
import net.snowflake.client.ConditionalIgnoreRule;
import net.snowflake.client.RunningNotOnTestaccount;
import net.snowflake.client.category.TestCategoryCore;
import net.snowflake.client.core.SFBaseSession;
import net.snowflake.client.core.SFSession;
import net.snowflake.client.jdbc.BaseJDBCTest;
import net.snowflake.client.jdbc.SnowflakeConnectionV1;
import net.snowflake.client.jdbc.SnowflakeLoggedFeatureNotSupportedException;
import net.snowflake.client.jdbc.SnowflakeSQLLoggedException;
import net.snowflake.client.jdbc.telemetryOOB.TelemetryEvent;
import net.snowflake.client.jdbc.telemetryOOB.TelemetryService;
import org.apache.commons.lang3.time.StopWatch;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Ignore;
import org.junit.Test;
import org.junit.experimental.categories.Category;

@Category(value={TestCategoryCore.class})
public class TelemetryServiceIT
extends BaseJDBCTest {
    private static final int WAIT_FOR_TELEMETRY_REPORT_IN_MILLISECS = 5000;
    private boolean defaultState;

    @Before
    public void setUp() {
        TelemetryService service = TelemetryService.getInstance();
        service.updateContextForIT(TelemetryServiceIT.getConnectionParameters());
        this.defaultState = service.isEnabled();
        service.enable();
    }

    @After
    public void tearDown() throws InterruptedException {
        TimeUnit.SECONDS.sleep(5L);
        TelemetryService service = TelemetryService.getInstance();
        if (this.defaultState) {
            service.enable();
        } else {
            service.disable();
        }
    }

    @Ignore
    @Test
    public void testCreateException() {
        TelemetryService service = TelemetryService.getInstance();
        try {
            int n = 10 / 0;
        }
        catch (Exception ex) {
            TelemetryEvent.LogBuilder logBuilder = new TelemetryEvent.LogBuilder();
            TelemetryEvent log = logBuilder.withException(ex).build();
            System.out.println(log);
            service.report(log);
            TelemetryEvent.MetricBuilder mBuilder = new TelemetryEvent.MetricBuilder();
            TelemetryEvent metric = ((TelemetryEvent.MetricBuilder)mBuilder.withException(ex).withTag("domain", "test")).build();
            System.out.println(metric);
            service.report(metric);
        }
    }

    @Ignore
    @Test
    public void testWrongServerURL() throws InterruptedException {
        TelemetryService service = TelemetryService.getInstance();
        TelemetryEvent.LogBuilder logBuilder = new TelemetryEvent.LogBuilder();
        TelemetryEvent log = ((TelemetryEvent.LogBuilder)logBuilder.withName("ExampleLog")).withValue("This is an example log").build();
        int count = service.getEventCount();
        service.report(log);
        int i = 6;
        while (i-- > 0) {
            TimeUnit.SECONDS.sleep(5L);
            if (service.getEventCount() <= count) continue;
        }
        MatcherAssert.assertThat((String)"WrongServerURL do not block.", (service.getEventCount() > count ? 1 : 0) != 0);
    }

    @Ignore
    @Test
    public void testCreateLog() {
        TelemetryService service = TelemetryService.getInstance();
        TelemetryEvent.LogBuilder logBuilder = new TelemetryEvent.LogBuilder();
        TelemetryEvent log = ((TelemetryEvent.LogBuilder)logBuilder.withName("ExampleLog")).withValue("This is an example log").build();
        MatcherAssert.assertThat((String)"check log value", (boolean)log.get((Object)"Value").equals("This is an example log"));
        service.report(log);
    }

    @Ignore
    @Test
    public void testCreateLogWithAWSSecret() {
        TelemetryEvent.LogBuilder logBuilder;
        TelemetryEvent log;
        TelemetryService service = TelemetryService.getInstance();
        String marked = service.exportQueueToString(log = ((TelemetryEvent.LogBuilder)(logBuilder = new TelemetryEvent.LogBuilder()).withName("ExampleLog")).withValue("This is an example log: credentials=(\n  aws_key_id='xxdsdfsafds'\n  aws_secret_key='safas+asfsad+safasf')\n").build());
        MatcherAssert.assertThat((String)"marked aws_key_id", (!marked.contains("xxdsdfsafds") ? 1 : 0) != 0);
        MatcherAssert.assertThat((String)"marked aws_secret_key", (!marked.contains("safas+asfsad+safasf") ? 1 : 0) != 0);
        service.report(log);
    }

    @Ignore
    @Test
    public void stressTestCreateLog() {
        TelemetryService service = TelemetryService.getInstance();
        StopWatch sw = new StopWatch();
        sw.start();
        int rate = 50;
        int sent = 0;
        int duration = 60;
        while (sw.getTime() < (long)(duration * 1000)) {
            int toSend = (int)(sw.getTime() / 1000L) * rate - sent;
            for (int i = 0; i < toSend; ++i) {
                TelemetryEvent log = ((TelemetryEvent.LogBuilder)new TelemetryEvent.LogBuilder().withName("StressTestLog")).withValue("This is an example log for stress test " + sent).build();
                System.out.println("stress test: " + sent++ + " sent.");
                service.report(log);
            }
        }
        sw.stop();
    }

    @Ignore
    @Test
    public void testCreateLogInBlackList() {
        TelemetryService service = TelemetryService.getInstance();
        TelemetryEvent.LogBuilder logBuilder = new TelemetryEvent.LogBuilder();
        TelemetryEvent log = ((TelemetryEvent.LogBuilder)logBuilder.withName("unknown")).withValue("This is a log in blacklist").build();
        service.report(log);
    }

    @Ignore
    @Test
    public void testCreateUrgentEvent() {
        TelemetryService service = TelemetryService.getInstance();
        TelemetryEvent.LogBuilder logBuilder = new TelemetryEvent.LogBuilder();
        TelemetryEvent log = ((TelemetryEvent.LogBuilder)logBuilder.withName("UrgentLog")).withValue("This is an example urgent log").build();
        MatcherAssert.assertThat((String)"check log value", (boolean)log.get((Object)"Value").equals("This is an example urgent log"));
        service.report(log);
    }

    @Ignore
    @Test
    public void stressTestCreateUrgentEvent() {
        TelemetryService service = TelemetryService.getInstance();
        StopWatch sw = new StopWatch();
        sw.start();
        int rate = 1;
        int sent = 0;
        int duration = 5;
        while (sw.getTime() < (long)(duration * 1000)) {
            int toSend = (int)(sw.getTime() / 1000L) * rate - sent;
            for (int i = 0; i < toSend; ++i) {
                TelemetryEvent log = ((TelemetryEvent.LogBuilder)new TelemetryEvent.LogBuilder().withName("StressUrgentTestLog")).withValue("This is an example urgent log for stress test " + sent).build();
                System.out.println("stress test: " + sent++ + " sent.");
                service.report(log);
            }
        }
        sw.stop();
    }

    private void generateDummyException(int vendorCode, SFSession session) throws SnowflakeSQLLoggedException {
        String queryID = "01234567-1234-1234-1234-00001abcdefg";
        String reason = "This is a test exception.";
        String sqlState = "02000";
        throw new SnowflakeSQLLoggedException((SFBaseSession)session, reason, sqlState, vendorCode, queryID);
    }

    private int generateSQLFeatureNotSupportedException() throws SQLFeatureNotSupportedException {
        throw new SnowflakeLoggedFeatureNotSupportedException(null);
    }

    @Test
    @ConditionalIgnoreRule.ConditionalIgnore(condition=RunningNotOnTestaccount.class)
    public void testSnowflakeSQLLoggedExceptionOOBTelemetry() throws SQLException, InterruptedException {
        block2: {
            int fakeVendorCode = 27;
            try {
                this.generateDummyException(fakeVendorCode, null);
                Assert.fail();
            }
            catch (SnowflakeSQLLoggedException e) {
                MatcherAssert.assertThat((String)"Communication error", (Object)e.getErrorCode(), (Matcher)CoreMatchers.equalTo((Object)fakeVendorCode));
                Thread.sleep(5000L);
                if (!TelemetryService.getInstance().isDeploymentEnabled()) break block2;
                MatcherAssert.assertThat((String)("Telemetry event has not been reported successfully. Error: " + TelemetryService.getInstance().getLastClientError()), (Object)TelemetryService.getInstance().getClientFailureCount(), (Matcher)CoreMatchers.equalTo((Object)0));
            }
        }
    }

    @Test
    @ConditionalIgnoreRule.ConditionalIgnore(condition=RunningNotOnTestaccount.class)
    public void testSQLFeatureNotSupportedOOBTelemetry() throws InterruptedException {
        block2: {
            try {
                this.generateSQLFeatureNotSupportedException();
                Assert.fail((String)"SqlFeatureNotSupportedException failed to throw.");
            }
            catch (SQLFeatureNotSupportedException e) {
                Thread.sleep(5000L);
                if (!TelemetryService.getInstance().isDeploymentEnabled()) break block2;
                MatcherAssert.assertThat((String)("Telemetry event has not been reported successfully. Error: " + TelemetryService.getInstance().getLastClientError()), (Object)TelemetryService.getInstance().getClientFailureCount(), (Matcher)CoreMatchers.equalTo((Object)0));
            }
        }
    }

    @Ignore
    @Test
    public void testHTAPTelemetry() throws SQLException {
        Properties properties = new Properties();
        properties.put("htapOOBTelemetryEnabled", "true");
        properties.put("telemetryDeployment", "qa1");
        try (Connection con = TelemetryServiceIT.getConnection(properties);){
            Statement statement = con.createStatement();
            statement.execute("alter session set CLIENT_OUT_OF_BAND_TELEMETRY_ENABLED=false");
            statement.execute("select 1");
            statement.execute("alter session set CLIENT_OUT_OF_BAND_TELEMETRY_ENABLED=true");
            statement.execute("select 2");
            TelemetryService.disableHTAP();
            statement.execute("select 3");
        }
    }

    @Ignore
    @Test
    public void testOOBTelemetryEnabled() throws SQLException {
        Properties properties = new Properties();
        properties.put("CLIENT_OUT_OF_BAND_TELEMETRY_ENABLED", "true");
        try (Connection con = TelemetryServiceIT.getConnection(properties);){
            Statement statement = con.createStatement();
            statement.execute("select 1");
            Assert.assertTrue((boolean)TelemetryService.getInstance().isEnabled());
        }
    }

    @Ignore
    @Test
    public void testOOBTelemetryDisabled() throws SQLException {
        Properties properties = new Properties();
        properties.put("CLIENT_OUT_OF_BAND_TELEMETRY_ENABLED", "false");
        try (Connection con = TelemetryServiceIT.getConnection(properties);){
            Statement statement = con.createStatement();
            statement.execute("select 1");
            Assert.assertFalse((boolean)TelemetryService.getInstance().isEnabled());
        }
    }

    @Ignore
    @Test
    public void testOOBTelemetryEnabledOnServerDisabledOnClient() throws SQLException {
        Properties properties = new Properties();
        properties.put("CLIENT_OUT_OF_BAND_TELEMETRY_ENABLED", "false");
        try (Connection con = TelemetryServiceIT.getConnection(properties);){
            Statement statement = con.createStatement();
            statement.execute("select 1");
            Assert.assertTrue((boolean)TelemetryService.getInstance().isEnabled());
        }
    }

    @Test
    public void testSnowflakeSQLLoggedExceptionIBTelemetry() throws SQLException {
        try (Connection con = TelemetryServiceIT.getConnection();){
            int fakeErrorCode = 27;
            try {
                this.generateDummyException(fakeErrorCode, con.unwrap(SnowflakeConnectionV1.class).getSfSession());
                Assert.fail();
            }
            catch (SnowflakeSQLLoggedException e) {
                MatcherAssert.assertThat((String)"Communication error", (Object)e.getErrorCode(), (Matcher)CoreMatchers.equalTo((Object)fakeErrorCode));
            }
        }
    }

    @Test(expected=SQLFeatureNotSupportedException.class)
    public void testSqlFeatureNotSupportedExceptionIBTelemetry() throws SQLException {
        try (Connection con = TelemetryServiceIT.getConnection();){
            Statement statement = con.createStatement();
            statement.execute("select 1", new int[0]);
        }
    }
}

