/*
 * Decompiled with CFR 0.152.
 */
package net.snowflake.client.loader;

import java.sql.Connection;
import java.sql.SQLException;
import java.util.Arrays;
import java.util.Date;
import java.util.HashMap;
import java.util.Random;
import net.snowflake.client.AbstractDriverIT;
import net.snowflake.client.loader.LoadResultListener;
import net.snowflake.client.loader.LoaderFactory;
import net.snowflake.client.loader.LoaderProperty;
import net.snowflake.client.loader.Operation;
import net.snowflake.client.loader.ResultListener;
import net.snowflake.client.loader.StreamLoader;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;

class FlatfileRead
implements Runnable {
    private final int totalRows;
    private final String dbName;
    private final String schemaName;
    private final String tableName;
    private final String stageName;

    FlatfileRead(int totalRows, String dbName, String schemaName, String stageName, String tableName) {
        this.totalRows = totalRows;
        this.dbName = dbName;
        this.schemaName = schemaName;
        this.stageName = stageName;
        this.tableName = tableName;
    }

    @Override
    public void run() {
        Connection testConnection = null;
        Connection putConnection = null;
        try {
            testConnection = AbstractDriverIT.getConnection();
            putConnection = AbstractDriverIT.getConnection();
        }
        catch (SQLException e) {
            e.printStackTrace();
        }
        ResultListener _resultListener = new ResultListener();
        HashMap<LoaderProperty, String> prop = new HashMap<LoaderProperty, String>();
        prop.put(LoaderProperty.tableName, this.tableName);
        prop.put(LoaderProperty.schemaName, this.schemaName);
        prop.put(LoaderProperty.databaseName, this.dbName);
        prop.put(LoaderProperty.remoteStage, this.stageName);
        prop.put(LoaderProperty.operation, (String)Operation.INSERT);
        StreamLoader underTest = (StreamLoader)LoaderFactory.createLoader(prop, (Connection)putConnection, (Connection)testConnection);
        underTest.setProperty(LoaderProperty.startTransaction, (Object)true);
        underTest.setProperty(LoaderProperty.truncateTable, (Object)false);
        underTest.setProperty(LoaderProperty.columns, Arrays.asList("ID", "C1"));
        underTest.setListener((LoadResultListener)_resultListener);
        underTest.start();
        Random rnd = new Random();
        for (int i = 0; i < this.totalRows; ++i) {
            Object[] row = new Object[2];
            row[0] = i;
            long ms = -946771200000L + Math.abs(rnd.nextLong()) % 2207520000000L;
            row[1] = new Date(ms);
            underTest.submitRow(row);
        }
        try {
            underTest.finish();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        underTest.close();
        MatcherAssert.assertThat((String)"must be no error", (Object)_resultListener.getErrorCount(), (Matcher)CoreMatchers.equalTo((Object)0));
        MatcherAssert.assertThat((String)"total number of rows", (Object)_resultListener.getSubmittedRowCount(), (Matcher)CoreMatchers.equalTo((Object)this.totalRows));
    }
}

