/*
 * Decompiled with CFR 0.152.
 */
package net.snowflake.client.loader;

import java.sql.Connection;
import java.sql.ResultSet;
import net.snowflake.client.AbstractDriverIT;
import net.snowflake.client.category.TestCategoryLoader;
import net.snowflake.client.loader.FlatfileRead;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.junit.AfterClass;
import org.junit.BeforeClass;
import org.junit.Test;
import org.junit.experimental.categories.Category;

@Category(value={TestCategoryLoader.class})
public class FlatfileReadMultithreadIT {
    private final int NUM_RECORDS = 100000;
    private static final String TARGET_STAGE = "STAGE_MULTITHREAD_LOADER";
    private static String TARGET_SCHEMA;
    private static String TARGET_DB;

    @BeforeClass
    public static void setUpClass() throws Throwable {
        Connection testConnection = AbstractDriverIT.getConnection();
        testConnection.createStatement().execute(String.format("CREATE OR REPLACE STAGE %s", TARGET_STAGE));
        TARGET_SCHEMA = testConnection.getSchema();
        TARGET_DB = testConnection.getCatalog();
    }

    @AfterClass
    public static void tearDownClass() throws Throwable {
        Connection testConnection = AbstractDriverIT.getConnection();
        testConnection.createStatement().execute(String.format("DROP STAGE IF EXISTS %s", TARGET_STAGE));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testIssueSimpleDateFormat() throws Throwable {
        String targetTable = "TABLE_ISSUE_SIMPLEDATEFORMAT";
        Connection testConnection = AbstractDriverIT.getConnection();
        testConnection.createStatement().execute(String.format("CREATE OR REPLACE TABLE %s.%s.%s (ID int, C1 timestamp)", TARGET_DB, TARGET_SCHEMA, "TABLE_ISSUE_SIMPLEDATEFORMAT"));
        try {
            Thread t1 = new Thread(new FlatfileRead(100000, TARGET_DB, TARGET_SCHEMA, TARGET_STAGE, "TABLE_ISSUE_SIMPLEDATEFORMAT"));
            Thread t2 = new Thread(new FlatfileRead(100000, TARGET_DB, TARGET_SCHEMA, TARGET_STAGE, "TABLE_ISSUE_SIMPLEDATEFORMAT"));
            t1.start();
            t2.start();
            t1.join();
            t2.join();
            ResultSet rs = testConnection.createStatement().executeQuery(String.format("select count(*) from %s.%s.%s", TARGET_DB, TARGET_SCHEMA, "TABLE_ISSUE_SIMPLEDATEFORMAT"));
            rs.next();
            MatcherAssert.assertThat((String)"total number of records", (Object)rs.getInt(1), (Matcher)CoreMatchers.equalTo((Object)200000));
        }
        catch (Throwable throwable) {
            testConnection.createStatement().execute(String.format("DROP TABLE IF EXISTS %s.%s.%s", TARGET_DB, TARGET_SCHEMA, "TABLE_ISSUE_SIMPLEDATEFORMAT"));
            throw throwable;
        }
        testConnection.createStatement().execute(String.format("DROP TABLE IF EXISTS %s.%s.%s", TARGET_DB, TARGET_SCHEMA, "TABLE_ISSUE_SIMPLEDATEFORMAT"));
    }
}

