/*
 * Decompiled with CFR 0.152.
 */
package net.snowflake.client.loader;

import java.sql.Date;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Time;
import java.util.Arrays;
import java.util.Calendar;
import java.util.Collections;
import java.util.Random;
import java.util.TimeZone;
import net.snowflake.client.category.TestCategoryLoader;
import net.snowflake.client.loader.Loader;
import net.snowflake.client.loader.LoaderBase;
import net.snowflake.client.loader.LoaderProperty;
import net.snowflake.client.loader.Operation;
import net.snowflake.client.loader.StreamLoader;
import net.snowflake.client.loader.TestDataConfigBuilder;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.junit.Assert;
import org.junit.Ignore;
import org.junit.Test;
import org.junit.experimental.categories.Category;

@Category(value={TestCategoryLoader.class})
public class LoaderIT
extends LoaderBase {
    @Test
    public void testInjectBadStagedFileInsert() throws Exception {
        TestDataConfigBuilder tdcb = new TestDataConfigBuilder(testConnection, putConnection);
        TestDataConfigBuilder.ResultListener listener = tdcb.getListener();
        StreamLoader loader = tdcb.setOnError("ABORT_STATEMENT").getStreamLoader();
        listener.throwOnError = true;
        int numberOfRows = 1000;
        loader.setProperty(LoaderProperty.testRemoteBadCSV, (Object)true);
        loader.setProperty(LoaderProperty.startTransaction, (Object)true);
        loader.start();
        Random rnd = new Random();
        for (int i = 0; i < numberOfRows; ++i) {
            String json = "{\"key\":" + rnd.nextInt() + ",\"bar\":" + i + "}";
            Object[] row = new Object[]{i, "foo_" + i, rnd.nextInt() / 3, new java.util.Date(), json};
            loader.submitRow(row);
        }
        try {
            loader.finish();
            Assert.fail((String)"Should raise and error");
        }
        catch (Loader.DataError ex) {
            MatcherAssert.assertThat((String)"Loader.DataError is raised", (boolean)true);
        }
    }

    @Test
    public void testExecuteBeforeAfterSQLError() throws Exception {
        TestDataConfigBuilder tdcbBefore = new TestDataConfigBuilder(testConnection, putConnection);
        StreamLoader loaderBefore = tdcbBefore.setOnError("ABORT_STATEMENT").getStreamLoader();
        loaderBefore.setProperty(LoaderProperty.executeBefore, (Object)"SELECT * FROOOOOM TBL");
        loaderBefore.start();
        try {
            loaderBefore.finish();
            Assert.fail((String)"SQL Error should be raised.");
        }
        catch (Loader.ConnectionError e) {
            MatcherAssert.assertThat((Object)e.getCause(), (Matcher)CoreMatchers.instanceOf(SQLException.class));
        }
        TestDataConfigBuilder tdcbAfter = new TestDataConfigBuilder(testConnection, putConnection);
        StreamLoader loaderAfter = tdcbAfter.setOnError("ABORT_STATEMENT").getStreamLoader();
        loaderAfter.setProperty(LoaderProperty.executeBefore, (Object)"select current_version()");
        loaderAfter.setProperty(LoaderProperty.executeAfter, (Object)"SELECT * FROM TBBBBBBL");
        loaderAfter.start();
        try {
            loaderAfter.finish();
            Assert.fail((String)"SQL Error should be raised.");
        }
        catch (Loader.ConnectionError e) {
            MatcherAssert.assertThat((Object)e.getCause(), (Matcher)CoreMatchers.instanceOf(SQLException.class));
        }
    }

    @Ignore(value="Performance test")
    @Test
    public void testLoaderLargeInsert() throws Exception {
        new TestDataConfigBuilder(testConnection, putConnection).setDatabaseName("INFORMATICA_DB").setCompressDataBeforePut(false).setCompressFileByPut(true).setNumberOfRows(10000000).setCsvFileSize(100000000L).setCsvFileBucketSize(64L).populate();
    }

    @Test
    public void testLoaderInsert() throws Exception {
        new TestDataConfigBuilder(testConnection, putConnection).setTestMode(true).populate();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testLoadTime() throws Exception {
        String tableName = "LOADER_TIME_TEST";
        try {
            testConnection.createStatement().execute(String.format("CREATE OR REPLACE TABLE %s (ID int, C1 time, C2 date)", tableName));
            TestDataConfigBuilder tdcb = new TestDataConfigBuilder(testConnection, putConnection);
            tdcb.setTableName(tableName).setStartTransaction(true).setTruncateTable(true).setColumns(Arrays.asList("ID", "C1", "C2")).setKeys(Collections.singletonList("ID"));
            StreamLoader loader = tdcb.getStreamLoader();
            TestDataConfigBuilder.ResultListener listener = tdcb.getListener();
            loader.start();
            Time tm = new Time(3723000L);
            java.util.Date dt = new java.util.Date();
            for (int i = 0; i < 10; ++i) {
                Object[] row = new Object[]{i, tm, dt};
                loader.submitRow(row);
            }
            loader.finish();
            String errorMessage = "";
            if (listener.getErrorCount() > 0) {
                errorMessage = listener.getErrors().get(0).getException().toString();
            }
            MatcherAssert.assertThat((String)String.format("Error: %s", errorMessage), (Object)listener.getErrorCount(), (Matcher)CoreMatchers.equalTo((Object)0));
            ResultSet rs = testConnection.createStatement().executeQuery(String.format("SELECT c1, c2 FROM %s LIMIT 1", tableName));
            rs.next();
            Time rsTm = rs.getTime(1);
            Date rsDt = rs.getDate(2);
            MatcherAssert.assertThat((String)"Time column didn't match", (Object)rsTm, (Matcher)CoreMatchers.equalTo((Object)tm));
            Calendar cal = this.cutOffTimeFromDate(dt);
            long dtEpoch = cal.getTimeInMillis();
            long rsDtEpoch = rsDt.getTime();
            MatcherAssert.assertThat((String)"Date column didn't match", (Object)rsDtEpoch, (Matcher)CoreMatchers.equalTo((Object)dtEpoch));
        }
        catch (Throwable throwable) {
            testConnection.createStatement().execute(String.format("DROP TABLE IF EXISTS %s", tableName));
            throw throwable;
        }
        testConnection.createStatement().execute(String.format("DROP TABLE IF EXISTS %s", tableName));
    }

    private Calendar cutOffTimeFromDate(java.util.Date dt) {
        Calendar cal = Calendar.getInstance();
        cal.setTimeZone(TimeZone.getTimeZone("UTC"));
        cal.setTime(dt);
        cal.set(11, 0);
        cal.set(12, 0);
        cal.set(13, 0);
        cal.set(14, 0);
        return cal;
    }

    @Test
    public void testLoaderDelete() throws Exception {
        TestDataConfigBuilder tdcb = new TestDataConfigBuilder(testConnection, putConnection);
        tdcb.populate();
        TestDataConfigBuilder tdcbDelete = new TestDataConfigBuilder(testConnection, putConnection);
        tdcbDelete.setOperation(Operation.DELETE).setTruncateTable(false).setColumns(Arrays.asList("ID", "C1")).setKeys(Arrays.asList("ID", "C1"));
        StreamLoader loader = tdcbDelete.getStreamLoader();
        TestDataConfigBuilder.ResultListener listener = tdcbDelete.getListener();
        loader.start();
        Object[] del = new Object[]{42, "foo_42"};
        loader.submitRow(del);
        del = new Object[]{41, "blah"};
        loader.submitRow(del);
        loader.finish();
        MatcherAssert.assertThat((String)"error count", (Object)listener.getErrorCount(), (Matcher)CoreMatchers.equalTo((Object)0));
        MatcherAssert.assertThat((String)"error record count", (Object)listener.getErrorRecordCount(), (Matcher)CoreMatchers.equalTo((Object)0));
        MatcherAssert.assertThat((String)"submitted row count", (Object)listener.getSubmittedRowCount(), (Matcher)CoreMatchers.equalTo((Object)2));
        MatcherAssert.assertThat((String)"processed", (Object)listener.processed.get(), (Matcher)CoreMatchers.equalTo((Object)1));
        MatcherAssert.assertThat((String)"deleted rows", (Object)listener.deleted.get(), (Matcher)CoreMatchers.equalTo((Object)1));
    }

    @Test
    public void testLoaderModify() throws Exception {
        TestDataConfigBuilder tdcb = new TestDataConfigBuilder(testConnection, putConnection);
        tdcb.populate();
        TestDataConfigBuilder tdcbModify = new TestDataConfigBuilder(testConnection, putConnection);
        tdcbModify.setOperation(Operation.MODIFY).setTruncateTable(false).setColumns(Arrays.asList("ID", "C1", "C2", "C3", "C4", "C5")).setKeys(Collections.singletonList("ID"));
        StreamLoader loader = tdcbModify.getStreamLoader();
        TestDataConfigBuilder.ResultListener listener = tdcbModify.getListener();
        loader.start();
        Object[] mod = new Object[]{41, "modified", "some\nthi\"ng\\", 41.6, new java.util.Date(), "{}"};
        loader.submitRow(mod);
        mod = new Object[]{40, "modified", "\"something,", 40.2, new java.util.Date(), "{}"};
        loader.submitRow(mod);
        loader.finish();
        MatcherAssert.assertThat((String)"processed", (Object)listener.processed.get(), (Matcher)CoreMatchers.equalTo((Object)2));
        MatcherAssert.assertThat((String)"submitted row", (Object)listener.getSubmittedRowCount(), (Matcher)CoreMatchers.equalTo((Object)2));
        MatcherAssert.assertThat((String)"updated", (Object)listener.updated.get(), (Matcher)CoreMatchers.equalTo((Object)2));
        MatcherAssert.assertThat((String)"error count", (Object)listener.getErrorCount(), (Matcher)CoreMatchers.equalTo((Object)0));
        MatcherAssert.assertThat((String)"error record count", (Object)listener.getErrorRecordCount(), (Matcher)CoreMatchers.equalTo((Object)0));
        ResultSet rs = testConnection.createStatement().executeQuery(String.format("SELECT COUNT(*) AS N FROM \"%s\"", "LOADER_test_TABLE"));
        rs.next();
        MatcherAssert.assertThat((String)"count is not correct", (Object)rs.getInt("N"), (Matcher)CoreMatchers.equalTo((Object)10000));
        rs = testConnection.createStatement().executeQuery(String.format("SELECT C1 AS N FROM \"%s\" WHERE ID=40", "LOADER_test_TABLE"));
        rs.next();
        MatcherAssert.assertThat((String)"status is not correct", (Object)rs.getString("N"), (Matcher)CoreMatchers.equalTo((Object)"modified"));
        rs = testConnection.createStatement().executeQuery(String.format("SELECT C1, C2 FROM \"%s\" WHERE ID=41", "LOADER_test_TABLE"));
        rs.next();
        MatcherAssert.assertThat((String)"C1 is not correct", (Object)rs.getString("C1"), (Matcher)CoreMatchers.equalTo((Object)"modified"));
        MatcherAssert.assertThat((String)"C2 is not correct", (Object)rs.getString("C2"), (Matcher)CoreMatchers.equalTo((Object)"some\nthi\"ng\\"));
    }

    @Test
    public void testLoaderModifyWithOneMatchOneNot() throws Exception {
        TestDataConfigBuilder tdcb = new TestDataConfigBuilder(testConnection, putConnection);
        tdcb.populate();
        TestDataConfigBuilder tdcbModify = new TestDataConfigBuilder(testConnection, putConnection);
        tdcbModify.setTruncateTable(false).setOperation(Operation.MODIFY).setColumns(Arrays.asList("ID", "C1", "C2", "C3", "C4", "C5")).setKeys(Collections.singletonList("ID"));
        StreamLoader loader = tdcbModify.getStreamLoader();
        TestDataConfigBuilder.ResultListener listener = tdcbModify.getListener();
        loader.start();
        Object[] mod = new Object[]{20000, "modified", "some\nthi\"ng\\", 41.6, new java.util.Date(), "{}"};
        loader.submitRow(mod);
        mod = new Object[]{45, "modified", "\"something2,", 40.2, new java.util.Date(), "{}"};
        loader.submitRow(mod);
        loader.finish();
        MatcherAssert.assertThat((String)"processed", (Object)listener.processed.get(), (Matcher)CoreMatchers.equalTo((Object)1));
        MatcherAssert.assertThat((String)"submitted row", (Object)listener.getSubmittedRowCount(), (Matcher)CoreMatchers.equalTo((Object)2));
        MatcherAssert.assertThat((String)"updated", (Object)listener.updated.get(), (Matcher)CoreMatchers.equalTo((Object)1));
        MatcherAssert.assertThat((String)"error count", (Object)listener.getErrorCount(), (Matcher)CoreMatchers.equalTo((Object)0));
        MatcherAssert.assertThat((String)"error record count", (Object)listener.getErrorRecordCount(), (Matcher)CoreMatchers.equalTo((Object)0));
        ResultSet rs = testConnection.createStatement().executeQuery(String.format("SELECT COUNT(*) AS N FROM \"%s\"", "LOADER_test_TABLE"));
        rs.next();
        MatcherAssert.assertThat((String)"count is not correct", (Object)rs.getInt("N"), (Matcher)CoreMatchers.equalTo((Object)10000));
        rs = testConnection.createStatement().executeQuery(String.format("SELECT C1, C2 FROM \"%s\" WHERE ID=45", "LOADER_test_TABLE"));
        rs.next();
        MatcherAssert.assertThat((String)"C1 is not correct", (Object)rs.getString("C1"), (Matcher)CoreMatchers.equalTo((Object)"modified"));
        MatcherAssert.assertThat((String)"C2 is not correct", (Object)rs.getString("C2"), (Matcher)CoreMatchers.equalTo((Object)"\"something2,"));
    }

    @Test
    public void testLoaderUpsertWithError() throws Exception {
        TestDataConfigBuilder tdcb = new TestDataConfigBuilder(testConnection, putConnection);
        tdcb.populate();
        TestDataConfigBuilder tdcbUpsert = new TestDataConfigBuilder(testConnection, putConnection);
        tdcbUpsert.setOperation(Operation.UPSERT).setTruncateTable(false).setColumns(Arrays.asList("ID", "C1", "C2", "C3", "C4", "C5")).setKeys(Collections.singletonList("ID"));
        StreamLoader loader = tdcbUpsert.getStreamLoader();
        TestDataConfigBuilder.ResultListener listener = tdcbUpsert.getListener();
        loader.start();
        Object[] upse = new Object[]{"10001-", "inserted", "something", "42-", new java.util.Date(), "{}"};
        loader.submitRow(upse);
        upse = new Object[]{10002, "inserted", "something", 43, new java.util.Date(), "{}"};
        loader.submitRow(upse);
        upse = new Object[]{45, "modified", "something", 46.1, new java.util.Date(), "{}"};
        loader.submitRow(upse);
        loader.finish();
        MatcherAssert.assertThat((String)"processed", (Object)listener.processed.get(), (Matcher)CoreMatchers.equalTo((Object)3));
        MatcherAssert.assertThat((String)"counter", (Object)listener.counter.get(), (Matcher)CoreMatchers.equalTo((Object)2));
        MatcherAssert.assertThat((String)"submitted row", (Object)listener.getSubmittedRowCount(), (Matcher)CoreMatchers.equalTo((Object)3));
        MatcherAssert.assertThat((String)"updated/inserted", (Object)listener.updated.get(), (Matcher)CoreMatchers.equalTo((Object)2));
        MatcherAssert.assertThat((String)"error count", (Object)listener.getErrorCount(), (Matcher)CoreMatchers.equalTo((Object)2));
        MatcherAssert.assertThat((String)"error record count", (Object)listener.getErrorRecordCount(), (Matcher)CoreMatchers.equalTo((Object)1));
        MatcherAssert.assertThat((String)"Target table name is not correct", (Object)listener.getErrors().get(0).getTarget(), (Matcher)CoreMatchers.equalTo((Object)"LOADER_test_TABLE"));
        ResultSet rs = testConnection.createStatement().executeQuery(String.format("SELECT COUNT(*) AS N FROM \"%s\"", "LOADER_test_TABLE"));
        rs.next();
        int c = rs.getInt("N");
        MatcherAssert.assertThat((String)"N is not correct", (Object)c, (Matcher)CoreMatchers.equalTo((Object)10001));
        rs = testConnection.createStatement().executeQuery(String.format("SELECT C1 AS N FROM \"%s\" WHERE ID=45", "LOADER_test_TABLE"));
        rs.next();
        MatcherAssert.assertThat((String)"N is not correct", (Object)rs.getString("N"), (Matcher)CoreMatchers.equalTo((Object)"modified"));
    }

    @Test
    public void testEmptyFieldAsEmpty() throws Exception {
        this._testEmptyFieldAsEmpty(true);
        this._testEmptyFieldAsEmpty(false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void _testEmptyFieldAsEmpty(boolean copyEmptyFieldAsEmpty) throws Exception {
        String tableName = "LOADER_EMPTY_FIELD_AS_NULL";
        try {
            testConnection.createStatement().execute(String.format("CREATE OR REPLACE TABLE %s (ID int, C1 string, C2 string)", tableName));
            TestDataConfigBuilder tdcb = new TestDataConfigBuilder(testConnection, putConnection);
            tdcb.setOperation(Operation.INSERT).setStartTransaction(true).setTruncateTable(true).setTableName(tableName).setCopyEmptyFieldAsEmpty(copyEmptyFieldAsEmpty).setColumns(Arrays.asList("ID", "C1", "C2"));
            StreamLoader loader = tdcb.getStreamLoader();
            TestDataConfigBuilder.ResultListener listener = tdcb.getListener();
            loader.start();
            loader.submitRow(new Object[]{1, null, ""});
            loader.finish();
            int submitted = listener.getSubmittedRowCount();
            MatcherAssert.assertThat((String)"submitted rows", (Object)submitted, (Matcher)CoreMatchers.equalTo((Object)1));
            ResultSet rs = testConnection.createStatement().executeQuery(String.format("SELECT C1, C2 FROM %s", tableName));
            rs.next();
            String c1 = rs.getString(1);
            String c2 = rs.getString(2);
            if (!copyEmptyFieldAsEmpty) {
                MatcherAssert.assertThat((Object)c1, (Matcher)CoreMatchers.is((Matcher)CoreMatchers.nullValue()));
                MatcherAssert.assertThat((Object)c2, (Matcher)CoreMatchers.equalTo((Object)""));
            } else {
                MatcherAssert.assertThat((Object)c1, (Matcher)CoreMatchers.equalTo((Object)""));
                MatcherAssert.assertThat((Object)c2, (Matcher)CoreMatchers.equalTo((Object)""));
            }
            rs.close();
        }
        catch (Throwable throwable) {
            testConnection.createStatement().execute(String.format("DROP TABLE IF EXISTS %s", tableName));
            throw throwable;
        }
        testConnection.createStatement().execute(String.format("DROP TABLE IF EXISTS %s", tableName));
    }

    @Test
    public void testSpacesInColumnTable() throws Exception {
        String targetTableName = "Load Test Spaces In Columns";
        testConnection.createStatement().execute(String.format("CREATE OR REPLACE TABLE \"%s\" (ID int, \"Column 1\" varchar(255))", targetTableName));
        TestDataConfigBuilder tdcb = new TestDataConfigBuilder(testConnection, putConnection);
        tdcb.setTableName(targetTableName).setColumns(Arrays.asList("ID", "Column 1"));
        StreamLoader loader = tdcb.getStreamLoader();
        loader.start();
        for (int i = 0; i < 5; ++i) {
            Object[] row = new Object[]{i, "foo_" + i};
            loader.submitRow(row);
        }
        loader.finish();
        ResultSet rs = testConnection.createStatement().executeQuery(String.format("SELECT * FROM \"%s\" ORDER BY \"Column 1\"", targetTableName));
        rs.next();
        MatcherAssert.assertThat((String)"The first id", (Object)rs.getInt(1), (Matcher)CoreMatchers.equalTo((Object)0));
        MatcherAssert.assertThat((String)"The first str", (Object)rs.getString(2), (Matcher)CoreMatchers.equalTo((Object)"foo_0"));
    }

    @Test
    public void testLoaderInsertAbortStatement() throws Exception {
        TestDataConfigBuilder tdcb = new TestDataConfigBuilder(testConnection, putConnection);
        TestDataConfigBuilder.ResultListener listener = tdcb.getListener();
        StreamLoader loader = tdcb.setOnError("ABORT_STATEMENT").getStreamLoader();
        listener.throwOnError = true;
        loader.start();
        Random rnd = new Random();
        for (int i = 0; i < 10; ++i) {
            String json = "{\"key\":" + String.valueOf(rnd.nextInt()) + ",\"bar\":" + i + "}";
            Object v = rnd.nextInt() / 3;
            if (i == 7) {
                v = "INVALID_INTEGER";
            }
            Object[] row = new Object[]{i, "foo_" + i, v, new java.util.Date(), json};
            loader.submitRow(row);
        }
        try {
            loader.finish();
            Assert.fail((String)"should raise an exception");
        }
        catch (Loader.DataError ex) {
            MatcherAssert.assertThat((Object)ex.toString(), (Matcher)CoreMatchers.containsString((String)"INVALID_INTEGER"));
        }
    }

    @Test
    public void testLoadTimestampMilliseconds() throws Exception {
        String srcTable = "LOAD_TIMESTAMP_MS_SRC";
        String dstTable = "LOAD_TIMESTAMP_MS_DST";
        testConnection.createStatement().execute(String.format("create or replace table %s(c1 int, c2 timestamp_ntz(9))", srcTable));
        testConnection.createStatement().execute(String.format("create or replace table %s like %s", dstTable, srcTable));
        testConnection.createStatement().execute(String.format("insert into %s(c1,c2) values(1, '2018-05-12 12:34:56.123456789'),(2, '2018-05-13 03:45:27.988'),(3, '2018-05-14 07:12:34'),(4, '2018-12-15 10:43:45.000000876')", srcTable));
        TestDataConfigBuilder tdcb = new TestDataConfigBuilder(testConnection, putConnection);
        StreamLoader loader = tdcb.setOnError("ABORT_STATEMENT").setSchemaName(SCHEMA_NAME).setTableName(dstTable).setPreserveStageFile(true).setColumns(Arrays.asList("C1", "C2")).getStreamLoader();
        TestDataConfigBuilder.ResultListener listener = tdcb.getListener();
        listener.throwOnError = true;
        loader.start();
        ResultSet rs = testConnection.createStatement().executeQuery(String.format("select * from %s", srcTable));
        while (rs.next()) {
            Object c1 = rs.getObject(1);
            Object c2 = rs.getObject(2);
            Object[] row = new Object[]{c1, c2};
            loader.submitRow(row);
        }
        loader.finish();
        rs = testConnection.createStatement().executeQuery(String.format("select * from %s minus select * from %s", dstTable, srcTable));
        MatcherAssert.assertThat((String)"No result", (!rs.next() ? 1 : 0) != 0);
    }
}

