/*
 * Decompiled with CFR 0.152.
 */
package net.snowflake.client.loader;

import java.sql.ResultSet;
import java.util.List;
import net.snowflake.client.category.TestCategoryLoader;
import net.snowflake.client.loader.LoaderBase;
import net.snowflake.client.loader.TestDataConfigBuilder;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.junit.Test;
import org.junit.experimental.categories.Category;

@Category(value={TestCategoryLoader.class})
public class LoaderMultipleBatchIT
extends LoaderBase {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testLoaderMultipleBatch() throws Exception {
        String refTableName = "LOADER_TEST_TABLE_REF";
        testConnection.createStatement().execute(String.format("CREATE OR REPLACE TABLE \"%s\" (ID int, C1 varchar(255), C2 varchar(255) DEFAULT 'X', C3 double, C4 timestamp, C5 variant)", refTableName));
        try {
            TestDataConfigBuilder tdcb = new TestDataConfigBuilder(testConnection, putConnection);
            List<Object[]> dataSet = tdcb.populateReturnData();
            TestDataConfigBuilder tdcbRef = new TestDataConfigBuilder(testConnection, putConnection);
            tdcbRef.setDataSet(dataSet).setTableName(refTableName).setCsvFileBucketSize(2L).setCsvFileSize(30000L).populate();
            ResultSet rsReference = testConnection.createStatement().executeQuery(String.format("SELECT hash_agg(*) FROM \"%s\"", "LOADER_test_TABLE"));
            rsReference.next();
            long hashValueReference = rsReference.getLong(1);
            ResultSet rsTarget = testConnection.createStatement().executeQuery(String.format("SELECT hash_agg(*) FROM \"%s\"", refTableName));
            rsTarget.next();
            long hashValueTarget = rsTarget.getLong(1);
            MatcherAssert.assertThat((String)"hash values", (Object)hashValueTarget, (Matcher)CoreMatchers.equalTo((Object)hashValueReference));
        }
        catch (Throwable throwable) {
            testConnection.createStatement().execute(String.format("DROP TABLE IF EXISTS %s", refTableName));
            throw throwable;
        }
        testConnection.createStatement().execute(String.format("DROP TABLE IF EXISTS %s", refTableName));
    }
}

