/*
 * Decompiled with CFR 0.152.
 */
package net.snowflake.client.loader;

import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.atomic.AtomicInteger;
import net.snowflake.client.loader.LoadResultListener;
import net.snowflake.client.loader.LoadingError;
import net.snowflake.client.loader.Operation;

class ResultListener
implements LoadResultListener {
    private final List<LoadingError> errors = new ArrayList<LoadingError>();
    private final AtomicInteger errorCount = new AtomicInteger(0);
    private final AtomicInteger errorRecordCount = new AtomicInteger(0);
    private final AtomicInteger counter = new AtomicInteger(0);
    private final AtomicInteger processed = new AtomicInteger(0);
    private final AtomicInteger deleted = new AtomicInteger(0);
    private final AtomicInteger updated = new AtomicInteger(0);
    private final AtomicInteger submittedRowCount = new AtomicInteger(0);
    private Object[] lastRecord = null;
    public boolean throwOnError = false;

    ResultListener() {
    }

    public boolean needErrors() {
        return true;
    }

    public boolean needSuccessRecords() {
        return true;
    }

    public void addError(LoadingError error) {
        this.errors.add(error);
    }

    public boolean throwOnError() {
        return this.throwOnError;
    }

    public List<LoadingError> getErrors() {
        return this.errors;
    }

    public void recordProvided(Operation op, Object[] record) {
        this.lastRecord = record;
    }

    public void addProcessedRecordCount(Operation op, int i) {
        this.processed.addAndGet(i);
    }

    public void addOperationRecordCount(Operation op, int i) {
        this.counter.addAndGet(i);
        if (op == Operation.DELETE) {
            this.deleted.addAndGet(i);
        } else if (op == Operation.MODIFY || op == Operation.UPSERT) {
            this.updated.addAndGet(i);
        }
    }

    public Object[] getLastRecord() {
        return this.lastRecord;
    }

    public int getErrorCount() {
        return this.errorCount.get();
    }

    public int getErrorRecordCount() {
        return this.errorRecordCount.get();
    }

    public void resetErrorCount() {
        this.errorCount.set(0);
    }

    public void resetErrorRecordCount() {
        this.errorRecordCount.set(0);
    }

    public void addErrorCount(int count) {
        this.errorCount.addAndGet(count);
    }

    public void addErrorRecordCount(int count) {
        this.errorRecordCount.addAndGet(count);
    }

    public void resetSubmittedRowCount() {
        this.submittedRowCount.set(0);
    }

    public void addSubmittedRowCount(int count) {
        this.submittedRowCount.addAndGet(count);
    }

    public int getSubmittedRowCount() {
        return this.submittedRowCount.get();
    }
}

