/*
 * Decompiled with CFR 0.152.
 */
package net.snowflake.client.log;

import java.util.logging.Formatter;
import java.util.logging.Handler;
import java.util.logging.Level;
import java.util.logging.LogRecord;
import net.snowflake.client.category.TestCategoryCore;
import net.snowflake.client.log.JDK14JCLWrapper;
import net.snowflake.client.log.JDK14Logger;
import net.snowflake.client.log.SFFormatter;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.junit.experimental.categories.Category;

@Category(value={TestCategoryCore.class})
public class JDK14JCLWrapperLatestIT {
    JDK14JCLWrapper wrapper = new JDK14JCLWrapper(JDK14JCLWrapperLatestIT.class.getName());
    JDK14Logger logger = (JDK14Logger)this.wrapper.getLogger();
    private String lastLogMessage = null;
    private Level logLevelToRestore = null;
    private TestJDK14LogHandler handler = new TestJDK14LogHandler((Formatter)new SFFormatter());

    @Before
    public void setUp() {
        JDK14JCLWrapperLatestIT jDK14JCLWrapperLatestIT = this;
        this.logLevelToRestore = jDK14JCLWrapperLatestIT.logger.getLevel();
        JDK14Logger.setLevel((Level)Level.FINEST);
        JDK14Logger.addHandler((Handler)this.handler);
        JDK14Logger.setUseParentHandlers((boolean)false);
    }

    @After
    public void tearDown() {
        JDK14Logger.setUseParentHandlers((boolean)true);
        JDK14Logger.setLevel((Level)this.logLevelToRestore);
        JDK14Logger.removeHandler((Handler)this.handler);
    }

    String getLoggedMessage() {
        return this.lastLogMessage;
    }

    private void testLogMessagesWithThrowable(LogLevel level, String message, Throwable t) {
        switch (level) {
            case FATAL: {
                this.wrapper.fatal((Object)message, t);
                break;
            }
            case ERROR: {
                this.wrapper.error((Object)message, t);
                break;
            }
            case WARN: {
                this.wrapper.warn((Object)message, t);
                break;
            }
            case INFO: {
                this.wrapper.info((Object)message, t);
            }
        }
        Assert.assertEquals((Object)message, (Object)this.getLoggedMessage());
    }

    private void testLogMessagesNoThrowable(LogLevel level, String message) {
        switch (level) {
            case FATAL: {
                this.wrapper.fatal((Object)message);
                break;
            }
            case ERROR: {
                this.wrapper.error((Object)message);
                break;
            }
            case WARN: {
                this.wrapper.warn((Object)message);
                break;
            }
            case INFO: {
                this.wrapper.info((Object)message);
            }
        }
        Assert.assertEquals((Object)message, (Object)this.getLoggedMessage());
    }

    private void testNullLogMessagesWithThrowable(LogLevel level, String message, Throwable t) {
        switch (level) {
            case TRACE: {
                this.wrapper.trace((Object)message, t);
                break;
            }
            case DEBUG: {
                this.wrapper.debug((Object)message, t);
            }
        }
        Assert.assertEquals(null, (Object)this.getLoggedMessage());
    }

    private void testNullLogMessagesNoThrowable(LogLevel level, String message) {
        switch (level) {
            case TRACE: {
                this.wrapper.trace((Object)message);
                break;
            }
            case DEBUG: {
                this.wrapper.debug((Object)message);
            }
        }
        Assert.assertEquals(null, (Object)this.getLoggedMessage());
    }

    @Test
    public void testNullLogMessages() {
        LogLevel[] levelsWithNoOutput;
        LogLevel[] levelsDisplayingOutput = new LogLevel[]{LogLevel.FATAL, LogLevel.ERROR, LogLevel.WARN, LogLevel.INFO};
        for (LogLevel level : levelsWithNoOutput = new LogLevel[]{LogLevel.TRACE, LogLevel.DEBUG}) {
            this.testNullLogMessagesWithThrowable(level, "sample message", null);
            this.testNullLogMessagesNoThrowable(level, "sample message");
        }
        for (LogLevel level : levelsDisplayingOutput) {
            this.testLogMessagesWithThrowable(level, "sample message", null);
            this.testLogMessagesNoThrowable(level, "sample message");
        }
    }

    @Test
    public void testEnabledMessaging() {
        Assert.assertFalse((boolean)this.wrapper.isTraceEnabled());
        Assert.assertFalse((boolean)this.wrapper.isDebugEnabled());
        Assert.assertTrue((boolean)this.wrapper.isInfoEnabled());
        Assert.assertTrue((boolean)this.wrapper.isWarnEnabled());
        Assert.assertTrue((boolean)this.wrapper.isErrorEnabled());
        Assert.assertTrue((boolean)this.wrapper.isFatalEnabled());
    }

    private static enum LogLevel {
        FATAL,
        ERROR,
        WARN,
        INFO,
        DEBUG,
        TRACE;

    }

    private class TestJDK14LogHandler
    extends Handler {
        TestJDK14LogHandler(Formatter formatter) {
            super.setFormatter(formatter);
        }

        @Override
        public void publish(LogRecord record) {
            JDK14JCLWrapperLatestIT.this.lastLogMessage = this.getFormatter().formatMessage(record);
        }

        @Override
        public void flush() {
        }

        @Override
        public void close() throws SecurityException {
        }
    }
}

