/*
 * Decompiled with CFR 0.152.
 */
package net.snowflake.client.log;

import java.io.File;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.attribute.FileAttribute;
import java.nio.file.attribute.PosixFilePermission;
import java.sql.Connection;
import java.sql.SQLException;
import java.util.HashSet;
import java.util.Properties;
import java.util.logging.Level;
import net.snowflake.client.AbstractDriverIT;
import net.snowflake.client.log.JDK14Logger;
import org.apache.commons.io.FileUtils;
import org.junit.Assert;
import org.junit.Test;

public class JDK14LoggerWithClientLatestIT
extends AbstractDriverIT {
    @Test
    public void testJDK14LoggingWithClientConfig() {
        Path configFilePath = Paths.get("config.json", new String[0]);
        String configJson = "{\"common\":{\"log_level\":\"debug\",\"log_path\":\"logs\"}}";
        try {
            Files.write(configFilePath, configJson.getBytes(), new OpenOption[0]);
            Properties properties = new Properties();
            properties.put("client_config_file", configFilePath.toString());
            Connection connection = JDK14LoggerWithClientLatestIT.getConnection(properties);
            connection.createStatement().executeQuery("select 1");
            File file = new File("logs/jdbc/");
            Assert.assertTrue((boolean)file.exists());
            Files.deleteIfExists(configFilePath);
            FileUtils.deleteDirectory((File)new File("logs"));
        }
        catch (IOException e) {
            Assert.fail((String)"testJDK14LoggingWithClientConfig failed");
        }
        catch (SQLException e) {
            Assert.fail((String)"testJDK14LoggingWithClientConfig failed");
        }
    }

    @Test(expected=SQLException.class)
    public void testJDK14LoggingWithClientConfigInvalidConfigFilePath() throws SQLException {
        Path configFilePath = Paths.get("invalid.json", new String[0]);
        Properties properties = new Properties();
        properties.put("client_config_file", configFilePath.toString());
        Connection connection = JDK14LoggerWithClientLatestIT.getConnection(properties);
        connection.createStatement().executeQuery("select 1");
    }

    @Test
    public void testJDK14LoggingWithClientConfigPermissionError() throws IOException, SQLException {
        Path configFilePath = Paths.get("config.json", new String[0]);
        String configJson = "{\"common\":{\"log_level\":\"debug\",\"log_path\":\"logs\"}}";
        Path directoryPath = Files.createDirectory(Paths.get("logs", new String[0]), new FileAttribute[0]);
        File directory = directoryPath.toFile();
        HashSet<PosixFilePermission> perms = new HashSet<PosixFilePermission>();
        perms.add(PosixFilePermission.OWNER_READ);
        perms.add(PosixFilePermission.GROUP_READ);
        perms.add(PosixFilePermission.OTHERS_READ);
        Files.setPosixFilePermissions(directoryPath, perms);
        Files.write(configFilePath, configJson.getBytes(), new OpenOption[0]);
        Properties properties = new Properties();
        properties.put("client_config_file", configFilePath.toString());
        Assert.assertThrows(SQLException.class, () -> JDK14LoggerWithClientLatestIT.getConnection(properties));
        Files.delete(configFilePath);
        directory.delete();
    }

    @Test
    public void testJDK14LoggerWithBracesInMessage() {
        JDK14Logger logger = new JDK14Logger(JDK14LoggerWithClientLatestIT.class.getName());
        JDK14Logger.setLevel((Level)Level.FINE);
        logger.debug("Returning column: 12: a: Group b) Hi {Hello World War} cant wait", new Object[0]);
        JDK14Logger.setLevel((Level)Level.OFF);
    }

    @Test
    public void testJDK14LoggerWithQuotesInMessage() {
        JDK14Logger logger = new JDK14Logger(JDK14LoggerWithClientLatestIT.class.getName());
        JDK14Logger.setLevel((Level)Level.FINE);
        logger.debug("Returning column: 12: a: Group b) Hi {Hello 'World' War} cant wait", new Object[0]);
        JDK14Logger.setLevel((Level)Level.OFF);
    }
}

