/*
 * Decompiled with CFR 0.152.
 */
package net.snowflake.client.log;

import ch.qos.logback.classic.Level;
import ch.qos.logback.classic.Logger;
import ch.qos.logback.classic.spi.ILoggingEvent;
import ch.qos.logback.core.Appender;
import ch.qos.logback.core.AppenderBase;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import net.snowflake.client.category.TestCategoryCore;
import net.snowflake.client.log.AbstractLoggerIT;
import net.snowflake.client.log.SLF4JLogger;
import org.junit.After;
import org.junit.AfterClass;
import org.junit.Before;
import org.junit.BeforeClass;
import org.junit.experimental.categories.Category;
import org.slf4j.LoggerFactory;

@Category(value={TestCategoryCore.class})
public class SLF4JLoggerLatestIT
extends AbstractLoggerIT {
    private static final SLF4JLogger LOGGER = new SLF4JLogger(SLF4JLoggerLatestIT.class);
    private static Level logLevelToRestore;
    private static final Logger internalLogger;
    private static boolean additivityToRestore;
    private static final List<Appender<ILoggingEvent>> appendersToRestore;
    private final Appender<ILoggingEvent> testAppender = new TestAppender();
    private String lastLogMessage = null;
    private Level lastLogMessageLevel = null;

    @BeforeClass
    public static void oneTimeSetUp() {
        logLevelToRestore = internalLogger.getLevel();
        additivityToRestore = internalLogger.isAdditive();
        appendersToRestore.clear();
        Iterator itr = internalLogger.iteratorForAppenders();
        while (itr.hasNext()) {
            appendersToRestore.add((Appender<ILoggingEvent>)((Appender)itr.next()));
        }
        appendersToRestore.forEach(arg_0 -> ((Logger)internalLogger).detachAppender(arg_0));
        internalLogger.setAdditive(false);
    }

    @AfterClass
    public static void oneTimeTearDown() {
        internalLogger.setLevel(logLevelToRestore);
        internalLogger.setAdditive(additivityToRestore);
        internalLogger.detachAndStopAllAppenders();
        appendersToRestore.forEach(arg_0 -> ((Logger)internalLogger).addAppender(arg_0));
    }

    @Override
    @Before
    public void setUp() {
        super.setUp();
        if (!this.testAppender.isStarted()) {
            this.testAppender.start();
        }
        internalLogger.addAppender(this.testAppender);
    }

    @After
    public void tearDown() {
        internalLogger.detachAppender(this.testAppender);
    }

    @Override
    void logMessage(AbstractLoggerIT.LogLevel level, String message, Object ... args) {
        switch (level) {
            case ERROR: {
                LOGGER.error(message, args);
                break;
            }
            case WARNING: {
                LOGGER.warn(message, args);
                break;
            }
            case INFO: {
                LOGGER.info(message, args);
                break;
            }
            case DEBUG: {
                LOGGER.debug(message, args);
                break;
            }
            case TRACE: {
                LOGGER.trace(message, args);
            }
        }
    }

    @Override
    void logMessage(AbstractLoggerIT.LogLevel level, String message, Throwable throwable) {
        switch (level) {
            case ERROR: {
                LOGGER.error(message, throwable);
                break;
            }
            case WARNING: {
                LOGGER.warn(message, throwable);
                break;
            }
            case INFO: {
                LOGGER.info(message, throwable);
                break;
            }
            case DEBUG: {
                LOGGER.debug(message, throwable);
                break;
            }
            case TRACE: {
                LOGGER.trace(message, throwable);
            }
        }
    }

    @Override
    void logMessage(AbstractLoggerIT.LogLevel level, String message, boolean isMasked) {
        switch (level) {
            case ERROR: {
                LOGGER.error(message, isMasked);
                break;
            }
            case WARNING: {
                LOGGER.warn(message, isMasked);
                break;
            }
            case INFO: {
                LOGGER.info(message, isMasked);
                break;
            }
            case DEBUG: {
                LOGGER.debug(message, isMasked);
                break;
            }
            case TRACE: {
                LOGGER.trace(message, isMasked);
            }
        }
    }

    @Override
    void setLogLevel(AbstractLoggerIT.LogLevel level) {
        internalLogger.setLevel(this.toLogBackLevel(level));
    }

    @Override
    String getLoggedMessage() {
        return this.lastLogMessage;
    }

    @Override
    AbstractLoggerIT.LogLevel getLoggedMessageLevel() {
        return this.fromLogBackLevel(this.lastLogMessageLevel);
    }

    @Override
    void clearLastLoggedMessageAndLevel() {
        this.lastLogMessage = null;
        this.lastLogMessageLevel = null;
    }

    private Level toLogBackLevel(AbstractLoggerIT.LogLevel level) {
        switch (level) {
            case ERROR: {
                return Level.ERROR;
            }
            case WARNING: {
                return Level.WARN;
            }
            case INFO: {
                return Level.INFO;
            }
            case DEBUG: {
                return Level.DEBUG;
            }
            case TRACE: {
                return Level.TRACE;
            }
        }
        return Level.TRACE;
    }

    private AbstractLoggerIT.LogLevel fromLogBackLevel(Level level) {
        if (Level.ERROR.equals(level)) {
            return AbstractLoggerIT.LogLevel.ERROR;
        }
        if (Level.WARN.equals(level)) {
            return AbstractLoggerIT.LogLevel.WARNING;
        }
        if (Level.INFO.equals(level)) {
            return AbstractLoggerIT.LogLevel.INFO;
        }
        if (Level.DEBUG.equals(level)) {
            return AbstractLoggerIT.LogLevel.DEBUG;
        }
        if (Level.TRACE.equals(level) || Level.ALL.equals(level)) {
            return AbstractLoggerIT.LogLevel.TRACE;
        }
        throw new IllegalArgumentException(String.format("Specified log level '%s' not supported", level.toString()));
    }

    static {
        internalLogger = (Logger)LoggerFactory.getLogger(SLF4JLoggerLatestIT.class);
        additivityToRestore = true;
        appendersToRestore = new ArrayList<Appender<ILoggingEvent>>();
    }

    private class TestAppender
    extends AppenderBase<ILoggingEvent> {
        private TestAppender() {
        }

        public void append(ILoggingEvent event) {
            SLF4JLoggerLatestIT.this.lastLogMessage = event.getFormattedMessage();
            SLF4JLoggerLatestIT.this.lastLogMessageLevel = event.getLevel();
        }
    }
}

