/*
 * Decompiled with CFR 0.152.
 */
package net.snowflake.client.pooling;

import java.sql.Connection;
import java.sql.SQLException;
import java.util.Map;
import javax.sql.PooledConnection;
import net.snowflake.client.category.TestCategoryConnection;
import net.snowflake.client.jdbc.BaseJDBCTest;
import net.snowflake.client.pooling.SnowflakeConnectionPoolDataSource;
import org.junit.Test;
import org.junit.experimental.categories.Category;

@Category(value={TestCategoryConnection.class})
public class LogicalConnectionAlreadyClosedLatestIT
extends BaseJDBCTest {
    @Test
    public void testLogicalConnectionAlreadyClosed() throws SQLException {
        Map<String, String> properties = LogicalConnectionAlreadyClosedLatestIT.getConnectionParameters();
        SnowflakeConnectionPoolDataSource poolDataSource = new SnowflakeConnectionPoolDataSource();
        poolDataSource.setUrl(properties.get("uri"));
        poolDataSource.setPortNumber(Integer.parseInt(properties.get("port")));
        poolDataSource.setSsl("on".equals(properties.get("ssl")));
        poolDataSource.setAccount(properties.get("account"));
        poolDataSource.setUser(properties.get("user"));
        poolDataSource.setPassword(properties.get("password"));
        PooledConnection pooledConnection = poolDataSource.getPooledConnection();
        Connection logicalConnection = pooledConnection.getConnection();
        logicalConnection.close();
        this.expectConnectionAlreadyClosedException(logicalConnection::getMetaData);
        this.expectConnectionAlreadyClosedException(logicalConnection::getAutoCommit);
        this.expectConnectionAlreadyClosedException(logicalConnection::commit);
        this.expectConnectionAlreadyClosedException(logicalConnection::rollback);
        this.expectConnectionAlreadyClosedException(logicalConnection::isReadOnly);
        this.expectConnectionAlreadyClosedException(logicalConnection::getCatalog);
        this.expectConnectionAlreadyClosedException(logicalConnection::getSchema);
        this.expectConnectionAlreadyClosedException(logicalConnection::getTransactionIsolation);
        this.expectConnectionAlreadyClosedException(logicalConnection::getWarnings);
        this.expectConnectionAlreadyClosedException(logicalConnection::clearWarnings);
        this.expectConnectionAlreadyClosedException(() -> logicalConnection.nativeSQL("select 1"));
        this.expectConnectionAlreadyClosedException(() -> logicalConnection.setAutoCommit(false));
        this.expectConnectionAlreadyClosedException(() -> logicalConnection.setReadOnly(false));
        this.expectConnectionAlreadyClosedException(() -> logicalConnection.setCatalog("fakedb"));
        this.expectConnectionAlreadyClosedException(() -> logicalConnection.setSchema("fakedb"));
        this.expectConnectionAlreadyClosedException(() -> logicalConnection.setTransactionIsolation(2));
    }
}

