/*
 * Decompiled with CFR 0.152.
 */
package net.snowflake.client.pooling;

import java.sql.Connection;
import java.sql.SQLException;
import java.sql.Savepoint;
import java.util.HashMap;
import java.util.Map;
import javax.sql.PooledConnection;
import net.snowflake.client.category.TestCategoryConnection;
import net.snowflake.client.jdbc.BaseJDBCTest;
import net.snowflake.client.pooling.SnowflakeConnectionPoolDataSource;
import org.junit.Test;
import org.junit.experimental.categories.Category;

@Category(value={TestCategoryConnection.class})
public class LogicalConnectionFeatureNotSupportedLatestIT
extends BaseJDBCTest {
    @Test
    public void testLogicalConnectionFeatureNotSupported() throws SQLException {
        Map<String, String> properties = LogicalConnectionFeatureNotSupportedLatestIT.getConnectionParameters();
        SnowflakeConnectionPoolDataSource poolDataSource = new SnowflakeConnectionPoolDataSource();
        poolDataSource.setUrl(properties.get("uri"));
        poolDataSource.setPortNumber(Integer.parseInt(properties.get("port")));
        poolDataSource.setSsl("on".equals(properties.get("ssl")));
        poolDataSource.setAccount(properties.get("account"));
        poolDataSource.setUser(properties.get("user"));
        poolDataSource.setPassword(properties.get("password"));
        PooledConnection pooledConnection = poolDataSource.getPooledConnection();
        Connection logicalConnection = pooledConnection.getConnection();
        this.expectFeatureNotSupportedException(() -> logicalConnection.rollback(new FakeSavepoint()));
        this.expectFeatureNotSupportedException(() -> logicalConnection.setTransactionIsolation(8));
        this.expectFeatureNotSupportedException(() -> logicalConnection.setTransactionIsolation(4));
        this.expectFeatureNotSupportedException(() -> logicalConnection.prepareStatement("select 1", new int[]{1, 2}));
        this.expectFeatureNotSupportedException(() -> logicalConnection.prepareStatement("select 1", new String[]{"c1", "c2"}));
        this.expectFeatureNotSupportedException(() -> logicalConnection.prepareStatement("select 1", 1005, 1007));
        this.expectFeatureNotSupportedException(() -> logicalConnection.prepareStatement("select 1", 1005, 1007, 1));
        this.expectFeatureNotSupportedException(() -> logicalConnection.createStatement(1005, 1007));
        this.expectFeatureNotSupportedException(() -> logicalConnection.setTypeMap(new HashMap()));
        this.expectFeatureNotSupportedException(logicalConnection::setSavepoint);
        this.expectFeatureNotSupportedException(() -> logicalConnection.setSavepoint("fake"));
        this.expectFeatureNotSupportedException(() -> logicalConnection.releaseSavepoint(new FakeSavepoint()));
        this.expectFeatureNotSupportedException(logicalConnection::createBlob);
        this.expectFeatureNotSupportedException(logicalConnection::createNClob);
        this.expectFeatureNotSupportedException(logicalConnection::createSQLXML);
        this.expectFeatureNotSupportedException(() -> logicalConnection.setHoldability(2));
        this.expectFeatureNotSupportedException(() -> logicalConnection.setHoldability(1));
        this.expectFeatureNotSupportedException(() -> logicalConnection.createArrayOf("fakeType", new Object[0]));
        this.expectFeatureNotSupportedException(() -> logicalConnection.createStruct("fakeType", new Object[0]));
        this.expectFeatureNotSupportedException(() -> logicalConnection.prepareStatement("select 1", 1));
    }

    class FakeSavepoint
    implements Savepoint {
        FakeSavepoint() {
        }

        @Override
        public int getSavepointId() throws SQLException {
            return 0;
        }

        @Override
        public String getSavepointName() throws SQLException {
            return "";
        }
    }
}

