/*
 * Decompiled with CFR 0.152.
 */
package net.snowflake.client.pooling;

import java.sql.CallableStatement;
import java.sql.Clob;
import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.Collections;
import java.util.Map;
import java.util.Properties;
import javax.sql.PooledConnection;
import net.snowflake.client.category.TestCategoryConnection;
import net.snowflake.client.jdbc.BaseJDBCTest;
import net.snowflake.client.jdbc.SnowflakeConnectionV1;
import net.snowflake.client.jdbc.SnowflakeDriver;
import net.snowflake.client.pooling.SnowflakeConnectionPoolDataSource;
import net.snowflake.client.pooling.SnowflakePooledConnection;
import org.junit.Assert;
import org.junit.Test;
import org.junit.experimental.categories.Category;

@Category(value={TestCategoryConnection.class})
public class LogicalConnectionLatestIT
extends BaseJDBCTest {
    Map<String, String> properties = LogicalConnectionLatestIT.getConnectionParameters();

    @Test
    public void testLogicalConnection() throws SQLException {
        SnowflakeConnectionPoolDataSource poolDataSource = new SnowflakeConnectionPoolDataSource();
        poolDataSource = this.setProperties(poolDataSource);
        PooledConnection pooledConnection = poolDataSource.getPooledConnection();
        Connection logicalConnection = pooledConnection.getConnection();
        Statement statement = logicalConnection.createStatement(1003, 1007, 2);
        ResultSet resultSet = statement.executeQuery("show parameters");
        Assert.assertTrue((boolean)resultSet.next());
        Assert.assertFalse((boolean)logicalConnection.isClosed());
        Assert.assertEquals((long)2L, (long)logicalConnection.getHoldability());
        statement.close();
        logicalConnection.close();
        Assert.assertTrue((boolean)logicalConnection.isClosed());
        pooledConnection.close();
    }

    @Test
    public void testNetworkTimeout() throws SQLException {
        SnowflakeConnectionPoolDataSource poolDataSource = new SnowflakeConnectionPoolDataSource();
        poolDataSource = this.setProperties(poolDataSource);
        PooledConnection pooledConnection = poolDataSource.getPooledConnection();
        try (Connection logicalConnection = pooledConnection.getConnection();){
            int millis = logicalConnection.getNetworkTimeout();
            Assert.assertEquals((long)0L, (long)millis);
            logicalConnection.setNetworkTimeout(null, 200);
            Assert.assertEquals((long)200L, (long)logicalConnection.getNetworkTimeout());
        }
        pooledConnection.close();
    }

    @Test
    public void testIsValid() throws Throwable {
        SnowflakeConnectionPoolDataSource poolDataSource = new SnowflakeConnectionPoolDataSource();
        poolDataSource = this.setProperties(poolDataSource);
        PooledConnection pooledConnection = poolDataSource.getPooledConnection();
        try (Connection logicalConnection = pooledConnection.getConnection();){
            Assert.assertTrue((boolean)logicalConnection.isValid(10));
            try {
                Assert.assertTrue((boolean)logicalConnection.isValid(-10));
                Assert.fail((String)"must fail");
            }
            catch (SQLException sQLException) {
                // empty catch block
            }
        }
        pooledConnection.close();
    }

    @Test
    public void testConnectionClientInfo() throws SQLException {
        SnowflakeConnectionPoolDataSource poolDataSource = new SnowflakeConnectionPoolDataSource();
        poolDataSource = this.setProperties(poolDataSource);
        PooledConnection pooledConnection = poolDataSource.getPooledConnection();
        try (Connection logicalConnection = pooledConnection.getConnection();){
            Properties property = logicalConnection.getClientInfo();
            Assert.assertEquals((long)0L, (long)property.size());
            Properties clientInfo = new Properties();
            clientInfo.setProperty("name", "Peter");
            clientInfo.setProperty("description", "SNOWFLAKE JDBC");
            this.expectSQLClientInfoException(() -> logicalConnection.setClientInfo(clientInfo));
            this.expectSQLClientInfoException(() -> logicalConnection.setClientInfo("ApplicationName", "valueA"));
            Assert.assertNull((Object)logicalConnection.getClientInfo("Peter"));
        }
        pooledConnection.close();
    }

    @Test
    public void testAbort() throws SQLException {
        SnowflakeConnectionPoolDataSource poolDataSource = new SnowflakeConnectionPoolDataSource();
        poolDataSource = this.setProperties(poolDataSource);
        PooledConnection pooledConnection = poolDataSource.getPooledConnection();
        Connection logicalConnection = pooledConnection.getConnection();
        Connection physicalConnection = ((SnowflakePooledConnection)pooledConnection).getPhysicalConnection();
        Assert.assertTrue((!physicalConnection.isClosed() ? 1 : 0) != 0);
        logicalConnection.abort(null);
        Assert.assertTrue((boolean)physicalConnection.isClosed());
    }

    @Test
    public void testNativeSQL() throws Throwable {
        SnowflakeConnectionPoolDataSource poolDataSource = new SnowflakeConnectionPoolDataSource();
        poolDataSource = this.setProperties(poolDataSource);
        PooledConnection pooledConnection = poolDataSource.getPooledConnection();
        try (Connection logicalConnection = pooledConnection.getConnection();){
            Assert.assertEquals((Object)"select 1", (Object)logicalConnection.nativeSQL("select 1"));
        }
        pooledConnection.close();
    }

    @Test
    public void testUnwrapper() throws Throwable {
        SnowflakeConnectionPoolDataSource poolDataSource = new SnowflakeConnectionPoolDataSource();
        poolDataSource = this.setProperties(poolDataSource);
        PooledConnection pooledConnection = poolDataSource.getPooledConnection();
        try (Connection logicalConnection = pooledConnection.getConnection();){
            boolean canUnwrap = logicalConnection.isWrapperFor(SnowflakeConnectionV1.class);
            Assert.assertTrue((boolean)canUnwrap);
            if (canUnwrap) {
                SnowflakeConnectionV1 sfconnection = logicalConnection.unwrap(SnowflakeConnectionV1.class);
                sfconnection.createStatement();
            } else {
                Assert.fail((String)"should be able to unwrap");
            }
            try {
                logicalConnection.unwrap(SnowflakeDriver.class);
                Assert.fail((String)"should fail to cast");
            }
            catch (SQLException sQLException) {
                // empty catch block
            }
        }
    }

    @Test
    public void testTransactionStatement() throws SQLException {
        SnowflakeConnectionPoolDataSource poolDataSource = new SnowflakeConnectionPoolDataSource();
        poolDataSource = this.setProperties(poolDataSource);
        PooledConnection pooledConnection = poolDataSource.getPooledConnection();
        try (Connection logicalConnection = pooledConnection.getConnection();){
            logicalConnection.setAutoCommit(false);
            assert (!logicalConnection.getAutoCommit());
            logicalConnection.setTransactionIsolation(2);
            Assert.assertEquals((long)2L, (long)logicalConnection.getTransactionIsolation());
            Statement statement = logicalConnection.createStatement();
            statement.executeUpdate("create or replace table test_transaction (colA int, colB string)");
            statement.executeUpdate("insert into test_transaction values (1, 'abc')");
            logicalConnection.commit();
            ResultSet resultSet = statement.executeQuery("select count(*) from test_transaction");
            Assert.assertTrue((boolean)resultSet.next());
            Assert.assertEquals((long)1L, (long)resultSet.getInt(1));
            resultSet.close();
            statement.executeUpdate("delete from test_transaction");
            logicalConnection.rollback();
            resultSet = statement.executeQuery("select count(*) from test_transaction");
            Assert.assertTrue((boolean)resultSet.next());
            Assert.assertEquals((long)1L, (long)resultSet.getInt(1));
            statement.execute("drop table if exists test_transaction");
            resultSet.close();
        }
        pooledConnection.close();
    }

    @Test
    public void testReadOnly() throws SQLException {
        SnowflakeConnectionPoolDataSource poolDataSource = new SnowflakeConnectionPoolDataSource();
        poolDataSource = this.setProperties(poolDataSource);
        PooledConnection pooledConnection = poolDataSource.getPooledConnection();
        try (Connection logicalConnection = pooledConnection.getConnection();){
            Assert.assertEquals((Object)false, (Object)logicalConnection.isReadOnly());
            logicalConnection.setReadOnly(true);
            Assert.assertEquals((Object)false, (Object)logicalConnection.isReadOnly());
        }
        pooledConnection.close();
    }

    @Test
    public void testGetTypeMap() throws Throwable {
        SnowflakeConnectionPoolDataSource poolDataSource = new SnowflakeConnectionPoolDataSource();
        poolDataSource = this.setProperties(poolDataSource);
        PooledConnection pooledConnection = poolDataSource.getPooledConnection();
        try (Connection logicalConnection = pooledConnection.getConnection();){
            Assert.assertEquals(Collections.emptyMap(), logicalConnection.getTypeMap());
        }
        pooledConnection.close();
    }

    @Test
    public void testPreparedStatement() throws SQLException {
        SnowflakeConnectionPoolDataSource poolDataSource = new SnowflakeConnectionPoolDataSource();
        poolDataSource = this.setProperties(poolDataSource);
        PooledConnection pooledConnection = poolDataSource.getPooledConnection();
        try (Connection logicalConnection = pooledConnection.getConnection();
             Statement statement = logicalConnection.createStatement();){
            statement.execute("use database " + logicalConnection.getCatalog());
            statement.execute("use schema " + logicalConnection.getSchema());
            statement.execute("create or replace table test_prep (colA int, colB varchar)");
            try (PreparedStatement preparedStatement = logicalConnection.prepareStatement("insert into test_prep values (?, ?)");){
                preparedStatement.setInt(1, 25);
                preparedStatement.setString(2, "hello world");
                preparedStatement.execute();
                ResultSet resultSet = statement.executeQuery("select * from test_prep");
                int count = 0;
                while (resultSet.next()) {
                    ++count;
                }
                Assert.assertEquals((long)1L, (long)count);
                statement.execute("drop table if exists test_prep");
            }
        }
        pooledConnection.close();
    }

    @Test
    public void testSetSchema() throws SQLException {
        SnowflakeConnectionPoolDataSource poolDataSource = new SnowflakeConnectionPoolDataSource();
        poolDataSource = this.setProperties(poolDataSource);
        PooledConnection pooledConnection = poolDataSource.getPooledConnection();
        try (Connection logicalConnection = pooledConnection.getConnection();){
            String schema = logicalConnection.getSchema();
            ResultSet rst = logicalConnection.createStatement().executeQuery("select current_schema()");
            Assert.assertTrue((boolean)rst.next());
            Assert.assertEquals((Object)schema, (Object)rst.getString(1));
            logicalConnection.setSchema("PUBLIC");
            rst = logicalConnection.createStatement().executeQuery("select current_schema()");
            Assert.assertTrue((boolean)rst.next());
            Assert.assertEquals((Object)"PUBLIC", (Object)rst.getString(1));
        }
        pooledConnection.close();
    }

    @Test
    public void testPrepareCall() throws SQLException {
        String procedure = "CREATE OR REPLACE PROCEDURE output_message(message VARCHAR)\nRETURNS VARCHAR NOT NULL\nLANGUAGE SQL\nAS\nBEGIN\n  RETURN message;\nEND;";
        SnowflakeConnectionPoolDataSource poolDataSource = new SnowflakeConnectionPoolDataSource();
        poolDataSource = this.setProperties(poolDataSource);
        PooledConnection pooledConnection = poolDataSource.getPooledConnection();
        try (Connection logicalConnection = pooledConnection.getConnection();){
            Statement statement = logicalConnection.createStatement();
            statement.execute(procedure);
            CallableStatement callableStatement = logicalConnection.prepareCall("call output_message(?)");
            callableStatement.setString(1, "hello world");
            ResultSet resultSet = callableStatement.executeQuery();
            resultSet.next();
            Assert.assertEquals((Object)"hello world", (Object)resultSet.getString(1));
            callableStatement = logicalConnection.prepareCall("call output_message('hello world')", 1003, 1007);
            resultSet = callableStatement.executeQuery();
            resultSet.next();
            Assert.assertEquals((Object)"hello world", (Object)resultSet.getString(1));
            Assert.assertEquals((long)1003L, (long)callableStatement.getResultSetType());
            Assert.assertEquals((long)1007L, (long)callableStatement.getResultSetConcurrency());
            callableStatement = logicalConnection.prepareCall("call output_message('hello world')", 1003, 1007, 2);
            resultSet = callableStatement.executeQuery();
            resultSet.next();
            Assert.assertEquals((long)2L, (long)callableStatement.getResultSetHoldability());
            statement.execute("drop procedure if exists output_message(varchar)");
            statement.close();
            resultSet.close();
            callableStatement.close();
        }
    }

    @Test
    public void testClob() throws SQLException {
        SnowflakeConnectionPoolDataSource poolDataSource = new SnowflakeConnectionPoolDataSource();
        poolDataSource = this.setProperties(poolDataSource);
        PooledConnection pooledConnection = poolDataSource.getPooledConnection();
        try (Connection logicalConnection = pooledConnection.getConnection();){
            Statement statement = logicalConnection.createStatement();
            statement.execute("create or replace table test_clob (colA text)");
            Clob clob = logicalConnection.createClob();
            clob.setString(1L, "hello world");
            PreparedStatement preparedStatement = logicalConnection.prepareStatement("insert into test_clob values (?)");
            preparedStatement.setClob(1, clob);
            preparedStatement.execute();
            statement.execute("select * from test_clob");
            ResultSet resultSet = statement.getResultSet();
            resultSet.next();
            Assert.assertEquals((Object)"hello world", (Object)resultSet.getString("COLA"));
        }
    }

    @Test
    public void testDatabaseMetaData() throws SQLException {
        SnowflakeConnectionPoolDataSource poolDataSource = new SnowflakeConnectionPoolDataSource();
        poolDataSource = this.setProperties(poolDataSource);
        PooledConnection pooledConnection = poolDataSource.getPooledConnection();
        try (Connection logicalConnection = pooledConnection.getConnection();){
            DatabaseMetaData databaseMetaData = logicalConnection.getMetaData();
            Assert.assertEquals((Object)"Snowflake", (Object)databaseMetaData.getDatabaseProductName());
            Assert.assertEquals((Object)this.properties.get("user"), (Object)databaseMetaData.getUserName());
        }
    }

    private SnowflakeConnectionPoolDataSource setProperties(SnowflakeConnectionPoolDataSource poolDataSource) {
        poolDataSource.setUrl(this.properties.get("uri"));
        poolDataSource.setPortNumber(Integer.parseInt(this.properties.get("port")));
        poolDataSource.setSsl("on".equals(this.properties.get("ssl")));
        poolDataSource.setAccount(this.properties.get("account"));
        poolDataSource.setUser(this.properties.get("user"));
        poolDataSource.setPassword(this.properties.get("password"));
        poolDataSource.setDatabaseName(this.properties.get("database"));
        poolDataSource.setSchema(this.properties.get("schema"));
        poolDataSource.setWarehouse(this.properties.get("warehouse"));
        return poolDataSource;
    }
}

