/*
 * Decompiled with CFR 0.152.
 */
package net.snowflake.client.util;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.node.ArrayNode;
import com.fasterxml.jackson.databind.node.ObjectNode;
import java.util.HashMap;
import java.util.Map;
import net.minidev.json.JSONArray;
import net.minidev.json.JSONObject;
import net.snowflake.client.core.ObjectMapperFactory;
import net.snowflake.client.util.SecretDetector;
import org.apache.commons.lang3.RandomStringUtils;
import org.hamcrest.MatcherAssert;
import org.junit.Assert;
import org.junit.Test;

public class SecretDetectorTest {
    @Test
    public void testMaskAWSSecret() {
        String correct = "copy into 's3://xxxx/test' from \n(select seq1(), random()\n, random(), random(), random(), random()\n, random(), random(), random(), random()\n, random() , random(), random(), random()\n\tfrom table(generator(rowcount => 10000)))\ncredentials=(\n  aws_key_id='****'\n  aws_secret_key='****'\n  )\nOVERWRITE = TRUE \nMAX_FILE_SIZE = 500000000 \nHEADER = TRUE \nFILE_FORMAT = (TYPE = PARQUET SNAPPY_COMPRESSION = TRUE )\n;";
        String sql = "copy into 's3://xxxx/test' from \n(select seq1(), random()\n, random(), random(), random(), random()\n, random(), random(), random(), random()\n, random() , random(), random(), random()\n\tfrom table(generator(rowcount => 10000)))\ncredentials=(\n  aws_key_id='xxdsdfsafds'\n  aws_secret_key='safas+asfsad+safasf'\n  )\nOVERWRITE = TRUE \nMAX_FILE_SIZE = 500000000 \nHEADER = TRUE \nFILE_FORMAT = (TYPE = PARQUET SNAPPY_COMPRESSION = TRUE )\n;";
        String masked = SecretDetector.maskSecrets((String)sql);
        MatcherAssert.assertThat((String)"secret masked", (correct.compareTo(masked) == 0 ? 1 : 0) != 0);
    }

    @Test
    public void testMaskSASToken() {
        String azureSasToken = "https://someaccounts.blob.core.windows.net/results/018b90ab-0033-5f8e-0000-14f1000bd376_0/main/data_0_0_1?sv=2015-07-08&amp;sig=iCvQmdZngZNW%2F4vw43j6%2BVz6fndHF5LI639QJba4r8o%3D&amp;spr=https&amp;st=2016-04-12T03%3A24%3A31Z&amp;se=2016-04-13T03%3A29%3A31Z&amp;srt=s&amp;ss=bf&amp;sp=rwl";
        String maskedAzureSasToken = "https://someaccounts.blob.core.windows.net/results/018b90ab-0033-5f8e-0000-14f1000bd376_0/main/data_0_0_1?sv=2015-07-08&amp;sig=****&amp;spr=https&amp;st=2016-04-12T03%3A24%3A31Z&amp;se=2016-04-13T03%3A29%3A31Z&amp;srt=s&amp;ss=bf&amp;sp=rwl";
        String s3SasToken = "https://somebucket.s3.amazonaws.com/vzy1-s-va_demo0/results/018b92f3-01c2-02dd-0000-03d5000c8066_0/main/data_0_0_1?x-amz-server-side-encryption-customer-algorithm=AES256&response-content-encoding=gzip&AWSAccessKeyId=AKIAIOSFODNN7EXAMPLE&Expires=1555481960&Signature=zFiRkdB9RtRRYomppVes4fQ%2ByWw%3D";
        String maskedS3SasToken = "https://somebucket.s3.amazonaws.com/vzy1-s-va_demo0/results/018b92f3-01c2-02dd-0000-03d5000c8066_0/main/data_0_0_1?x-amz-server-side-encryption-customer-algorithm=AES256&response-content-encoding=gzip&AWSAccessKeyId=****&Expires=1555481960&Signature=****";
        MatcherAssert.assertThat((String)"Azure SAS token is not masked", (boolean)"https://someaccounts.blob.core.windows.net/results/018b90ab-0033-5f8e-0000-14f1000bd376_0/main/data_0_0_1?sv=2015-07-08&amp;sig=****&amp;spr=https&amp;st=2016-04-12T03%3A24%3A31Z&amp;se=2016-04-13T03%3A29%3A31Z&amp;srt=s&amp;ss=bf&amp;sp=rwl".equals(SecretDetector.maskSecrets((String)"https://someaccounts.blob.core.windows.net/results/018b90ab-0033-5f8e-0000-14f1000bd376_0/main/data_0_0_1?sv=2015-07-08&amp;sig=iCvQmdZngZNW%2F4vw43j6%2BVz6fndHF5LI639QJba4r8o%3D&amp;spr=https&amp;st=2016-04-12T03%3A24%3A31Z&amp;se=2016-04-13T03%3A29%3A31Z&amp;srt=s&amp;ss=bf&amp;sp=rwl")));
        MatcherAssert.assertThat((String)"S3 SAS token is not masked", (boolean)"https://somebucket.s3.amazonaws.com/vzy1-s-va_demo0/results/018b92f3-01c2-02dd-0000-03d5000c8066_0/main/data_0_0_1?x-amz-server-side-encryption-customer-algorithm=AES256&response-content-encoding=gzip&AWSAccessKeyId=****&Expires=1555481960&Signature=****".equals(SecretDetector.maskSecrets((String)"https://somebucket.s3.amazonaws.com/vzy1-s-va_demo0/results/018b92f3-01c2-02dd-0000-03d5000c8066_0/main/data_0_0_1?x-amz-server-side-encryption-customer-algorithm=AES256&response-content-encoding=gzip&AWSAccessKeyId=AKIAIOSFODNN7EXAMPLE&Expires=1555481960&Signature=zFiRkdB9RtRRYomppVes4fQ%2ByWw%3D")));
        String randomString = RandomStringUtils.random((int)200);
        MatcherAssert.assertThat((String)"Text without secrets is not unmodified", (boolean)randomString.equals(SecretDetector.maskSecrets((String)randomString)));
        MatcherAssert.assertThat((String)"Text with 2 Azure SAS tokens is not masked", (boolean)"https://someaccounts.blob.core.windows.net/results/018b90ab-0033-5f8e-0000-14f1000bd376_0/main/data_0_0_1?sv=2015-07-08&amp;sig=****&amp;spr=https&amp;st=2016-04-12T03%3A24%3A31Z&amp;se=2016-04-13T03%3A29%3A31Z&amp;srt=s&amp;ss=bf&amp;sp=rwlhttps://someaccounts.blob.core.windows.net/results/018b90ab-0033-5f8e-0000-14f1000bd376_0/main/data_0_0_1?sv=2015-07-08&amp;sig=****&amp;spr=https&amp;st=2016-04-12T03%3A24%3A31Z&amp;se=2016-04-13T03%3A29%3A31Z&amp;srt=s&amp;ss=bf&amp;sp=rwl".equals(SecretDetector.maskSecrets((String)"https://someaccounts.blob.core.windows.net/results/018b90ab-0033-5f8e-0000-14f1000bd376_0/main/data_0_0_1?sv=2015-07-08&amp;sig=iCvQmdZngZNW%2F4vw43j6%2BVz6fndHF5LI639QJba4r8o%3D&amp;spr=https&amp;st=2016-04-12T03%3A24%3A31Z&amp;se=2016-04-13T03%3A29%3A31Z&amp;srt=s&amp;ss=bf&amp;sp=rwlhttps://someaccounts.blob.core.windows.net/results/018b90ab-0033-5f8e-0000-14f1000bd376_0/main/data_0_0_1?sv=2015-07-08&amp;sig=iCvQmdZngZNW%2F4vw43j6%2BVz6fndHF5LI639QJba4r8o%3D&amp;spr=https&amp;st=2016-04-12T03%3A24%3A31Z&amp;se=2016-04-13T03%3A29%3A31Z&amp;srt=s&amp;ss=bf&amp;sp=rwl")));
        MatcherAssert.assertThat((String)"Text with 2 S3 SAS tokens is not masked", (boolean)"https://someaccounts.blob.core.windows.net/results/018b90ab-0033-5f8e-0000-14f1000bd376_0/main/data_0_0_1?sv=2015-07-08&amp;sig=****&amp;spr=https&amp;st=2016-04-12T03%3A24%3A31Z&amp;se=2016-04-13T03%3A29%3A31Z&amp;srt=s&amp;ss=bf&amp;sp=rwlhttps://someaccounts.blob.core.windows.net/results/018b90ab-0033-5f8e-0000-14f1000bd376_0/main/data_0_0_1?sv=2015-07-08&amp;sig=****&amp;spr=https&amp;st=2016-04-12T03%3A24%3A31Z&amp;se=2016-04-13T03%3A29%3A31Z&amp;srt=s&amp;ss=bf&amp;sp=rwl".equals(SecretDetector.maskSecrets((String)"https://someaccounts.blob.core.windows.net/results/018b90ab-0033-5f8e-0000-14f1000bd376_0/main/data_0_0_1?sv=2015-07-08&amp;sig=iCvQmdZngZNW%2F4vw43j6%2BVz6fndHF5LI639QJba4r8o%3D&amp;spr=https&amp;st=2016-04-12T03%3A24%3A31Z&amp;se=2016-04-13T03%3A29%3A31Z&amp;srt=s&amp;ss=bf&amp;sp=rwlhttps://someaccounts.blob.core.windows.net/results/018b90ab-0033-5f8e-0000-14f1000bd376_0/main/data_0_0_1?sv=2015-07-08&amp;sig=iCvQmdZngZNW%2F4vw43j6%2BVz6fndHF5LI639QJba4r8o%3D&amp;spr=https&amp;st=2016-04-12T03%3A24%3A31Z&amp;se=2016-04-13T03%3A29%3A31Z&amp;srt=s&amp;ss=bf&amp;sp=rwl")));
        MatcherAssert.assertThat((String)"Text with Azure and S3 SAS tokens is not masked", (boolean)"https://someaccounts.blob.core.windows.net/results/018b90ab-0033-5f8e-0000-14f1000bd376_0/main/data_0_0_1?sv=2015-07-08&amp;sig=****&amp;spr=https&amp;st=2016-04-12T03%3A24%3A31Z&amp;se=2016-04-13T03%3A29%3A31Z&amp;srt=s&amp;ss=bf&amp;sp=rwlhttps://somebucket.s3.amazonaws.com/vzy1-s-va_demo0/results/018b92f3-01c2-02dd-0000-03d5000c8066_0/main/data_0_0_1?x-amz-server-side-encryption-customer-algorithm=AES256&response-content-encoding=gzip&AWSAccessKeyId=****&Expires=1555481960&Signature=****".equals(SecretDetector.maskSecrets((String)"https://someaccounts.blob.core.windows.net/results/018b90ab-0033-5f8e-0000-14f1000bd376_0/main/data_0_0_1?sv=2015-07-08&amp;sig=iCvQmdZngZNW%2F4vw43j6%2BVz6fndHF5LI639QJba4r8o%3D&amp;spr=https&amp;st=2016-04-12T03%3A24%3A31Z&amp;se=2016-04-13T03%3A29%3A31Z&amp;srt=s&amp;ss=bf&amp;sp=rwlhttps://somebucket.s3.amazonaws.com/vzy1-s-va_demo0/results/018b92f3-01c2-02dd-0000-03d5000c8066_0/main/data_0_0_1?x-amz-server-side-encryption-customer-algorithm=AES256&response-content-encoding=gzip&AWSAccessKeyId=AKIAIOSFODNN7EXAMPLE&Expires=1555481960&Signature=zFiRkdB9RtRRYomppVes4fQ%2ByWw%3D")));
    }

    @Test
    public void testMaskSecrets() {
        String sqlText = "create stage mystage URL = 's3://mybucket/mypath/' credentials = (aws_key_id = 'AKIAIOSFODNN7EXAMPLE' aws_secret_key = 'frJIUN8DYpKDtOLCwo//yllqDzg='); create stage mystage2 URL = 'azure//mystorage.blob.core.windows.net/cont' credentials = (azure_sas_token = '?sv=2016-05-31&ss=b&srt=sco&sp=rwdl&se=2018-06-27T10:05:50Z&st=2017-06-27T02:05:50Z&spr=https,http&sig=bgqQwoXwxzuD2GJfagRg7VOS8hzNr3QLT7rhS8OFRLQ%3D')";
        String maskedSqlText = "create stage mystage URL = 's3://mybucket/mypath/' credentials = (aws_key_id = '****' aws_secret_key = '****'); create stage mystage2 URL = 'azure//mystorage.blob.core.windows.net/cont' credentials = (azure_sas_token = '?sv=2016-05-31&ss=b&srt=sco&sp=rwdl&se=2018-06-27T10:05:50Z&st=2017-06-27T02:05:50Z&spr=https,http&sig=****')";
        String masked = SecretDetector.maskSecrets((String)"create stage mystage URL = 's3://mybucket/mypath/' credentials = (aws_key_id = 'AKIAIOSFODNN7EXAMPLE' aws_secret_key = 'frJIUN8DYpKDtOLCwo//yllqDzg='); create stage mystage2 URL = 'azure//mystorage.blob.core.windows.net/cont' credentials = (azure_sas_token = '?sv=2016-05-31&ss=b&srt=sco&sp=rwdl&se=2018-06-27T10:05:50Z&st=2017-06-27T02:05:50Z&spr=https,http&sig=bgqQwoXwxzuD2GJfagRg7VOS8hzNr3QLT7rhS8OFRLQ%3D')");
        System.out.println(masked);
        System.out.println("create stage mystage URL = 's3://mybucket/mypath/' credentials = (aws_key_id = '****' aws_secret_key = '****'); create stage mystage2 URL = 'azure//mystorage.blob.core.windows.net/cont' credentials = (azure_sas_token = '?sv=2016-05-31&ss=b&srt=sco&sp=rwdl&se=2018-06-27T10:05:50Z&st=2017-06-27T02:05:50Z&spr=https,http&sig=****')");
        MatcherAssert.assertThat((String)"Text with AWS secret and Azure SAS token is not masked", (boolean)"create stage mystage URL = 's3://mybucket/mypath/' credentials = (aws_key_id = '****' aws_secret_key = '****'); create stage mystage2 URL = 'azure//mystorage.blob.core.windows.net/cont' credentials = (azure_sas_token = '?sv=2016-05-31&ss=b&srt=sco&sp=rwdl&se=2018-06-27T10:05:50Z&st=2017-06-27T02:05:50Z&spr=https,http&sig=****')".equals(masked));
        String randomString = RandomStringUtils.random((int)500);
        MatcherAssert.assertThat((String)"Text without secrets is not unmodified", (boolean)randomString.equals(SecretDetector.maskSecrets((String)randomString)));
    }

    @Test
    public void testMaskPasswordFromConnectionString() {
        String connectionStr = "\"jdbc:snowflake://xxx.snowflakecomputing.com/?user=xxx&password=xxxxxx&role=xxx\"";
        String maskedConnectionStr = "\"jdbc:snowflake://xxx.snowflakecomputing.com/?user=xxx&password=**** ";
        MatcherAssert.assertThat((String)"Text with password is not masked", (boolean)maskedConnectionStr.equals(SecretDetector.maskSecrets((String)connectionStr)));
        connectionStr = "jdbc:snowflake://xxx.snowflakecomputing.com/?user=xxx&password=xxxxxx";
        maskedConnectionStr = "jdbc:snowflake://xxx.snowflakecomputing.com/?user=xxx&password=**** ";
        MatcherAssert.assertThat((String)"Text with password is not masked", (boolean)maskedConnectionStr.equals(SecretDetector.maskSecrets((String)connectionStr)));
        connectionStr = "jdbc:snowflake://xxx.snowflakecomputing.com/?user=xxx&passcode=xxxxxx";
        maskedConnectionStr = "jdbc:snowflake://xxx.snowflakecomputing.com/?user=xxx&passcode=**** ";
        MatcherAssert.assertThat((String)"Text with password is not masked", (boolean)maskedConnectionStr.equals(SecretDetector.maskSecrets((String)connectionStr)));
        connectionStr = "jdbc:snowflake://xxx.snowflakecomputing.com/?user=xxx&passWord=xxxxxx";
        maskedConnectionStr = "jdbc:snowflake://xxx.snowflakecomputing.com/?user=xxx&passWord=**** ";
        MatcherAssert.assertThat((String)"Text with password is not masked", (boolean)maskedConnectionStr.equals(SecretDetector.maskSecrets((String)connectionStr)));
    }

    @Test
    public void sasTokenFilterTest() throws Exception {
        String messageText = "\"privateKeyData\": \"aslkjdflasjf\"";
        String filteredMessageText = "\"privateKeyData\": \"XXXX\"";
        String result = SecretDetector.maskSecrets((String)messageText);
        Assert.assertEquals((Object)filteredMessageText, (Object)result);
    }

    @Test
    public void testMaskParameterValue() {
        HashMap<String, String> testParametersMasked = new HashMap<String, String>();
        testParametersMasked.put("passcodeInPassword", "test");
        testParametersMasked.put("passcode", "test");
        testParametersMasked.put("id_token", "test");
        testParametersMasked.put("private_key_file_pwd", "test");
        testParametersMasked.put("proxyPassword", "test");
        testParametersMasked.put("proxyUser", "test");
        HashMap<String, String> testParametersUnmasked = new HashMap<String, String>();
        testParametersUnmasked.put("oktausername", "test");
        testParametersUnmasked.put("authenticator", "test");
        testParametersUnmasked.put("proxyHost", "test");
        testParametersUnmasked.put("user", "test");
        testParametersUnmasked.put("private_key_file", "test");
        for (Map.Entry entry : testParametersMasked.entrySet()) {
            Assert.assertEquals((Object)"****", (Object)SecretDetector.maskParameterValue((String)((String)entry.getKey()), (String)((String)entry.getValue())));
        }
        for (Map.Entry entry : testParametersUnmasked.entrySet()) {
            Assert.assertEquals((Object)"test", (Object)SecretDetector.maskParameterValue((String)((String)entry.getKey()), (String)((String)entry.getValue())));
        }
    }

    @Test
    public void testMaskconnectionToken() {
        String connectionToken = "\"Authorization: Snowflake Token=\"XXXXXXXXXX\"\"";
        String maskedConnectionToken = "\"Authorization: Snowflake Token=\"****\"\"";
        MatcherAssert.assertThat((String)"Text with connection token is not masked", (boolean)maskedConnectionToken.equals(SecretDetector.maskSecrets((String)connectionToken)));
        connectionToken = "\"{\"requestType\":\"ISSUE\",\"idToken\":\"XXXXXXXX\"}\"";
        maskedConnectionToken = "\"{\"requestType\":\"ISSUE\",\"idToken\":\"****\"}\"";
        MatcherAssert.assertThat((String)"Text with connection token is not masked", (boolean)maskedConnectionToken.equals(SecretDetector.maskSecrets((String)connectionToken)));
    }

    private JSONObject generateJsonObject() {
        JSONObject obj = new JSONObject();
        obj.put((Object)"hello", (Object)"world");
        obj.put((Object)"number", (Object)256);
        obj.put((Object)"boolean", (Object)true);
        return obj;
    }

    @Test
    public void testMaskJsonObject() {
        String connStr = "https://snowflake.fakehostname.local:fakeport?LOGINTIMEOUT=20&ACCOUNT=fakeaccount&PASSWORD=fakepassword&USER=fakeuser";
        String maskedConnStr = "https://snowflake.fakehostname.local:fakeport?LOGINTIMEOUT=20&ACCOUNT=fakeaccount&PASSWORD=**** ";
        JSONObject obj = this.generateJsonObject();
        obj.put((Object)"connStr", (Object)"https://snowflake.fakehostname.local:fakeport?LOGINTIMEOUT=20&ACCOUNT=fakeaccount&PASSWORD=fakepassword&USER=fakeuser");
        JSONObject maskedObj = this.generateJsonObject();
        maskedObj.put((Object)"connStr", (Object)"https://snowflake.fakehostname.local:fakeport?LOGINTIMEOUT=20&ACCOUNT=fakeaccount&PASSWORD=**** ");
        MatcherAssert.assertThat((String)"JSONObject is not masked successfully", (boolean)maskedObj.equals((Object)SecretDetector.maskJsonObject((JSONObject)obj)));
        obj.put((Object)"connStr", (Object)"https://snowflake.fakehostname.local:fakeport?LOGINTIMEOUT=20&ACCOUNT=fakeaccount&PASSWORD=fakepassword&USER=fakeuser");
        JSONObject nestedObj = this.generateJsonObject();
        nestedObj.put((Object)"subJson", (Object)obj);
        JSONObject maskedNestedObj = this.generateJsonObject();
        maskedNestedObj.put((Object)"subJson", (Object)maskedObj);
        MatcherAssert.assertThat((String)"nested JSONObject is not masked successfully", (boolean)maskedNestedObj.equals((Object)SecretDetector.maskJsonObject((JSONObject)nestedObj)));
    }

    @Test
    public void testMaskJsonArray() {
        String connStr = "https://snowflake.fakehostname.local:fakeport?LOGINTIMEOUT=20&ACCOUNT=fakeaccount&PASSWORD=fakepassword&USER=fakeuser";
        String maskedConnStr = "https://snowflake.fakehostname.local:fakeport?LOGINTIMEOUT=20&ACCOUNT=fakeaccount&PASSWORD=**** ";
        String pwdStr = "password=ThisShouldBeMasked";
        String maskedPwdStr = "password=****";
        JSONObject obj = this.generateJsonObject();
        obj.put((Object)"connStr", (Object)"https://snowflake.fakehostname.local:fakeport?LOGINTIMEOUT=20&ACCOUNT=fakeaccount&PASSWORD=fakepassword&USER=fakeuser");
        JSONObject maskedObj = this.generateJsonObject();
        maskedObj.put((Object)"connStr", (Object)"https://snowflake.fakehostname.local:fakeport?LOGINTIMEOUT=20&ACCOUNT=fakeaccount&PASSWORD=**** ");
        JSONArray array = new JSONArray();
        array.add((Object)obj);
        array.add((Object)"password=ThisShouldBeMasked");
        JSONArray maskedArray = new JSONArray();
        maskedArray.add((Object)maskedObj);
        maskedArray.add((Object)"password=****");
        MatcherAssert.assertThat((String)"jsonArray is not masked successfully", (boolean)maskedArray.equals((Object)SecretDetector.maskJsonArray((JSONArray)array)));
        JSONObject obj1 = this.generateJsonObject();
        obj1.put((Object)"connStr", (Object)"https://snowflake.fakehostname.local:fakeport?LOGINTIMEOUT=20&ACCOUNT=fakeaccount&PASSWORD=fakepassword&USER=fakeuser");
        JSONObject maskedObj1 = this.generateJsonObject();
        maskedObj1.put((Object)"connStr", (Object)"https://snowflake.fakehostname.local:fakeport?LOGINTIMEOUT=20&ACCOUNT=fakeaccount&PASSWORD=**** ");
        JSONArray array1 = new JSONArray();
        array1.add((Object)obj1);
        array1.add((Object)"password=ThisShouldBeMasked");
        JSONArray maskedArray1 = new JSONArray();
        maskedArray1.add((Object)maskedObj1);
        maskedArray1.add((Object)"password=****");
        JSONObject nestedObjArray = this.generateJsonObject();
        nestedObjArray.put((Object)"array", (Object)array1);
        JSONObject maskedNestedObjArray = this.generateJsonObject();
        maskedNestedObjArray.put((Object)"array", (Object)maskedArray1);
        MatcherAssert.assertThat((String)"JSONArray within JSONObject is not masked successfully", (boolean)maskedNestedObjArray.equals((Object)SecretDetector.maskJsonObject((JSONObject)nestedObjArray)));
    }

    @Test
    public void testMaskJacksonObject() {
        ObjectMapper mapper = ObjectMapperFactory.getObjectMapper();
        ObjectNode objNode = mapper.createObjectNode();
        objNode.put("testInfo", "pwd=HelloWorld!");
        String maskedObjNodeStr = "{\"testInfo\":\"pwd=**** \"}";
        MatcherAssert.assertThat((String)"Jackson ObjectNode is not masked successfully", (boolean)maskedObjNodeStr.equals(SecretDetector.maskJacksonNode((JsonNode)objNode).toString()));
        ObjectNode objNode1 = mapper.createObjectNode();
        objNode1.put("testInfo", "pwd=HelloWorld!");
        ObjectNode objNodeNested = mapper.createObjectNode();
        objNodeNested.put("dummy", "dummy");
        objNodeNested.put("testInfo2", "sig=ajwAWD45%+ajrH92knKfsfakj");
        objNode1.set("testNested", (JsonNode)objNodeNested);
        String maskedObjNestedStr = "{\"testInfo\":\"pwd=**** \",\"testNested\":{\"dummy\":\"dummy\",\"testInfo2\":\"sig=****\"}}";
        MatcherAssert.assertThat((String)"Nested Jackson ObjectNode is not masked successfully", (boolean)maskedObjNestedStr.equals(SecretDetector.maskJacksonNode((JsonNode)objNode1).toString()));
        ObjectNode objNode2 = mapper.createObjectNode();
        objNode2.put("testInfo", "aws_secret_key= 'fakeAWSsecretKey!123'");
        ArrayNode arrayObj = mapper.createArrayNode();
        arrayObj.add((JsonNode)objNode2);
        arrayObj.add("fake token: SDFADAVN4ASD28ASFG3234x");
        String maskedArrayNodeStr = "[{\"testInfo\":\"aws_secret_key= '****'\"},\"fake token: ****\"]";
        MatcherAssert.assertThat((String)"Jackson ArrayNode is not masked successfully", (boolean)maskedArrayNodeStr.equals(SecretDetector.maskJacksonNode((JsonNode)arrayObj).toString()));
        ObjectNode objNode3 = mapper.createObjectNode();
        objNode3.put("testInfo", "\"privateKeyData\": \"abcdefg012345/=+\"");
        ArrayNode arrayObj1 = mapper.createArrayNode();
        arrayObj1.add((JsonNode)objNode3);
        ObjectNode objNode4 = mapper.createObjectNode();
        objNode4.set("testArrayNode", (JsonNode)arrayObj1);
        objNode4.put("hello", "world");
        objNode4.put("password", "password = HelloWorld!");
        String maskedNestedArrayStr = "{\"testArrayNode\":[{\"testInfo\":\"\\\"privateKeyData\\\": \\\"XXXX\\\"\"}],\"hello\":\"world\",\"password\":\"password = **** \"}";
        SecretDetector.maskJacksonNode((JsonNode)objNode4);
        MatcherAssert.assertThat((String)"Nested Jackson array node is not masked successfully", (boolean)maskedNestedArrayStr.equals(SecretDetector.maskJacksonNode((JsonNode)objNode4).toString()));
    }
}

