/*
 * Decompiled with CFR 0.152.
 */
package net.snowflake.client.core;

import java.sql.DriverPropertyInfo;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import net.snowflake.client.core.HttpClientSettingsKey;
import net.snowflake.client.core.OCSPMode;
import net.snowflake.client.core.QueryContextDTO;
import net.snowflake.client.core.QueryStatus;
import net.snowflake.client.core.SFException;
import net.snowflake.client.core.SFSessionProperty;
import net.snowflake.client.jdbc.ErrorCode;
import net.snowflake.client.jdbc.QueryStatusV2;
import net.snowflake.client.jdbc.SFConnectionHandler;
import net.snowflake.client.jdbc.SnowflakeConnectString;
import net.snowflake.client.jdbc.SnowflakeSQLException;
import net.snowflake.client.jdbc.SnowflakeType;
import net.snowflake.client.jdbc.SnowflakeUtil;
import net.snowflake.client.jdbc.internal.google.common.base.Strings;
import net.snowflake.client.jdbc.telemetry.Telemetry;
import net.snowflake.client.log.SFLogger;
import net.snowflake.client.log.SFLoggerFactory;

public abstract class SFBaseSession {
    static final SFLogger logger = SFLoggerFactory.getLogger(SFBaseSession.class);
    private final Properties clientInfo = new Properties();
    private final AtomicBoolean autoCommit = new AtomicBoolean(true);
    private final AtomicInteger _injectedDelay = new AtomicInteger(0);
    private final Map<SFSessionProperty, Object> connectionPropertiesMap = new HashMap<SFSessionProperty, Object>();
    private final Map<String, Object> customSessionProperties = new HashMap<String, Object>(1);
    private SFConnectionHandler sfConnectionHandler;
    protected List<SFException> sqlWarnings = new ArrayList<SFException>();
    private String sessionId;
    private String databaseVersion = null;
    private int databaseMajorVersion = 0;
    private int databaseMinorVersion = 0;
    private SnowflakeType timestampMappedType = SnowflakeType.TIMESTAMP_LTZ;
    private boolean isResultColumnCaseInsensitive;
    private boolean isJdbcTreatDecimalAsInt = true;
    private boolean treatNTZAsUTC;
    private boolean preparedStatementLogging = false;
    private String injectFileUploadFailure;
    private boolean enableHeartbeat;
    protected int heartbeatFrequency = 3600;
    private boolean formatDateWithTimezone;
    private boolean enableCombineDescribe;
    private boolean clientTelemetryEnabled = false;
    private boolean useSessionTimezone;
    private int arrayBindStageThreshold = 0;
    private boolean storeTemporaryCredential;
    private String serviceName;
    private boolean sfSQLMode;
    private boolean enableConservativeMemoryUsage;
    private int conservativeMemoryAdjustStep = 64;
    private int clientMemoryLimit;
    private int clientResultChunkSize;
    private int clientPrefetchThreads;
    private boolean validateDefaultParameters;
    private String database;
    private String schema;
    private String role;
    private String warehouse;
    private boolean metadataRequestUseConnectionCtx = false;
    private boolean metadataRequestUseSessionDatabase = false;
    private boolean useRegionalS3EndpointsForPresignedURL = false;
    private final Map<String, Object> otherParameters = new HashMap<String, Object>();
    private HttpClientSettingsKey ocspAndProxyAndGzipKey = null;
    public static long MEMORY_LIMIT_UNSET = -1L;
    private long memoryLimitForTesting = MEMORY_LIMIT_UNSET;
    private String arrayBindStage = null;
    private int queryContextCacheSize = 5;
    private boolean enableReturnTimestampWithTimeZone = true;
    private boolean jdbcEnablePutGet = true;
    private boolean enablePutGet = true;
    private boolean enablePatternSearch = true;
    private Map<String, Object> commonParameters;

    protected SFBaseSession(SFConnectionHandler sfConnectionHandler) {
        this.sfConnectionHandler = sfConnectionHandler;
    }

    public void setMemoryLimitForTesting(long memLimit) {
        this.memoryLimitForTesting = memLimit;
    }

    public long getMemoryLimitForTesting() {
        return this.memoryLimitForTesting;
    }

    public Properties getClientInfo() {
        Properties copy = new Properties();
        copy.putAll((Map<?, ?>)this.clientInfo);
        return copy;
    }

    public void setCommonParameters(Map<String, Object> parameters) {
        this.commonParameters = parameters;
    }

    public Map<String, Object> getCommonParameters() {
        return this.commonParameters;
    }

    public String getClientInfo(String name) {
        return this.clientInfo.getProperty(name);
    }

    public String getSessionId() {
        return this.sessionId;
    }

    public void setSessionId(String sessionId) {
        this.sessionId = sessionId;
    }

    public boolean isSfSQLMode() {
        return this.sfSQLMode;
    }

    public void setSfSQLMode(boolean sfSQLMode) {
        this.sfSQLMode = sfSQLMode;
    }

    public String getDatabaseVersion() {
        return this.databaseVersion;
    }

    public void setDatabaseVersion(String databaseVersion) {
        this.databaseVersion = databaseVersion;
    }

    public int getDatabaseMajorVersion() {
        return this.databaseMajorVersion;
    }

    public void setDatabaseMajorVersion(int databaseMajorVersion) {
        this.databaseMajorVersion = databaseMajorVersion;
    }

    public int getDatabaseMinorVersion() {
        return this.databaseMinorVersion;
    }

    public void setDatabaseMinorVersion(int databaseMinorVersion) {
        this.databaseMinorVersion = databaseMinorVersion;
    }

    public boolean getPreparedStatementLogging() {
        return this.preparedStatementLogging;
    }

    public void setPreparedStatementLogging(boolean value) {
        this.preparedStatementLogging = value;
    }

    public String getInjectFileUploadFailure() {
        return this.injectFileUploadFailure;
    }

    public void setInjectFileUploadFailure(String fileToFail) {
        this.injectFileUploadFailure = fileToFail;
    }

    public SnowflakeType getTimestampMappedType() {
        return this.timestampMappedType;
    }

    public void setTimestampMappedType(SnowflakeType timestampMappedType) {
        this.timestampMappedType = timestampMappedType;
    }

    public boolean isResultColumnCaseInsensitive() {
        return this.isResultColumnCaseInsensitive;
    }

    public void setResultColumnCaseInsensitive(boolean resultColumnCaseInsensitive) {
        this.isResultColumnCaseInsensitive = resultColumnCaseInsensitive;
    }

    public boolean isJdbcTreatDecimalAsInt() {
        return this.isJdbcTreatDecimalAsInt;
    }

    public void setJdbcTreatDecimalAsInt(boolean jdbcTreatDecimalAsInt) {
        this.isJdbcTreatDecimalAsInt = jdbcTreatDecimalAsInt;
    }

    public String getServerUrl() {
        if (this.connectionPropertiesMap.containsKey((Object)SFSessionProperty.SERVER_URL)) {
            return (String)this.connectionPropertiesMap.get((Object)SFSessionProperty.SERVER_URL);
        }
        return null;
    }

    public boolean isStringQuoted() {
        if (this.connectionPropertiesMap.containsKey((Object)SFSessionProperty.STRINGS_QUOTED)) {
            return (Boolean)this.connectionPropertiesMap.get((Object)SFSessionProperty.STRINGS_QUOTED);
        }
        return false;
    }

    public void addProperty(SFSessionProperty sfSessionProperty, Object propertyValue) throws SFException {
        this.addProperty(sfSessionProperty.getPropertyKey(), propertyValue);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void addProperty(String propertyName, Object propertyValue) throws SFException {
        SFSessionProperty connectionProperty = SFSessionProperty.lookupByKey(propertyName);
        propertyValue = SFSessionProperty.checkPropertyValue(connectionProperty, propertyValue);
        if (this.connectionPropertiesMap.containsKey((Object)connectionProperty)) {
            throw new SFException(ErrorCode.DUPLICATE_CONNECTION_PROPERTY_SPECIFIED, propertyName);
        }
        if (propertyValue != null && connectionProperty == SFSessionProperty.AUTHENTICATOR) {
            String[] authenticatorWithParams = propertyValue.toString().split(";");
            if (authenticatorWithParams.length == 1) {
                this.connectionPropertiesMap.put(connectionProperty, propertyValue);
                return;
            } else {
                String[] oktaUserKeyPair = authenticatorWithParams[1].split("=");
                if (oktaUserKeyPair.length != 2) throw new SFException(ErrorCode.INVALID_OKTA_USERNAME, propertyName);
                this.connectionPropertiesMap.put(connectionProperty, authenticatorWithParams[0]);
                this.connectionPropertiesMap.put(SFSessionProperty.OKTA_USERNAME, oktaUserKeyPair[1]);
            }
            return;
        } else {
            this.connectionPropertiesMap.put(connectionProperty, propertyValue);
        }
    }

    public Map<SFSessionProperty, Object> getConnectionPropertiesMap() {
        return this.connectionPropertiesMap;
    }

    public HttpClientSettingsKey getHttpClientKey() throws SnowflakeSQLException {
        if (this.ocspAndProxyAndGzipKey != null) {
            return this.ocspAndProxyAndGzipKey;
        }
        Boolean gzipDisabled = false;
        if (this.connectionPropertiesMap.containsKey((Object)SFSessionProperty.GZIP_DISABLED)) {
            gzipDisabled = (Boolean)this.connectionPropertiesMap.get((Object)SFSessionProperty.GZIP_DISABLED);
        }
        boolean useProxy = false;
        if (this.connectionPropertiesMap.containsKey((Object)SFSessionProperty.USE_PROXY)) {
            useProxy = (Boolean)this.connectionPropertiesMap.get((Object)SFSessionProperty.USE_PROXY);
        }
        String userAgentSuffix = "";
        if (this.connectionPropertiesMap.containsKey((Object)SFSessionProperty.USER_AGENT_SUFFIX)) {
            userAgentSuffix = (String)this.connectionPropertiesMap.get((Object)SFSessionProperty.USER_AGENT_SUFFIX);
        }
        if (useProxy) {
            int proxyPort;
            try {
                proxyPort = Integer.parseInt(this.connectionPropertiesMap.get((Object)SFSessionProperty.PROXY_PORT).toString());
            }
            catch (NullPointerException | NumberFormatException e) {
                throw new SnowflakeSQLException(ErrorCode.INVALID_PROXY_PROPERTIES, "Could not parse port number");
            }
            String proxyHost = (String)this.connectionPropertiesMap.get((Object)SFSessionProperty.PROXY_HOST);
            String proxyUser = (String)this.connectionPropertiesMap.get((Object)SFSessionProperty.PROXY_USER);
            String proxyPassword = (String)this.connectionPropertiesMap.get((Object)SFSessionProperty.PROXY_PASSWORD);
            String nonProxyHosts = (String)this.connectionPropertiesMap.get((Object)SFSessionProperty.NON_PROXY_HOSTS);
            String proxyProtocol = (String)this.connectionPropertiesMap.get((Object)SFSessionProperty.PROXY_PROTOCOL);
            this.ocspAndProxyAndGzipKey = new HttpClientSettingsKey(this.getOCSPMode(), proxyHost, proxyPort, nonProxyHosts, proxyUser, proxyPassword, proxyProtocol, userAgentSuffix, gzipDisabled);
            return this.ocspAndProxyAndGzipKey;
        }
        boolean httpUseProxy = Boolean.parseBoolean(SnowflakeUtil.systemGetProperty("http.useProxy"));
        String httpProxyHost = SnowflakeUtil.systemGetProperty("http.proxyHost");
        String httpProxyPort = SnowflakeUtil.systemGetProperty("http.proxyPort");
        String httpsProxyHost = SnowflakeUtil.systemGetProperty("https.proxyHost");
        String httpsProxyPort = SnowflakeUtil.systemGetProperty("https.proxyPort");
        String httpProxyProtocol = SnowflakeUtil.systemGetProperty("http.proxyProtocol");
        String noProxy = SnowflakeUtil.systemGetEnv("NO_PROXY");
        String nonProxyHosts = SnowflakeUtil.systemGetProperty("http.nonProxyHosts");
        if (httpUseProxy) {
            String combinedNonProxyHosts;
            logger.debug("http.useProxy={}, http.proxyHost={}, http.proxyPort={}, https.proxyHost={}, https.proxyPort={}, http.nonProxyHosts={}, NO_PROXY={}, http.proxyProtocol={}", httpUseProxy, httpProxyHost, httpProxyPort, httpsProxyHost, httpsProxyPort, nonProxyHosts, noProxy, httpProxyProtocol, userAgentSuffix, gzipDisabled);
            String string = combinedNonProxyHosts = Strings.isNullOrEmpty(nonProxyHosts) ? "" : nonProxyHosts;
            if (!Strings.isNullOrEmpty(noProxy)) {
                combinedNonProxyHosts = combinedNonProxyHosts + (combinedNonProxyHosts.length() == 0 ? "" : "|");
                combinedNonProxyHosts = combinedNonProxyHosts + noProxy;
            }
            String proxyProtocol = "http";
            if (!Strings.isNullOrEmpty(httpProxyProtocol)) {
                proxyProtocol = httpProxyProtocol;
            } else if (!Strings.isNullOrEmpty(httpsProxyHost) && !Strings.isNullOrEmpty(httpsProxyPort) && Strings.isNullOrEmpty(httpProxyHost) && Strings.isNullOrEmpty(httpProxyPort)) {
                proxyProtocol = "https";
            }
            if (proxyProtocol.equals("https") && !Strings.isNullOrEmpty(httpsProxyHost) && !Strings.isNullOrEmpty(httpsProxyPort)) {
                int proxyPort;
                try {
                    proxyPort = Integer.parseInt(httpsProxyPort);
                }
                catch (NullPointerException | NumberFormatException e) {
                    throw new SnowflakeSQLException(ErrorCode.INVALID_PROXY_PROPERTIES, "Could not parse port number");
                }
                this.ocspAndProxyAndGzipKey = new HttpClientSettingsKey(this.getOCSPMode(), httpsProxyHost, proxyPort, combinedNonProxyHosts, "", "", "https", userAgentSuffix, gzipDisabled);
            } else if (proxyProtocol.equals("http") && !Strings.isNullOrEmpty(httpProxyHost) && !Strings.isNullOrEmpty(httpProxyPort)) {
                int proxyPort;
                try {
                    proxyPort = Integer.parseInt(httpProxyPort);
                }
                catch (NullPointerException | NumberFormatException e) {
                    throw new SnowflakeSQLException(ErrorCode.INVALID_PROXY_PROPERTIES, "Could not parse port number");
                }
                this.ocspAndProxyAndGzipKey = new HttpClientSettingsKey(this.getOCSPMode(), httpProxyHost, proxyPort, combinedNonProxyHosts, "", "", "http", userAgentSuffix, gzipDisabled);
            } else {
                logger.debug("http.useProxy={} but valid host and port were not provided. No proxy in use.", httpUseProxy);
                this.ocspAndProxyAndGzipKey = new HttpClientSettingsKey(this.getOCSPMode(), userAgentSuffix, gzipDisabled);
            }
        } else {
            logger.debug("http.useProxy={}. JVM proxy not used.", httpUseProxy);
            this.unsetInvalidProxyHostAndPort();
            this.ocspAndProxyAndGzipKey = new HttpClientSettingsKey(this.getOCSPMode(), userAgentSuffix, gzipDisabled);
        }
        return this.ocspAndProxyAndGzipKey;
    }

    public void unsetInvalidProxyHostAndPort() {
        if (!Strings.isNullOrEmpty(SnowflakeUtil.systemGetProperty("proxyHost"))) {
            System.clearProperty("proxyHost");
        }
        if (!Strings.isNullOrEmpty(SnowflakeUtil.systemGetProperty("proxyPort"))) {
            System.clearProperty("proxyPort");
        }
    }

    public OCSPMode getOCSPMode() {
        Boolean insecureMode = (Boolean)this.connectionPropertiesMap.get((Object)SFSessionProperty.INSECURE_MODE);
        OCSPMode ret = insecureMode != null && insecureMode != false ? OCSPMode.INSECURE : (!this.connectionPropertiesMap.containsKey((Object)SFSessionProperty.OCSP_FAIL_OPEN) || (Boolean)this.connectionPropertiesMap.get((Object)SFSessionProperty.OCSP_FAIL_OPEN) != false ? OCSPMode.FAIL_OPEN : OCSPMode.FAIL_CLOSED);
        return ret;
    }

    public Integer getQueryTimeout() {
        return (Integer)this.connectionPropertiesMap.get((Object)SFSessionProperty.QUERY_TIMEOUT);
    }

    public String getUser() {
        return (String)this.connectionPropertiesMap.get((Object)SFSessionProperty.USER);
    }

    public String getUrl() {
        return (String)this.connectionPropertiesMap.get((Object)SFSessionProperty.SERVER_URL);
    }

    public int getInjectWaitInPut() {
        Object retVal = this.connectionPropertiesMap.get((Object)SFSessionProperty.INJECT_WAIT_IN_PUT);
        if (retVal != null) {
            try {
                return (Integer)retVal;
            }
            catch (Exception e) {
                return 0;
            }
        }
        return 0;
    }

    public boolean getMetadataRequestUseSessionDatabase() {
        return this.metadataRequestUseSessionDatabase;
    }

    public void setMetadataRequestUseSessionDatabase(boolean enabled) {
        this.metadataRequestUseSessionDatabase = enabled;
    }

    public boolean getMetadataRequestUseConnectionCtx() {
        return this.metadataRequestUseConnectionCtx;
    }

    public void setMetadataRequestUseConnectionCtx(boolean enabled) {
        this.metadataRequestUseConnectionCtx = enabled;
    }

    AtomicInteger getInjectedDelay() {
        return this._injectedDelay;
    }

    public void setInjectedDelay(int injectedDelay) {
        this._injectedDelay.set(injectedDelay);
    }

    public boolean getTreatNTZAsUTC() {
        return this.treatNTZAsUTC;
    }

    public void setTreatNTZAsUTC(boolean treatNTZAsUTC) {
        this.treatNTZAsUTC = treatNTZAsUTC;
    }

    public boolean getEnableHeartbeat() {
        return this.enableHeartbeat;
    }

    public void setEnableHeartbeat(boolean enableHeartbeat) {
        this.enableHeartbeat = enableHeartbeat;
    }

    public void setHeartbeatFrequency(int frequency) {
        this.heartbeatFrequency = frequency < 900 ? 900 : (frequency > 3600 ? 3600 : frequency);
    }

    public int getHeartbeatFrequency() {
        return this.heartbeatFrequency;
    }

    public boolean getAutoCommit() {
        return this.autoCommit.get();
    }

    public void setAutoCommit(boolean autoCommit) {
        this.autoCommit.set(autoCommit);
    }

    public boolean getFormatDateWithTimezone() {
        return this.formatDateWithTimezone;
    }

    public void setFormatDateWithTimezone(boolean formatDateWithTimezone) {
        this.formatDateWithTimezone = formatDateWithTimezone;
    }

    public boolean getUseSessionTimezone() {
        return this.useSessionTimezone;
    }

    public void setUseSessionTimezone(boolean useSessionTimezone) {
        this.useSessionTimezone = useSessionTimezone;
    }

    public boolean getEnableCombineDescribe() {
        return this.enableCombineDescribe;
    }

    public void setEnableCombineDescribe(boolean enableCombineDescribe) {
        this.enableCombineDescribe = enableCombineDescribe;
    }

    public boolean isClientTelemetryEnabled() {
        return this.clientTelemetryEnabled;
    }

    public void setClientTelemetryEnabled(boolean clientTelemetryEnabled) {
        this.clientTelemetryEnabled = clientTelemetryEnabled;
    }

    public int getArrayBindStageThreshold() {
        return this.arrayBindStageThreshold;
    }

    public void setArrayBindStageThreshold(int arrayBindStageThreshold) {
        this.arrayBindStageThreshold = arrayBindStageThreshold;
    }

    public boolean getStoreTemporaryCredential() {
        return this.storeTemporaryCredential;
    }

    public void setStoreTemporaryCredential(boolean storeTemporaryCredential) {
        this.storeTemporaryCredential = storeTemporaryCredential;
    }

    public String getServiceName() {
        return this.serviceName;
    }

    public void setServiceName(String serviceName) {
        this.serviceName = serviceName;
    }

    public void setEnableConservativeMemoryUsage(boolean enableConservativeMemoryUsage) {
        this.enableConservativeMemoryUsage = enableConservativeMemoryUsage;
    }

    public boolean isConservativeMemoryUsageEnabled() {
        return this.enableConservativeMemoryUsage;
    }

    public int getConservativeMemoryAdjustStep() {
        return this.conservativeMemoryAdjustStep;
    }

    public void setConservativeMemoryAdjustStep(int conservativeMemoryAdjustStep) {
        this.conservativeMemoryAdjustStep = conservativeMemoryAdjustStep;
    }

    public int getClientMemoryLimit() {
        return this.clientMemoryLimit;
    }

    public void setClientMemoryLimit(int clientMemoryLimit) {
        this.clientMemoryLimit = clientMemoryLimit;
    }

    public int getQueryContextCacheSize() {
        return this.queryContextCacheSize;
    }

    public void setQueryContextCacheSize(int queryContextCacheSize) {
        this.queryContextCacheSize = queryContextCacheSize;
    }

    public boolean getJdbcEnablePutGet() {
        return this.jdbcEnablePutGet;
    }

    public void setJdbcEnablePutGet(boolean jdbcEnablePutGet) {
        this.jdbcEnablePutGet = jdbcEnablePutGet;
    }

    public boolean getEnablePutGet() {
        return this.enablePutGet;
    }

    public boolean setEnablePutGet(boolean enablePutGet) {
        this.enablePutGet = enablePutGet;
        return this.enablePutGet;
    }

    public boolean getEnablePatternSearch() {
        return this.enablePatternSearch;
    }

    public void setEnablePatternSearch(boolean enablePatternSearch) {
        this.enablePatternSearch = enablePatternSearch;
    }

    public int getClientResultChunkSize() {
        return this.clientResultChunkSize;
    }

    public void setClientResultChunkSize(int clientResultChunkSize) {
        this.clientResultChunkSize = clientResultChunkSize;
    }

    public Object getOtherParameter(String key) {
        return this.otherParameters.get(key);
    }

    public void setOtherParameter(String key, Object value) {
        this.otherParameters.put(key, value);
    }

    public int getClientPrefetchThreads() {
        return this.clientPrefetchThreads;
    }

    public void setClientPrefetchThreads(int clientPrefetchThreads) {
        this.clientPrefetchThreads = clientPrefetchThreads;
    }

    public boolean getValidateDefaultParameters() {
        return this.validateDefaultParameters;
    }

    public void setValidateDefaultParameters(boolean validateDefaultParameters) {
        this.validateDefaultParameters = validateDefaultParameters;
    }

    public String getDatabase() {
        return this.database;
    }

    public void setDatabase(String database) {
        if (!Strings.isNullOrEmpty(database)) {
            this.database = database;
        }
    }

    public String getSchema() {
        return this.schema;
    }

    public void setSchema(String schema) {
        if (!Strings.isNullOrEmpty(schema)) {
            this.schema = schema;
        }
    }

    public String getRole() {
        return this.role;
    }

    public void setRole(String role) {
        this.role = role;
    }

    public String getWarehouse() {
        return this.warehouse;
    }

    public void setWarehouse(String warehouse) {
        if (!Strings.isNullOrEmpty(warehouse)) {
            this.warehouse = warehouse;
        }
    }

    public void setUseRegionalS3EndpointsForPresignedURL(boolean regionalS3Endpoint) {
        this.useRegionalS3EndpointsForPresignedURL = regionalS3Endpoint;
    }

    public boolean getUseRegionalS3EndpointsForPresignedURL() {
        return this.useRegionalS3EndpointsForPresignedURL;
    }

    public String getArrayBindStage() {
        return this.arrayBindStage;
    }

    public void setArrayBindStage(String arrayBindStage) {
        this.arrayBindStage = String.format("%s.%s.%s", this.getDatabase(), this.getSchema(), arrayBindStage);
    }

    public void setSessionPropertyByKey(String propertyName, Object propertyValue) {
        this.customSessionProperties.put(propertyName, propertyValue);
    }

    public Object getSessionPropertyByKey(String propertyName) {
        return this.customSessionProperties.get(propertyName);
    }

    public abstract boolean isSafeToClose();

    @Deprecated
    public abstract QueryStatus getQueryStatus(String var1) throws SQLException;

    public abstract QueryStatusV2 getQueryStatusV2(String var1) throws SQLException;

    public abstract List<DriverPropertyInfo> checkProperties();

    public abstract void close() throws SFException, SnowflakeSQLException;

    public abstract Telemetry getTelemetryClient();

    public abstract void callHeartBeat(int var1) throws Exception, SFException;

    public List<SFException> getSqlWarnings() {
        return this.sqlWarnings;
    }

    public void clearSqlWarnings() {
        this.sqlWarnings.clear();
    }

    public SFConnectionHandler getSfConnectionHandler() {
        return this.sfConnectionHandler;
    }

    public abstract int getNetworkTimeoutInMilli();

    public abstract int getAuthTimeout();

    public abstract int getMaxHttpRetries();

    public abstract SnowflakeConnectString getSnowflakeConnectionString();

    public abstract boolean isAsyncSession();

    public abstract QueryContextDTO getQueryContextDTO();

    public abstract void setQueryContext(String var1);

    public boolean getEnableReturnTimestampWithTimeZone() {
        return this.enableReturnTimestampWithTimeZone;
    }
}

