/*
 * Decompiled with CFR 0.152.
 */
package net.snowflake.client.core.json;

import java.nio.ByteBuffer;
import net.snowflake.client.core.SFException;
import net.snowflake.client.core.json.Converters;
import net.snowflake.client.jdbc.ErrorCode;
import net.snowflake.client.jdbc.internal.snowflake.common.core.SFBinary;

public class BytesConverter {
    private final Converters converters;

    BytesConverter(Converters converters) {
        this.converters = converters;
    }

    public byte[] getBytes(Object obj, int columnType, int columnSubType, Integer scale) throws SFException {
        if (obj == null) {
            return null;
        }
        try {
            switch (columnType) {
                case 6: 
                case 8: {
                    return ByteBuffer.allocate(8).putDouble(0, this.converters.getNumberConverter().getDouble(obj, columnType)).array();
                }
                case -6: 
                case -5: 
                case 2: 
                case 4: 
                case 5: {
                    return this.converters.getNumberConverter().getBigDecimal(obj, columnType, scale).toBigInteger().toByteArray();
                }
                case 1: 
                case 12: {
                    return this.converters.getStringConverter().getString(obj, columnType, columnSubType, scale).getBytes();
                }
                case 16: {
                    byte[] byArray;
                    if (this.converters.getBooleanConverter().getBoolean(obj, columnType).booleanValue()) {
                        byte[] byArray2 = new byte[1];
                        byArray = byArray2;
                        byArray2[0] = 1;
                    } else {
                        byte[] byArray3 = new byte[1];
                        byArray = byArray3;
                        byArray3[0] = 0;
                    }
                    return byArray;
                }
                case 3: 
                case 91: 
                case 92: 
                case 93: {
                    throw new SFException(ErrorCode.INVALID_VALUE_CONVERT, columnType, "byte array", obj);
                }
            }
            return SFBinary.fromHex(obj.toString()).getBytes();
        }
        catch (IllegalArgumentException ex) {
            throw new SFException(ErrorCode.INVALID_VALUE_CONVERT, columnType, "byte array", obj);
        }
    }
}

