/*
 * Decompiled with CFR 0.152.
 */
package net.snowflake.client.jdbc.internal.grpc.alts;

import javax.net.ssl.SSLException;
import net.snowflake.client.jdbc.internal.google.auth.oauth2.ComputeEngineCredentials;
import net.snowflake.client.jdbc.internal.google.common.collect.ImmutableList;
import net.snowflake.client.jdbc.internal.grpc.CallCredentials;
import net.snowflake.client.jdbc.internal.grpc.ChannelCredentials;
import net.snowflake.client.jdbc.internal.grpc.CompositeChannelCredentials;
import net.snowflake.client.jdbc.internal.grpc.Status;
import net.snowflake.client.jdbc.internal.grpc.alts.FailingCallCredentials;
import net.snowflake.client.jdbc.internal.grpc.alts.HandshakerServiceChannel;
import net.snowflake.client.jdbc.internal.grpc.alts.InternalCheckGcpEnvironment;
import net.snowflake.client.jdbc.internal.grpc.alts.internal.AltsProtocolNegotiator;
import net.snowflake.client.jdbc.internal.grpc.auth.MoreCallCredentials;
import net.snowflake.client.jdbc.internal.grpc.internal.SharedResourcePool;
import net.snowflake.client.jdbc.internal.grpc.netty.shaded.io.grpc.netty.GrpcSslContexts;
import net.snowflake.client.jdbc.internal.grpc.netty.shaded.io.grpc.netty.InternalNettyChannelCredentials;
import net.snowflake.client.jdbc.internal.grpc.netty.shaded.io.grpc.netty.InternalProtocolNegotiator;
import net.snowflake.client.jdbc.internal.grpc.netty.shaded.io.netty.handler.ssl.SslContext;

public final class ComputeEngineChannelCredentials {
    private ComputeEngineChannelCredentials() {
    }

    public static ChannelCredentials create() {
        ChannelCredentials nettyCredentials = InternalNettyChannelCredentials.create(ComputeEngineChannelCredentials.createClientFactory());
        CallCredentials callCredentials = InternalCheckGcpEnvironment.isOnGcp() ? MoreCallCredentials.from(ComputeEngineCredentials.create()) : new FailingCallCredentials(Status.INTERNAL.withDescription("Compute Engine Credentials can only be used on Google Cloud Platform"));
        return CompositeChannelCredentials.create(nettyCredentials, callCredentials);
    }

    private static InternalProtocolNegotiator.ClientFactory createClientFactory() {
        SslContext sslContext;
        try {
            sslContext = GrpcSslContexts.forClient().build();
        }
        catch (SSLException e) {
            throw new RuntimeException(e);
        }
        return new AltsProtocolNegotiator.GoogleDefaultProtocolNegotiatorFactory(ImmutableList.of(), SharedResourcePool.forResource(HandshakerServiceChannel.SHARED_HANDSHAKER_CHANNEL), sslContext);
    }
}

