/*
 * Decompiled with CFR 0.152.
 */
package net.snowflake.client.jdbc.internal.google.cloud.storage;

import java.net.URL;
import java.util.Map;
import java.util.function.Function;
import java.util.function.Supplier;
import net.snowflake.client.jdbc.internal.google.api.gax.retrying.ResultRetryAlgorithm;
import net.snowflake.client.jdbc.internal.google.api.services.storage.model.StorageObject;
import net.snowflake.client.jdbc.internal.google.cloud.storage.BlobInfo;
import net.snowflake.client.jdbc.internal.google.cloud.storage.Conversions;
import net.snowflake.client.jdbc.internal.google.cloud.storage.GapicDownloadSessionBuilder;
import net.snowflake.client.jdbc.internal.google.cloud.storage.GapicUploadSessionBuilder;
import net.snowflake.client.jdbc.internal.google.cloud.storage.HttpDownloadSessionBuilder;
import net.snowflake.client.jdbc.internal.google.cloud.storage.HttpStorageOptions;
import net.snowflake.client.jdbc.internal.google.cloud.storage.Retrying;
import net.snowflake.client.jdbc.internal.google.cloud.storage.StorageException;
import net.snowflake.client.jdbc.internal.google.cloud.storage.spi.v1.StorageRpc;

final class ResumableMedia {
    ResumableMedia() {
    }

    static Supplier<String> startUploadForBlobInfo(HttpStorageOptions storageOptions, BlobInfo blob, Map<StorageRpc.Option, ?> optionsMap, ResultRetryAlgorithm<?> algorithm) {
        return () -> (String)Retrying.run(storageOptions, algorithm, () -> storageOptions.getStorageRpcV1().open((StorageObject)Conversions.apiary().blobInfo().encode(blob), optionsMap), Function.identity());
    }

    static Supplier<String> startUploadForSignedUrl(HttpStorageOptions storageOptions, URL signedURL, ResultRetryAlgorithm<?> algorithm) {
        if (!ResumableMedia.isValidSignedURL(signedURL.getQuery())) {
            throw new StorageException(2, "invalid signedURL");
        }
        return () -> (String)Retrying.run(storageOptions, algorithm, () -> storageOptions.getStorageRpcV1().open(signedURL.toString()), Function.identity());
    }

    static GapicMediaSession gapic() {
        return GapicMediaSession.INSTANCE;
    }

    static HttpMediaSession http() {
        return HttpMediaSession.INSTANCE;
    }

    private static boolean isValidSignedURL(String signedURLQuery) {
        boolean isValid = true;
        if (signedURLQuery.startsWith("X-Goog-Algorithm=")) {
            if (!(signedURLQuery.contains("&X-Goog-Credential=") && signedURLQuery.contains("&X-Goog-Date=") && signedURLQuery.contains("&X-Goog-Expires=") && signedURLQuery.contains("&X-Goog-SignedHeaders=") && signedURLQuery.contains("&X-Goog-Signature="))) {
                isValid = false;
            }
        } else if (signedURLQuery.startsWith("GoogleAccessId=")) {
            if (!signedURLQuery.contains("&Expires=") || !signedURLQuery.contains("&Signature=")) {
                isValid = false;
            }
        } else {
            isValid = false;
        }
        return isValid;
    }

    static final class HttpMediaSession {
        private static final HttpMediaSession INSTANCE = new HttpMediaSession();

        private HttpMediaSession() {
        }

        HttpDownloadSessionBuilder read() {
            return HttpDownloadSessionBuilder.create();
        }
    }

    static final class GapicMediaSession {
        private static final GapicMediaSession INSTANCE = new GapicMediaSession();

        private GapicMediaSession() {
        }

        GapicUploadSessionBuilder write() {
            return GapicUploadSessionBuilder.create();
        }

        GapicDownloadSessionBuilder read() {
            return GapicDownloadSessionBuilder.create();
        }
    }
}

