/*
 * Decompiled with CFR 0.152.
 */
package net.snowflake.client.jdbc.cloud.storage;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.SocketTimeoutException;
import java.nio.channels.FileChannel;
import java.nio.file.Files;
import java.nio.file.Paths;
import java.nio.file.StandardOpenOption;
import java.security.InvalidAlgorithmParameterException;
import java.security.InvalidKeyException;
import java.security.Key;
import java.security.NoSuchAlgorithmException;
import java.security.NoSuchProviderException;
import java.security.SecureRandom;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import javax.crypto.BadPaddingException;
import javax.crypto.Cipher;
import javax.crypto.CipherInputStream;
import javax.crypto.IllegalBlockSizeException;
import javax.crypto.NoSuchPaddingException;
import javax.crypto.spec.IvParameterSpec;
import javax.crypto.spec.SecretKeySpec;
import net.snowflake.client.core.SFSession;
import net.snowflake.client.jdbc.ErrorCode;
import net.snowflake.client.jdbc.FileBackedOutputStream;
import net.snowflake.client.jdbc.MatDesc;
import net.snowflake.client.jdbc.SnowflakeFileTransferAgent;
import net.snowflake.client.jdbc.SnowflakeSQLException;
import net.snowflake.client.jdbc.SnowflakeUtil;
import net.snowflake.client.jdbc.cloud.storage.S3ObjectMetadata;
import net.snowflake.client.jdbc.cloud.storage.SnowflakeStorageClient;
import net.snowflake.client.jdbc.cloud.storage.StorageObjectMetadata;
import net.snowflake.client.jdbc.cloud.storage.StorageObjectSummaryCollection;
import net.snowflake.client.jdbc.cloud.storage.StorageProviderException;
import net.snowflake.client.jdbc.internal.amazonaws.AmazonClientException;
import net.snowflake.client.jdbc.internal.amazonaws.AmazonServiceException;
import net.snowflake.client.jdbc.internal.amazonaws.ClientConfiguration;
import net.snowflake.client.jdbc.internal.amazonaws.auth.AWSCredentials;
import net.snowflake.client.jdbc.internal.amazonaws.auth.BasicAWSCredentials;
import net.snowflake.client.jdbc.internal.amazonaws.auth.BasicSessionCredentials;
import net.snowflake.client.jdbc.internal.amazonaws.regions.Region;
import net.snowflake.client.jdbc.internal.amazonaws.regions.RegionUtils;
import net.snowflake.client.jdbc.internal.amazonaws.services.s3.AmazonS3Client;
import net.snowflake.client.jdbc.internal.amazonaws.services.s3.AmazonS3EncryptionClient;
import net.snowflake.client.jdbc.internal.amazonaws.services.s3.model.AmazonS3Exception;
import net.snowflake.client.jdbc.internal.amazonaws.services.s3.model.CryptoConfiguration;
import net.snowflake.client.jdbc.internal.amazonaws.services.s3.model.CryptoMode;
import net.snowflake.client.jdbc.internal.amazonaws.services.s3.model.EncryptionMaterials;
import net.snowflake.client.jdbc.internal.amazonaws.services.s3.model.EncryptionMaterialsProvider;
import net.snowflake.client.jdbc.internal.amazonaws.services.s3.model.ObjectListing;
import net.snowflake.client.jdbc.internal.amazonaws.services.s3.model.ObjectMetadata;
import net.snowflake.client.jdbc.internal.amazonaws.services.s3.model.PutObjectRequest;
import net.snowflake.client.jdbc.internal.amazonaws.services.s3.model.StaticEncryptionMaterialsProvider;
import net.snowflake.client.jdbc.internal.amazonaws.services.s3.transfer.Download;
import net.snowflake.client.jdbc.internal.amazonaws.services.s3.transfer.TransferManager;
import net.snowflake.client.jdbc.internal.amazonaws.services.s3.transfer.Upload;
import net.snowflake.client.jdbc.internal.amazonaws.util.Base64;
import net.snowflake.client.jdbc.internal.apache.commons.io.IOUtils;
import net.snowflake.client.jdbc.internal.apache.commons.lang3.tuple.ImmutablePair;
import net.snowflake.client.jdbc.internal.apache.commons.lang3.tuple.Pair;
import net.snowflake.client.jdbc.internal.snowflake.common.core.RemoteStoreFileEncryptionMaterial;
import net.snowflake.client.log.SFLogger;
import net.snowflake.client.log.SFLoggerFactory;

public class SnowflakeS3Client
implements SnowflakeStorageClient {
    private static final SFLogger logger = SFLoggerFactory.getLogger(SnowflakeS3Client.class);
    private static final String localFileSep = System.getProperty("file.separator");
    private static final String AES = "AES";
    private static final String AMZ_MATDESC = "x-amz-matdesc";
    private static final String AMZ_KEY = "x-amz-key";
    private static final String AMZ_IV = "x-amz-iv";
    private static final String FILE_CIPHER = "AES/CBC/PKCS5Padding";
    private static final String KEY_CIPHER = "AES/ECB/PKCS5Padding";
    private static final int BUFFER_SIZE = 0x200000;
    private static final String EXPIRED_AWS_TOKEN_ERROR_CODE = "ExpiredToken";
    private static SecureRandom secRnd;
    private int encryptionKeySize = 0;
    private AmazonS3Client amazonClient = null;
    private RemoteStoreFileEncryptionMaterial encMat = null;
    private ClientConfiguration clientConfig = null;
    private String stageRegion = null;

    @Override
    public int getMaxRetries() {
        return 25;
    }

    @Override
    public int getRetryBackoffMaxExponent() {
        return 4;
    }

    @Override
    public int getRetryBackoffMin() {
        return 1000;
    }

    public SnowflakeS3Client(Map stageCredentials, ClientConfiguration clientConfig, RemoteStoreFileEncryptionMaterial encMat, String stageRegion) throws SnowflakeSQLException {
        this.setupSnowflakeS3Client(stageCredentials, clientConfig, encMat, stageRegion);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void setupSnowflakeS3Client(Map stageCredentials, ClientConfiguration clientConfig, RemoteStoreFileEncryptionMaterial encMat, String stageRegion) throws SnowflakeSQLException {
        Region region;
        this.clientConfig = clientConfig;
        this.stageRegion = stageRegion;
        this.encMat = encMat;
        logger.debug("Setting up AWS client ");
        String awsID = (String)stageCredentials.get("AWS_ID");
        String awsKey = (String)stageCredentials.get("AWS_KEY");
        String awsToken = (String)stageCredentials.get("AWS_TOKEN");
        AWSCredentials aWSCredentials = awsToken != null ? new BasicSessionCredentials(awsID, awsKey, awsToken) : new BasicAWSCredentials(awsID, awsKey);
        clientConfig.withSignerOverride("AWSS3V4SignerType");
        if (encMat != null) {
            byte[] decodedKey = Base64.decode(encMat.getQueryStageMasterKey());
            this.encryptionKeySize = decodedKey.length * 8;
            if (this.encryptionKeySize == 256) {
                SecretKeySpec queryStageMasterKey = new SecretKeySpec(decodedKey, 0, decodedKey.length, AES);
                EncryptionMaterials encryptionMaterials = new EncryptionMaterials(queryStageMasterKey);
                encryptionMaterials.addDescription("queryId", encMat.getQueryId());
                encryptionMaterials.addDescription("smkId", Long.toString(encMat.getSmkId()));
                CryptoConfiguration cryptoConfig = new CryptoConfiguration(CryptoMode.EncryptionOnly);
                this.amazonClient = new AmazonS3EncryptionClient(aWSCredentials, (EncryptionMaterialsProvider)new StaticEncryptionMaterialsProvider(encryptionMaterials), clientConfig, cryptoConfig);
            } else {
                if (this.encryptionKeySize != 128) throw new SnowflakeSQLException("XX000", ErrorCode.INTERNAL_ERROR.getMessageCode(), "unsupported key size", this.encryptionKeySize);
                this.amazonClient = new AmazonS3Client(aWSCredentials, clientConfig);
            }
        } else {
            this.amazonClient = new AmazonS3Client(aWSCredentials, clientConfig);
        }
        if (stageRegion == null || (region = RegionUtils.getRegion(stageRegion)) == null) return;
        this.amazonClient.setRegion(region);
    }

    private static synchronized SecureRandom getSecRnd() throws NoSuchAlgorithmException, NoSuchProviderException {
        if (secRnd == null) {
            secRnd = SecureRandom.getInstance("SHA1PRNG", "SUN");
            byte[] bytes = new byte[10];
            secRnd.nextBytes(bytes);
        }
        return secRnd;
    }

    @Override
    public boolean isEncrypting() {
        return this.encryptionKeySize > 0;
    }

    @Override
    public int getEncryptionKeySize() {
        return this.encryptionKeySize;
    }

    @Override
    public void renew(Map stageCredentials) throws SnowflakeSQLException {
        this.setupSnowflakeS3Client(stageCredentials, this.clientConfig, this.encMat, this.stageRegion);
    }

    @Override
    public void shutdown() {
        this.amazonClient.shutdown();
    }

    @Override
    public StorageObjectSummaryCollection listObjects(String remoteStorageLocation, String prefix) throws StorageProviderException {
        ObjectListing objListing = this.amazonClient.listObjects(remoteStorageLocation, prefix);
        return new StorageObjectSummaryCollection(objListing.getObjectSummaries());
    }

    @Override
    public StorageObjectMetadata getObjectMetadata(String remoteStorageLocation, String prefix) throws StorageProviderException {
        return new S3ObjectMetadata(this.amazonClient.getObjectMetadata(remoteStorageLocation, prefix));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void download(SFSession connection, String command, String localLocation, String destFileName, int parallelism, String remoteStorageLocation, String stageFilePath, String stageRegion) throws SnowflakeSQLException {
        TransferManager tx = null;
        int retryCount = 0;
        do {
            try {
                File localFile = new File(localLocation + localFileSep + destFileName);
                logger.debug("Creating executor service for transfermanager with {} threads", parallelism);
                tx = new TransferManager(this.amazonClient, SnowflakeUtil.createDefaultExecutorService("s3-transfer-manager-downloader-", parallelism));
                Download myDownload = tx.download(remoteStorageLocation, stageFilePath, localFile);
                ObjectMetadata meta = this.amazonClient.getObjectMetadata(remoteStorageLocation, stageFilePath);
                Map<String, String> metaMap = meta.getUserMetadata();
                String key = metaMap.get(AMZ_KEY);
                String iv = metaMap.get(AMZ_IV);
                myDownload.waitForCompletion();
                if (this.isEncrypting() && this.getEncryptionKeySize() < 256) {
                    if (key == null || iv == null) {
                        throw new SnowflakeSQLException("XX000", ErrorCode.INTERNAL_ERROR.getMessageCode(), "File metadata incomplete");
                    }
                    try {
                        this.decrypt(localFile, key, iv);
                    }
                    catch (Exception ex) {
                        logger.error("Error decrypting file", ex);
                        throw ex;
                    }
                }
                return;
            }
            catch (Exception ex) {
                SnowflakeS3Client.handleS3Exception(ex, ++retryCount, "download", connection, command, this);
            }
            finally {
                if (tx != null) {
                    tx.shutdownNow(false);
                }
            }
        } while (retryCount <= this.getMaxRetries());
        throw new SnowflakeSQLException("XX000", ErrorCode.INTERNAL_ERROR.getMessageCode(), "Unexpected: download unsuccessful without exception!");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void upload(SFSession connection, String command, int parallelism, boolean uploadFromStream, String remoteStorageLocation, File srcFile, String destFileName, InputStream inputStream, FileBackedOutputStream fileBackedOutputStream, StorageObjectMetadata meta, String stageRegion) throws SnowflakeSQLException {
        long originalContentLength = meta.getContentLength();
        ArrayList<FileInputStream> toClose = new ArrayList<FileInputStream>();
        Pair<InputStream, Boolean> uploadStreamInfo = this.createUploadStream(srcFile, uploadFromStream, inputStream, fileBackedOutputStream, ((S3ObjectMetadata)meta).getS3ObjectMetadata(), originalContentLength, toClose);
        if (!(meta instanceof S3ObjectMetadata)) {
            throw new IllegalArgumentException("Unexpected metadata object type");
        }
        ObjectMetadata s3Meta = ((S3ObjectMetadata)meta).getS3ObjectMetadata();
        TransferManager tx = null;
        int retryCount = 0;
        do {
            try {
                Upload myUpload;
                logger.debug("Creating executor service for transfermanager with {} threads", parallelism);
                tx = new TransferManager(this.amazonClient, SnowflakeUtil.createDefaultExecutorService("s3-transfer-manager-uploader-", parallelism));
                if (uploadStreamInfo.getRight().booleanValue()) {
                    myUpload = tx.upload(remoteStorageLocation, destFileName, uploadStreamInfo.getLeft(), s3Meta);
                } else {
                    PutObjectRequest putRequest = new PutObjectRequest(remoteStorageLocation, destFileName, srcFile);
                    putRequest.setMetadata(s3Meta);
                    myUpload = tx.upload(putRequest);
                }
                myUpload.waitForCompletion();
                for (FileInputStream is : toClose) {
                    IOUtils.closeQuietly(is);
                }
                return;
            }
            catch (Exception ex) {
                SnowflakeS3Client.handleS3Exception(ex, ++retryCount, "upload", connection, command, this);
                if (uploadFromStream && fileBackedOutputStream == null) {
                    throw new SnowflakeSQLException(ex, "58000", (int)ErrorCode.IO_ERROR.getMessageCode(), "Encountered exception during upload: " + ex.getMessage() + "\nCannot retry upload from stream.");
                }
                uploadStreamInfo = this.createUploadStream(srcFile, uploadFromStream, inputStream, fileBackedOutputStream, s3Meta, originalContentLength, toClose);
            }
            finally {
                if (tx != null) {
                    tx.shutdownNow(false);
                }
            }
        } while (retryCount <= this.getMaxRetries());
        for (FileInputStream is : toClose) {
            IOUtils.closeQuietly(is);
        }
        throw new SnowflakeSQLException("XX000", ErrorCode.INTERNAL_ERROR.getMessageCode(), "Unexpected: upload unsuccessful without exception!");
    }

    private void decrypt(File file, String keyBase64, String ivBase64) throws NoSuchAlgorithmException, NoSuchPaddingException, InvalidKeyException, IllegalBlockSizeException, BadPaddingException, InvalidAlgorithmParameterException, IOException {
        byte[] keyBytes = Base64.decode(keyBase64);
        byte[] ivBytes = Base64.decode(ivBase64);
        byte[] qsmkBytes = Base64.decode(this.encMat.getQueryStageMasterKey());
        Cipher keyCipher = Cipher.getInstance(KEY_CIPHER);
        SecretKeySpec queryStageMasterKey = new SecretKeySpec(qsmkBytes, 0, qsmkBytes.length, AES);
        keyCipher.init(2, queryStageMasterKey);
        byte[] fileKeyBytes = keyCipher.doFinal(keyBytes);
        SecretKeySpec fileKey = new SecretKeySpec(fileKeyBytes, 0, qsmkBytes.length, AES);
        Cipher fileCipher = Cipher.getInstance(FILE_CIPHER);
        IvParameterSpec iv = new IvParameterSpec(ivBytes);
        byte[] buffer = new byte[0x200000];
        fileCipher.init(2, (Key)fileKey, iv);
        long totalBytesRead = 0L;
        try (InputStream is = Files.newInputStream(file.toPath(), StandardOpenOption.READ);
             CipherInputStream cis = new CipherInputStream(is, fileCipher);
             OutputStream os = Files.newOutputStream(file.toPath(), StandardOpenOption.CREATE);){
            int bytesRead;
            while ((bytesRead = ((InputStream)cis).read(buffer)) > -1) {
                os.write(buffer, 0, bytesRead);
                totalBytesRead += (long)bytesRead;
            }
        }
        var14_13 = null;
        try (FileChannel fc = new FileOutputStream(file, true).getChannel();){
            fc.truncate(totalBytesRead);
        }
        catch (Throwable throwable) {
            var14_13 = throwable;
            throw throwable;
        }
    }

    private CipherInputStream encrypt(ObjectMetadata meta, long originalContentLength, InputStream src) throws InvalidKeyException, InvalidAlgorithmParameterException, NoSuchAlgorithmException, NoSuchProviderException, NoSuchPaddingException, FileNotFoundException, IllegalBlockSizeException, BadPaddingException {
        byte[] decodedKey = Base64.decode(this.encMat.getQueryStageMasterKey());
        int keySize = decodedKey.length;
        byte[] fileKeyBytes = new byte[keySize];
        Cipher fileCipher = Cipher.getInstance(FILE_CIPHER);
        int blockSz = fileCipher.getBlockSize();
        byte[] ivData = new byte[blockSz];
        SnowflakeS3Client.getSecRnd().nextBytes(ivData);
        IvParameterSpec iv = new IvParameterSpec(ivData);
        SnowflakeS3Client.getSecRnd().nextBytes(fileKeyBytes);
        SecretKeySpec fileKey = new SecretKeySpec(fileKeyBytes, 0, keySize, AES);
        fileCipher.init(1, (Key)fileKey, iv);
        CipherInputStream cis = new CipherInputStream(src, fileCipher);
        Cipher keyCipher = Cipher.getInstance(KEY_CIPHER);
        SecretKeySpec queryStageMasterKey = new SecretKeySpec(decodedKey, 0, keySize, AES);
        keyCipher.init(1, queryStageMasterKey);
        byte[] encKeK = keyCipher.doFinal(fileKeyBytes);
        MatDesc matDesc = new MatDesc(this.encMat.getSmkId(), this.encMat.getQueryId(), keySize * 8);
        meta.addUserMetadata(AMZ_MATDESC, matDesc.toString());
        meta.addUserMetadata(AMZ_KEY, Base64.encodeAsString(encKeK));
        meta.addUserMetadata(AMZ_IV, Base64.encodeAsString(ivData));
        meta.setContentLength((originalContentLength + (long)blockSz) / (long)blockSz * (long)blockSz);
        return cis;
    }

    private Pair<InputStream, Boolean> createUploadStream(File srcFile, boolean uploadFromStream, InputStream inputStream, FileBackedOutputStream fileBackedOutputStream, ObjectMetadata meta, long originalContentLength, List<FileInputStream> toClose) throws SnowflakeSQLException {
        InputStream result;
        logger.debug("createUploadStream({}, {}, {}, {}, {}, {}, {}) keySize={}", this, srcFile, uploadFromStream, inputStream, fileBackedOutputStream, meta, toClose, this.getEncryptionKeySize());
        FileInputStream srcFileStream = null;
        if (this.isEncrypting() && this.getEncryptionKeySize() < 256) {
            try {
                InputStream inputStream2;
                if (uploadFromStream) {
                    inputStream2 = fileBackedOutputStream != null ? fileBackedOutputStream.asByteSource().openStream() : inputStream;
                } else {
                    srcFileStream = new FileInputStream(srcFile);
                    inputStream2 = srcFileStream;
                }
                InputStream uploadStream = inputStream2;
                toClose.add(srcFileStream);
                result = this.encrypt(meta, originalContentLength, uploadStream);
                uploadFromStream = true;
            }
            catch (Exception ex) {
                logger.error("Failed to encrypt input", ex);
                throw new SnowflakeSQLException(ex, "XX000", (int)ErrorCode.INTERNAL_ERROR.getMessageCode(), "Failed to encrypt input", ex.getMessage());
            }
        }
        try {
            InputStream inputStream3;
            if (uploadFromStream) {
                inputStream3 = fileBackedOutputStream != null ? fileBackedOutputStream.asByteSource().openStream() : inputStream;
            } else {
                srcFileStream = new FileInputStream(srcFile);
                inputStream3 = srcFileStream;
            }
            result = inputStream3;
            toClose.add(srcFileStream);
        }
        catch (FileNotFoundException ex) {
            logger.error("Failed to open input file", ex);
            throw new SnowflakeSQLException(ex, "XX000", (int)ErrorCode.INTERNAL_ERROR.getMessageCode(), "Failed to open input file", ex.getMessage());
        }
        catch (IOException ex) {
            logger.error("Failed to open input stream", ex);
            throw new SnowflakeSQLException(ex, "XX000", (int)ErrorCode.INTERNAL_ERROR.getMessageCode(), "Failed to open input stream", ex.getMessage());
        }
        return new ImmutablePair<InputStream, Boolean>(result, uploadFromStream);
    }

    @Override
    public void handleStorageException(Exception ex, int retryCount, String operation, SFSession connection, String command) throws SnowflakeSQLException {
        SnowflakeS3Client.handleS3Exception(ex, retryCount, operation, connection, command, this);
    }

    public static void handleS3Exception(Exception ex, int retryCount, String operation, SFSession connection, String command, SnowflakeS3Client s3Client) throws SnowflakeSQLException {
        if (ex.getCause() instanceof InvalidKeyException) {
            String msg = "Strong encryption with Java JRE requires JCE Unlimited Strength Jurisdiction Policy files. Follow JDBC client installation instructions provided by Snowflake or contact Snowflake Support.";
            logger.error("JCE Unlimited Strength policy files missing: {}. {}.", ex.getMessage(), ex.getCause().getMessage());
            String bootLib = System.getProperty("sun.boot.library.path");
            if (bootLib != null) {
                msg = msg + " The target directory on your system is: " + Paths.get(bootLib, "security").toString();
                logger.error(msg);
            }
            throw new SnowflakeSQLException(ex, "58000", (int)ErrorCode.AWS_CLIENT_ERROR.getMessageCode(), operation, msg);
        }
        if (ex instanceof AmazonClientException) {
            AmazonS3Exception s3ex;
            if (retryCount > s3Client.getMaxRetries()) {
                AmazonServiceException ex1;
                String extendedRequestId = "none";
                if (ex instanceof AmazonS3Exception) {
                    ex1 = (AmazonS3Exception)ex;
                    extendedRequestId = ((AmazonS3Exception)ex1).getExtendedRequestId();
                }
                if (ex instanceof AmazonServiceException) {
                    ex1 = (AmazonServiceException)ex;
                    throw new SnowflakeSQLException(ex1, "58000", (int)ErrorCode.S3_OPERATION_ERROR.getMessageCode(), operation, ex1.getErrorType().toString(), ex1.getErrorCode(), ex1.getMessage(), ex1.getRequestId(), extendedRequestId);
                }
                throw new SnowflakeSQLException(ex, "58000", (int)ErrorCode.AWS_CLIENT_ERROR.getMessageCode(), operation, ex.getMessage());
            }
            logger.debug("Encountered exception ({}) during {}, retry count: {}", ex.getMessage(), operation, retryCount);
            logger.debug("Stack trace: ", ex);
            int backoffInMillis = s3Client.getRetryBackoffMin();
            if (retryCount > 1) {
                backoffInMillis <<= Math.min(retryCount - 1, s3Client.getRetryBackoffMaxExponent());
            }
            try {
                logger.debug("Sleep for {} milliseconds before retry", backoffInMillis);
                Thread.sleep(backoffInMillis);
            }
            catch (InterruptedException ex1) {
                // empty catch block
            }
            if (ex instanceof AmazonS3Exception && (s3ex = (AmazonS3Exception)ex).getErrorCode().equalsIgnoreCase(EXPIRED_AWS_TOKEN_ERROR_CODE)) {
                SnowflakeFileTransferAgent.renewExpiredToken(connection, command, s3Client);
            }
        } else if (ex instanceof InterruptedException || SnowflakeUtil.getRootCause(ex) instanceof SocketTimeoutException) {
            if (retryCount > s3Client.getMaxRetries()) {
                throw new SnowflakeSQLException(ex, "58000", (int)ErrorCode.IO_ERROR.getMessageCode(), "Encountered exception during " + operation + ": " + ex.getMessage());
            }
            logger.debug("Encountered exception ({}) during {}, retry count: {}", ex.getMessage(), operation, retryCount);
        } else {
            throw new SnowflakeSQLException(ex, "58000", (int)ErrorCode.IO_ERROR.getMessageCode(), "Encountered exception during " + operation + ": " + ex.getMessage());
        }
    }
}

