/*
 * Decompiled with CFR 0.152.
 */
package net.snowflake.client.jdbc.cloud.storage;

import java.util.Map;
import net.snowflake.client.jdbc.SnowflakeSQLException;
import net.snowflake.client.jdbc.cloud.storage.S3ObjectMetadata;
import net.snowflake.client.jdbc.cloud.storage.SnowflakeS3Client;
import net.snowflake.client.jdbc.cloud.storage.SnowflakeStorageClient;
import net.snowflake.client.jdbc.cloud.storage.StorageObjectMetadata;
import net.snowflake.client.jdbc.internal.amazonaws.ClientConfiguration;
import net.snowflake.client.jdbc.internal.snowflake.common.core.RemoteStoreFileEncryptionMaterial;
import net.snowflake.client.log.SFLogger;
import net.snowflake.client.log.SFLoggerFactory;

public class StorageClientFactory {
    private static final SFLogger logger = SFLoggerFactory.getLogger(SnowflakeS3Client.class);
    private static StorageClientFactory factory;

    private StorageClientFactory() {
    }

    public static StorageClientFactory getFactory() {
        if (factory == null) {
            factory = new StorageClientFactory();
        }
        return factory;
    }

    public SnowflakeStorageClient createClient(String stageLocationType, Map stageCredentials, int parallel, RemoteStoreFileEncryptionMaterial encMat, String stageRegion) throws SnowflakeSQLException {
        logger.debug("createClient client type={}", stageLocationType);
        if ("S3".equalsIgnoreCase(stageLocationType)) {
            return this.createS3Client(stageCredentials, parallel, encMat, stageRegion);
        }
        throw new IllegalArgumentException("Unsupported storage client specified");
    }

    private SnowflakeS3Client createS3Client(Map stageCredentials, int parallel, RemoteStoreFileEncryptionMaterial encMat, String stageRegion) throws SnowflakeSQLException {
        SnowflakeS3Client s3Client;
        int S3_TRANSFER_MAX_RETRIES = 3;
        logger.debug("createS3Client encryption={}", encMat == null ? "no" : "yes");
        ClientConfiguration clientConfig = new ClientConfiguration();
        clientConfig.setMaxConnections(parallel + 1);
        clientConfig.setMaxErrorRetry(3);
        logger.debug("s3 client configuration: maxConnection={}, connectionTimeout={}, socketTimeout={}, maxErrorRetry={}", clientConfig.getMaxConnections(), clientConfig.getConnectionTimeout(), clientConfig.getSocketTimeout(), clientConfig.getMaxErrorRetry());
        try {
            s3Client = new SnowflakeS3Client(stageCredentials, clientConfig, encMat, stageRegion);
        }
        catch (Throwable ex) {
            logger.debug("Exception creating s3 client", ex);
            throw ex;
        }
        logger.debug("s3 client created");
        return s3Client;
    }

    public StorageObjectMetadata createStorageMetadataObj(String stageLocationType) {
        if ("S3".equalsIgnoreCase(stageLocationType)) {
            return new S3ObjectMetadata();
        }
        throw new IllegalArgumentException("Unsupported stage type specified");
    }
}

