/*
 * Decompiled with CFR 0.152.
 */
package net.snowflake.client.jdbc.internal.grpc.xds;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import net.snowflake.client.jdbc.internal.google.common.annotations.VisibleForTesting;
import net.snowflake.client.jdbc.internal.google.common.base.Preconditions;
import net.snowflake.client.jdbc.internal.google.common.collect.ImmutableMap;
import net.snowflake.client.jdbc.internal.grpc.InternalServiceProviders;
import net.snowflake.client.jdbc.internal.grpc.xds.XdsCredentialsProvider;
import net.snowflake.client.jdbc.internal.javax.annotation.Nullable;
import net.snowflake.client.jdbc.internal.javax.annotation.concurrent.GuardedBy;
import net.snowflake.client.jdbc.internal.javax.annotation.concurrent.ThreadSafe;

@ThreadSafe
final class XdsCredentialsRegistry {
    private static final Logger logger = Logger.getLogger(XdsCredentialsRegistry.class.getName());
    private static XdsCredentialsRegistry instance;
    @GuardedBy(value="this")
    private final LinkedHashSet<XdsCredentialsProvider> allProviders = new LinkedHashSet();
    @GuardedBy(value="this")
    private ImmutableMap<String, XdsCredentialsProvider> effectiveProviders = ImmutableMap.of();

    XdsCredentialsRegistry() {
    }

    public synchronized void register(XdsCredentialsProvider provider) {
        this.addProvider(provider);
        this.refreshProviders();
    }

    private synchronized void addProvider(XdsCredentialsProvider provider) {
        Preconditions.checkArgument(provider.isAvailable(), "isAvailable() returned false");
        this.allProviders.add(provider);
    }

    public synchronized void deregister(XdsCredentialsProvider provider) {
        this.allProviders.remove(provider);
        this.refreshProviders();
    }

    private synchronized void refreshProviders() {
        HashMap<String, XdsCredentialsProvider> refreshedProviders = new HashMap<String, XdsCredentialsProvider>();
        int maxPriority = Integer.MIN_VALUE;
        for (XdsCredentialsProvider provider : this.allProviders) {
            String credsName = provider.getName();
            XdsCredentialsProvider existing = (XdsCredentialsProvider)refreshedProviders.get(credsName);
            if (existing == null || existing.priority() < provider.priority()) {
                refreshedProviders.put(credsName, provider);
            }
            if (maxPriority >= provider.priority()) continue;
            maxPriority = provider.priority();
        }
        this.effectiveProviders = ImmutableMap.copyOf(refreshedProviders);
    }

    public static synchronized XdsCredentialsRegistry getDefaultRegistry() {
        if (instance == null) {
            List<XdsCredentialsProvider> providerList = InternalServiceProviders.loadAll(XdsCredentialsProvider.class, XdsCredentialsRegistry.getHardCodedClasses(), XdsCredentialsProvider.class.getClassLoader(), new XdsCredentialsProviderPriorityAccessor());
            if (providerList.isEmpty()) {
                logger.warning("No XdsCredsRegistry found via ServiceLoader, including for GoogleDefault, TLS and Insecure. This is probably due to a broken build.");
            }
            instance = new XdsCredentialsRegistry();
            for (XdsCredentialsProvider provider : providerList) {
                logger.fine("Service loader found " + provider);
                if (!provider.isAvailable()) continue;
                instance.addProvider(provider);
            }
            instance.refreshProviders();
        }
        return instance;
    }

    @VisibleForTesting
    synchronized Map<String, XdsCredentialsProvider> providers() {
        return this.effectiveProviders;
    }

    @Nullable
    public synchronized XdsCredentialsProvider getProvider(String name) {
        return this.effectiveProviders.get(Preconditions.checkNotNull(name, "name"));
    }

    @VisibleForTesting
    static List<Class<?>> getHardCodedClasses() {
        ArrayList list = new ArrayList();
        try {
            list.add(Class.forName("net.snowflake.client.jdbc.internal.grpc.xds.internal.GoogleDefaultXdsCredentialsProvider"));
        }
        catch (ClassNotFoundException e) {
            logger.log(Level.WARNING, "Unable to find GoogleDefaultXdsCredentialsProvider", e);
        }
        try {
            list.add(Class.forName("net.snowflake.client.jdbc.internal.grpc.xds.internal.InsecureXdsCredentialsProvider"));
        }
        catch (ClassNotFoundException e) {
            logger.log(Level.WARNING, "Unable to find InsecureXdsCredentialsProvider", e);
        }
        try {
            list.add(Class.forName("net.snowflake.client.jdbc.internal.grpc.xds.internal.TlsXdsCredentialsProvider"));
        }
        catch (ClassNotFoundException e) {
            logger.log(Level.WARNING, "Unable to find TlsXdsCredentialsProvider", e);
        }
        return Collections.unmodifiableList(list);
    }

    private static final class XdsCredentialsProviderPriorityAccessor
    implements InternalServiceProviders.PriorityAccessor<XdsCredentialsProvider> {
        private XdsCredentialsProviderPriorityAccessor() {
        }

        @Override
        public boolean isAvailable(XdsCredentialsProvider provider) {
            return provider.isAvailable();
        }

        @Override
        public int getPriority(XdsCredentialsProvider provider) {
            return provider.priority();
        }
    }
}

