/*
 * Decompiled with CFR 0.152.
 */
package net.snowflake.client.jdbc.internal.opentelemetry.sdk.common;

import java.util.concurrent.TimeUnit;
import net.snowflake.client.jdbc.internal.javax.annotation.concurrent.ThreadSafe;
import net.snowflake.client.jdbc.internal.opentelemetry.sdk.common.Clock;
import net.snowflake.client.jdbc.internal.opentelemetry.sdk.internal.JavaVersionSpecific;

@ThreadSafe
final class SystemClock
implements Clock {
    private static final SystemClock INSTANCE = new SystemClock();

    private SystemClock() {
    }

    static Clock getInstance() {
        return INSTANCE;
    }

    @Override
    public long now() {
        return this.now(true);
    }

    @Override
    public long now(boolean highPrecision) {
        if (highPrecision) {
            return JavaVersionSpecific.get().currentTimeNanos();
        }
        return TimeUnit.MILLISECONDS.toNanos(System.currentTimeMillis());
    }

    @Override
    public long nanoTime() {
        return System.nanoTime();
    }

    public String toString() {
        return "SystemClock{}";
    }
}

