/*
 * Decompiled with CFR 0.152.
 */
package net.snowflake.client.jdbc.internal.opentelemetry.sdk.trace;

import java.util.List;
import net.snowflake.client.jdbc.internal.google.auto.value.AutoValue;
import net.snowflake.client.jdbc.internal.javax.annotation.concurrent.Immutable;
import net.snowflake.client.jdbc.internal.opentelemetry.api.common.Attributes;
import net.snowflake.client.jdbc.internal.opentelemetry.api.trace.SpanContext;
import net.snowflake.client.jdbc.internal.opentelemetry.api.trace.SpanKind;
import net.snowflake.client.jdbc.internal.opentelemetry.sdk.common.InstrumentationLibraryInfo;
import net.snowflake.client.jdbc.internal.opentelemetry.sdk.common.InstrumentationScopeInfo;
import net.snowflake.client.jdbc.internal.opentelemetry.sdk.internal.InstrumentationScopeUtil;
import net.snowflake.client.jdbc.internal.opentelemetry.sdk.resources.Resource;
import net.snowflake.client.jdbc.internal.opentelemetry.sdk.trace.AutoValue_SpanWrapper;
import net.snowflake.client.jdbc.internal.opentelemetry.sdk.trace.SdkSpan;
import net.snowflake.client.jdbc.internal.opentelemetry.sdk.trace.data.EventData;
import net.snowflake.client.jdbc.internal.opentelemetry.sdk.trace.data.LinkData;
import net.snowflake.client.jdbc.internal.opentelemetry.sdk.trace.data.SpanData;
import net.snowflake.client.jdbc.internal.opentelemetry.sdk.trace.data.StatusData;

@Immutable
@AutoValue
abstract class SpanWrapper
implements SpanData {
    SpanWrapper() {
    }

    abstract SdkSpan delegate();

    abstract List<LinkData> resolvedLinks();

    abstract List<EventData> resolvedEvents();

    abstract Attributes attributes();

    abstract int totalAttributeCount();

    abstract int totalRecordedEvents();

    abstract int totalRecordedLinks();

    abstract StatusData status();

    abstract String name();

    abstract long endEpochNanos();

    abstract boolean internalHasEnded();

    static SpanWrapper create(SdkSpan delegate, List<LinkData> links, List<EventData> events, Attributes attributes, int totalAttributeCount, int totalRecordedEvents, int totalRecordedLinks, StatusData status, String name, long endEpochNanos, boolean hasEnded) {
        return new AutoValue_SpanWrapper(delegate, links, events, attributes, totalAttributeCount, totalRecordedEvents, totalRecordedLinks, status, name, endEpochNanos, hasEnded);
    }

    @Override
    public SpanContext getSpanContext() {
        return this.delegate().getSpanContext();
    }

    @Override
    public SpanContext getParentSpanContext() {
        return this.delegate().getParentSpanContext();
    }

    @Override
    public Resource getResource() {
        return this.delegate().getResource();
    }

    @Override
    @Deprecated
    public InstrumentationLibraryInfo getInstrumentationLibraryInfo() {
        return InstrumentationScopeUtil.toInstrumentationLibraryInfo(this.delegate().getInstrumentationScopeInfo());
    }

    @Override
    public InstrumentationScopeInfo getInstrumentationScopeInfo() {
        return this.delegate().getInstrumentationScopeInfo();
    }

    @Override
    public String getName() {
        return this.name();
    }

    @Override
    public SpanKind getKind() {
        return this.delegate().getKind();
    }

    @Override
    public long getStartEpochNanos() {
        return this.delegate().getStartEpochNanos();
    }

    @Override
    public Attributes getAttributes() {
        return this.attributes();
    }

    @Override
    public List<EventData> getEvents() {
        return this.resolvedEvents();
    }

    @Override
    public List<LinkData> getLinks() {
        return this.resolvedLinks();
    }

    @Override
    public StatusData getStatus() {
        return this.status();
    }

    @Override
    public long getEndEpochNanos() {
        return this.endEpochNanos();
    }

    @Override
    public boolean hasEnded() {
        return this.internalHasEnded();
    }

    @Override
    public int getTotalRecordedEvents() {
        return this.totalRecordedEvents();
    }

    @Override
    public int getTotalRecordedLinks() {
        return this.totalRecordedLinks();
    }

    @Override
    public int getTotalAttributeCount() {
        return this.totalAttributeCount();
    }

    public final String toString() {
        return "SpanData{spanContext=" + this.getSpanContext() + ", parentSpanContext=" + this.getParentSpanContext() + ", resource=" + this.getResource() + ", instrumentationScopeInfo=" + this.getInstrumentationScopeInfo() + ", name=" + this.getName() + ", kind=" + (Object)((Object)this.getKind()) + ", startEpochNanos=" + this.getStartEpochNanos() + ", endEpochNanos=" + this.getEndEpochNanos() + ", attributes=" + this.getAttributes() + ", totalAttributeCount=" + this.getTotalAttributeCount() + ", events=" + this.getEvents() + ", totalRecordedEvents=" + this.getTotalRecordedEvents() + ", links=" + this.getLinks() + ", totalRecordedLinks=" + this.getTotalRecordedLinks() + ", status=" + this.getStatus() + ", hasEnded=" + this.hasEnded() + "}";
    }
}

