/*
 * Decompiled with CFR 0.152.
 */
package net.snowflake.client.jdbc;

import java.math.BigDecimal;
import java.sql.Time;
import java.sql.Timestamp;
import java.text.DateFormat;
import java.util.Date;
import net.snowflake.client.jdbc.ErrorCode;
import net.snowflake.client.jdbc.SnowflakeSQLException;
import net.snowflake.client.jdbc.internal.snowflake.common.core.SFBinary;

public enum SnowflakeType {
    TEXT,
    CHAR,
    INTEGER,
    FIXED,
    REAL,
    TIMESTAMP,
    TIMESTAMP_LTZ,
    TIMESTAMP_NTZ,
    TIMESTAMP_TZ,
    DATE,
    TIME,
    BOOLEAN,
    ARRAY,
    OBJECT,
    VARIANT,
    BINARY,
    ANY;

    public static final String DATE_OR_TIME_FORMAT_PATTERN = "yyyy-MM-dd'T'HH:mm:ss.SSSXXX";
    public static final String TIMESTAMP_FORMAT_PATTERN = "yyyy-MM-dd'T'HH:mm:ss.";
    public static final String TIMESTAMP_FORMAT_TZ_PATTERN = "XXX";
    public static final String TIME_FORMAT_PATTERN = "HH:MM:ss.SSS";

    public static SnowflakeType fromString(String name) {
        return SnowflakeType.valueOf(name.toUpperCase());
    }

    public static JavaDataType getJavaType(SnowflakeType type) {
        switch (type) {
            case TEXT: {
                return JavaDataType.JAVA_STRING;
            }
            case CHAR: {
                return JavaDataType.JAVA_STRING;
            }
            case INTEGER: {
                return JavaDataType.JAVA_LONG;
            }
            case FIXED: {
                return JavaDataType.JAVA_BIGDECIMAL;
            }
            case REAL: {
                return JavaDataType.JAVA_DOUBLE;
            }
            case TIMESTAMP: 
            case TIME: 
            case TIMESTAMP_LTZ: 
            case TIMESTAMP_NTZ: 
            case TIMESTAMP_TZ: 
            case DATE: {
                return JavaDataType.JAVA_TIMESTAMP;
            }
            case BOOLEAN: {
                return JavaDataType.JAVA_BOOLEAN;
            }
            case ARRAY: 
            case VARIANT: {
                return JavaDataType.JAVA_STRING;
            }
            case OBJECT: {
                return JavaDataType.JAVA_STRING;
            }
            case BINARY: {
                return JavaDataType.JAVA_BYTES;
            }
            case ANY: {
                return JavaDataType.JAVA_OBJECT;
            }
        }
        return JavaDataType.JAVA_STRING;
    }

    public static String lexicalValue(Object o, DateFormat dateFormat, DateFormat timeFormat, DateFormat timestampFormat, DateFormat timestampTzFormat) {
        if (o == null) {
            return null;
        }
        Class<?> c = o.getClass();
        if (c == Date.class || c == java.sql.Date.class) {
            return SnowflakeType.synchronizeFormat(o, dateFormat);
        }
        if (c == Time.class) {
            return SnowflakeType.synchronizeFormat(o, timeFormat);
        }
        if (c == Timestamp.class) {
            String stdFmt = o.toString();
            String nanos = stdFmt.substring(stdFmt.indexOf(46) + 1);
            String ret1 = SnowflakeType.synchronizeFormat(o, timestampFormat);
            String ret2 = SnowflakeType.synchronizeFormat(o, timestampTzFormat);
            return ret1 + nanos + ret2;
        }
        if (c == Double.class) {
            return Double.toHexString((Double)o);
        }
        if (c == Float.class) {
            return Float.toHexString(((Float)o).floatValue());
        }
        if (c == Integer.class) {
            return o.toString();
        }
        if (c == BigDecimal.class) {
            return o.toString();
        }
        if (c == byte[].class) {
            return new SFBinary((byte[])o).toHex();
        }
        return String.valueOf(o);
    }

    private static synchronized String synchronizeFormat(Object o, DateFormat sdf) {
        return sdf.format(o);
    }

    public static String escapeForCSV(String value) {
        if (value == null) {
            return "";
        }
        if (value.isEmpty()) {
            return "\"\"";
        }
        if (value.indexOf(34) >= 0 || value.indexOf(10) >= 0 || value.indexOf(44) >= 0 || value.indexOf(92) >= 0) {
            return '\"' + value.replaceAll("\"", "\"\"") + '\"';
        }
        return value;
    }

    public static SnowflakeType javaTypeToSFType(int javaType) throws SnowflakeSQLException {
        switch (javaType) {
            case -6: 
            case -5: 
            case 2: 
            case 3: 
            case 4: 
            case 5: {
                return FIXED;
            }
            case 1: 
            case 12: {
                return TEXT;
            }
            case -2: {
                return BINARY;
            }
            case 6: 
            case 8: {
                return REAL;
            }
            case 91: {
                return DATE;
            }
            case 92: {
                return TIME;
            }
            case 93: {
                return TIMESTAMP;
            }
            case 16: {
                return BOOLEAN;
            }
            case 0: {
                return ANY;
            }
        }
        throw new SnowflakeSQLException("0A000", ErrorCode.DATA_TYPE_NOT_SUPPORTED.getMessageCode(), javaType);
    }

    public static enum JavaDataType {
        JAVA_STRING(String.class),
        JAVA_LONG(Long.class),
        JAVA_DOUBLE(Double.class),
        JAVA_BIGDECIMAL(BigDecimal.class),
        JAVA_TIMESTAMP(Timestamp.class),
        JAVA_BYTES(byte[].class),
        JAVA_BOOLEAN(Boolean.class),
        JAVA_OBJECT(Object.class);

        private Class _class;

        private JavaDataType(Class c) {
            this._class = c;
        }
    }
}

