/*
 * Decompiled with CFR 0.152.
 */
package net.snowflake.client.jdbc;

import java.sql.BatchUpdateException;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.SQLFeatureNotSupportedException;
import java.sql.SQLWarning;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import net.snowflake.client.core.ParameterBindingDTO;
import net.snowflake.client.core.ResultUtil;
import net.snowflake.client.core.SFBaseResultSet;
import net.snowflake.client.core.SFException;
import net.snowflake.client.core.SFStatement;
import net.snowflake.client.core.StmtUtil;
import net.snowflake.client.jdbc.ErrorCode;
import net.snowflake.client.jdbc.SnowflakeConnectionV1;
import net.snowflake.client.jdbc.SnowflakeResultSetV1;
import net.snowflake.client.jdbc.SnowflakeSQLException;
import net.snowflake.client.log.SFLogger;
import net.snowflake.client.log.SFLoggerFactory;

class SnowflakeStatementV1
implements Statement {
    static final SFLogger logger = SFLoggerFactory.getLogger(SnowflakeStatementV1.class);
    static final int NO_UPDATES = -1;
    protected SnowflakeConnectionV1 connection;
    private int maxRows = 0;
    private ResultSet resultSet = null;
    private int fetchSize = 50;
    private Boolean isClosed = false;
    private int updateCount = -1;
    private boolean escapeProcessing = false;
    private int queryTimeout = 0;
    private final int maxFieldSize = 0x1000000;
    protected SFStatement sfStatement;
    protected final List<BatchEntry> batch = new ArrayList<BatchEntry>();
    protected SQLWarning sqlWarnings;

    SnowflakeStatementV1(SnowflakeConnectionV1 conn) {
        logger.debug(" public SnowflakeStatement(SnowflakeConnectionV1 conn)");
        this.connection = conn;
        this.sfStatement = new SFStatement(conn.getSfSession());
    }

    @Override
    public ResultSet executeQuery(String sql) throws SQLException {
        return this.executeQueryInternal(sql, null);
    }

    @Override
    public int executeUpdate(String sql) throws SQLException {
        return this.executeUpdateInternal(sql, null, true);
    }

    int executeUpdateInternal(String sql, Map<String, ParameterBindingDTO> parameterBindings, boolean updateQueryRequired) throws SQLException {
        if (StmtUtil.checkStageManageCommand(sql) != null) {
            throw new SnowflakeSQLException(ErrorCode.UNSUPPORTED_STATEMENT_TYPE_IN_EXECUTION_API, sql.length() > 20 ? sql.substring(0, 20) + "..." : sql);
        }
        SFBaseResultSet sfResultSet = null;
        try {
            sfResultSet = this.sfStatement.execute(sql, parameterBindings, SFStatement.CallingMethod.EXECUTE_UPDATE);
            sfResultSet.setSession(this.connection.getSfSession());
            this.updateCount = ResultUtil.calculateUpdateCount(sfResultSet);
            this.resultSet = null;
        }
        catch (SFException ex) {
            throw new SnowflakeSQLException(ex.getCause(), ex.getSqlState(), ex.getVendorCode(), ex.getParams());
        }
        if (this.getUpdateCount() == -1 && updateQueryRequired) {
            throw new SnowflakeSQLException(ErrorCode.UNSUPPORTED_STATEMENT_TYPE_IN_EXECUTION_API, sql.length() > 20 ? sql.substring(0, 20) + "..." : sql);
        }
        return this.getUpdateCount();
    }

    ResultSet executeQueryInternal(String sql, Map<String, ParameterBindingDTO> parameterBindings) throws SQLException {
        SFBaseResultSet sfResultSet = null;
        try {
            sfResultSet = this.sfStatement.execute(sql, parameterBindings, SFStatement.CallingMethod.EXECUTE_QUERY);
            sfResultSet.setSession(this.connection.getSfSession());
        }
        catch (SFException ex) {
            throw new SnowflakeSQLException(ex.getCause(), ex.getSqlState(), ex.getVendorCode(), ex.getParams());
        }
        this.resultSet = new SnowflakeResultSetV1(sfResultSet, this);
        return this.getResultSet();
    }

    boolean executeInternal(String sql, Map<String, ParameterBindingDTO> parameterBindings) throws SQLException {
        this.connection.injectedDelay();
        logger.debug("execute: {}", sql);
        String trimmedSql = sql.trim();
        if (trimmedSql.length() >= 20 && trimmedSql.toLowerCase().startsWith("set-sf-property")) {
            this.executeSetProperty(sql);
            return false;
        }
        SFBaseResultSet sfResultSet = null;
        try {
            sfResultSet = this.sfStatement.execute(sql, parameterBindings, SFStatement.CallingMethod.EXECUTE);
            sfResultSet.setSession(this.connection.getSfSession());
            this.resultSet = new SnowflakeResultSetV1(sfResultSet, this);
            if (!sfResultSet.getStatementType().isGenerateResultSet() && (this.connection.getSfSession().isExecuteReturnCountForDML() || this.sfStatement.hasChildren())) {
                this.updateCount = ResultUtil.calculateUpdateCount(sfResultSet);
                this.resultSet = null;
                return false;
            }
            this.updateCount = -1;
            return true;
        }
        catch (SFException ex) {
            throw new SnowflakeSQLException(ex.getCause(), ex.getSqlState(), ex.getVendorCode(), ex.getParams());
        }
    }

    @Override
    public boolean execute(String sql) throws SQLException {
        return this.executeInternal(sql, null);
    }

    @Override
    public boolean execute(String sql, int autoGeneratedKeys) throws SQLException {
        logger.debug("public int execute(String sql, int autoGeneratedKeys)");
        if (autoGeneratedKeys == 2) {
            return this.execute(sql);
        }
        throw new SQLFeatureNotSupportedException();
    }

    @Override
    public boolean execute(String sql, int[] columnIndexes) throws SQLException {
        logger.debug("public boolean execute(String sql, int[] columnIndexes)");
        throw new SQLFeatureNotSupportedException();
    }

    @Override
    public boolean execute(String sql, String[] columnNames) throws SQLException {
        logger.debug("public boolean execute(String sql, String[] columnNames)");
        throw new SQLFeatureNotSupportedException();
    }

    @Override
    public int[] executeBatch() throws SQLException {
        logger.debug("public int[] executeBatch()");
        return this.executeBatchInternal();
    }

    int[] executeBatchInternal() throws SQLException {
        if (this.isClosed.booleanValue()) {
            throw new SnowflakeSQLException(ErrorCode.STATEMENT_CLOSED, new Object[0]);
        }
        Throwable exceptionReturned = null;
        int[] updateCounts = new int[this.batch.size()];
        for (int i = 0; i < this.batch.size(); ++i) {
            try {
                int cnt = this.executeUpdateInternal(this.batch.get(i).getSql(), this.batch.get(i).getParameterBindings(), false);
                if (cnt == -1) {
                    cnt = -2;
                }
                updateCounts[i] = cnt;
                continue;
            }
            catch (SQLException e) {
                exceptionReturned = exceptionReturned == null ? e : exceptionReturned;
                updateCounts[i] = -3;
            }
        }
        if (exceptionReturned != null) {
            throw new BatchUpdateException(exceptionReturned.getLocalizedMessage(), ((SQLException)exceptionReturned).getSQLState(), ((SQLException)exceptionReturned).getErrorCode(), updateCounts, exceptionReturned);
        }
        return updateCounts;
    }

    @Override
    public int executeUpdate(String sql, int autoGeneratedKeys) throws SQLException {
        logger.debug("public int executeUpdate(String sql, int autoGeneratedKeys)");
        if (autoGeneratedKeys == 2) {
            return this.executeUpdate(sql);
        }
        throw new SQLFeatureNotSupportedException();
    }

    @Override
    public int executeUpdate(String sql, int[] columnIndexes) throws SQLException {
        logger.debug("public int executeUpdate(String sql, int[] columnIndexes)");
        throw new SQLFeatureNotSupportedException();
    }

    @Override
    public int executeUpdate(String sql, String[] columnNames) throws SQLException {
        logger.debug("public int executeUpdate(String sql, String[] columnNames)");
        throw new SQLFeatureNotSupportedException();
    }

    @Override
    public Connection getConnection() throws SQLException {
        logger.debug("public Connection getConnection()");
        return this.connection;
    }

    @Override
    public int getFetchDirection() throws SQLException {
        logger.debug("public int getFetchDirection()");
        return 1000;
    }

    @Override
    public int getFetchSize() throws SQLException {
        logger.debug("public int getFetchSize()");
        return this.fetchSize;
    }

    @Override
    public ResultSet getGeneratedKeys() throws SQLException {
        logger.debug("public ResultSet getGeneratedKeys()");
        throw new SQLFeatureNotSupportedException();
    }

    @Override
    public int getMaxFieldSize() throws SQLException {
        logger.debug("public int getMaxFieldSize()");
        return 0x1000000;
    }

    @Override
    public int getMaxRows() throws SQLException {
        logger.debug("public int getMaxRows()");
        return this.maxRows;
    }

    @Override
    public boolean getMoreResults() throws SQLException {
        logger.debug("public boolean getMoreResults()");
        return this.getMoreResults(1);
    }

    @Override
    public boolean getMoreResults(int current) throws SQLException {
        logger.debug("public boolean getMoreResults(int current)");
        if (this.resultSet != null && (current == 1 || current == 3)) {
            this.resultSet.close();
        }
        boolean hasResultSet = this.sfStatement.getMoreResults(current);
        SFBaseResultSet sfResultSet = this.sfStatement.getResultSet();
        if (hasResultSet) {
            sfResultSet.setSession(this.connection.getSfSession());
            this.resultSet = new SnowflakeResultSetV1(sfResultSet, this);
            this.updateCount = -1;
            return true;
        }
        if (sfResultSet != null) {
            this.resultSet = null;
            try {
                this.updateCount = ResultUtil.calculateUpdateCount(sfResultSet);
            }
            catch (SFException ex) {
                throw new SnowflakeSQLException(ex);
            }
            return false;
        }
        this.updateCount = -1;
        return false;
    }

    @Override
    public int getQueryTimeout() throws SQLException {
        logger.debug("public int getQueryTimeout()");
        return this.queryTimeout;
    }

    @Override
    public ResultSet getResultSet() throws SQLException {
        logger.debug("public ResultSet getResultSet()");
        return this.resultSet;
    }

    @Override
    public int getResultSetConcurrency() throws SQLException {
        logger.debug("public int getResultSetConcurrency()");
        throw new SQLFeatureNotSupportedException();
    }

    @Override
    public int getResultSetHoldability() throws SQLException {
        logger.debug("public int getResultSetHoldability()");
        throw new SQLFeatureNotSupportedException();
    }

    @Override
    public int getResultSetType() throws SQLException {
        logger.debug("public int getResultSetType()");
        return 1003;
    }

    @Override
    public int getUpdateCount() throws SQLException {
        logger.debug("public int getUpdateCount()");
        return this.updateCount;
    }

    @Override
    public SQLWarning getWarnings() throws SQLException {
        logger.debug("public SQLWarning getWarnings()");
        return this.sqlWarnings;
    }

    @Override
    public boolean isClosed() throws SQLException {
        logger.debug("public boolean isClosed()");
        return this.isClosed;
    }

    @Override
    public boolean isPoolable() throws SQLException {
        logger.debug("public boolean isPoolable()");
        throw new SQLFeatureNotSupportedException();
    }

    @Override
    public void setCursorName(String name) throws SQLException {
        logger.debug("public void setCursorName(String name)");
        throw new SQLFeatureNotSupportedException();
    }

    @Override
    public void setEscapeProcessing(boolean enable) throws SQLException {
        logger.debug("public void setEscapeProcessing(boolean enable)");
        this.escapeProcessing = true;
    }

    @Override
    public void setFetchDirection(int direction) throws SQLException {
        logger.debug("public void setFetchDirection(int direction)");
        if (direction != 1000) {
            throw new SQLFeatureNotSupportedException();
        }
    }

    @Override
    public void setFetchSize(int rows) throws SQLException {
        logger.debug("public void setFetchSize(int rows), rows={}", rows);
        this.fetchSize = rows;
    }

    @Override
    public void setMaxFieldSize(int max) throws SQLException {
        logger.debug("public void setMaxFieldSize(int max)");
        throw new SQLFeatureNotSupportedException();
    }

    @Override
    public void setMaxRows(int max) throws SQLException {
        logger.debug("public void setMaxRows(int max)");
        this.maxRows = max;
        try {
            if (this.sfStatement != null) {
                this.sfStatement.addProperty("rows_per_resultset", max);
            }
        }
        catch (SFException ex) {
            throw new SnowflakeSQLException(ex.getCause(), ex.getSqlState(), ex.getVendorCode(), ex.getParams());
        }
    }

    @Override
    public void setPoolable(boolean poolable) throws SQLException {
        logger.debug("public void setPoolable(boolean poolable)");
        if (poolable) {
            throw new SQLFeatureNotSupportedException();
        }
    }

    public void setParameter(String name, Object value) throws Exception {
        logger.debug("public void setParameter");
        try {
            if (this.sfStatement != null) {
                this.sfStatement.addProperty(name, value);
            }
        }
        catch (SFException ex) {
            throw new SnowflakeSQLException(ex);
        }
    }

    @Override
    public void setQueryTimeout(int seconds) throws SQLException {
        logger.debug("public void setQueryTimeout(int seconds)");
        this.queryTimeout = seconds;
        try {
            if (this.sfStatement != null) {
                this.sfStatement.addProperty("query_timeout", seconds);
            }
        }
        catch (SFException ex) {
            throw new SnowflakeSQLException(ex.getCause(), ex.getSqlState(), ex.getVendorCode(), ex.getParams());
        }
    }

    @Override
    public boolean isWrapperFor(Class<?> iface) throws SQLException {
        logger.debug("public boolean isWrapperFor(Class<?> iface)");
        return iface.isInstance(this);
    }

    @Override
    public <T> T unwrap(Class<T> iface) throws SQLException {
        logger.debug("public <T> T unwrap(Class<T> iface)");
        if (!iface.isInstance(this)) {
            throw new SQLException(this.getClass().getName() + " not unwrappable from " + iface.getName());
        }
        return (T)this;
    }

    @Override
    public void closeOnCompletion() throws SQLException {
        logger.debug("public void closeOnCompletion()");
        throw new SQLFeatureNotSupportedException();
    }

    @Override
    public boolean isCloseOnCompletion() throws SQLException {
        logger.debug("public boolean isCloseOnCompletion()");
        throw new SQLFeatureNotSupportedException();
    }

    @Override
    public void close() throws SQLException {
        logger.debug("public void close()");
        this.resultSet = null;
        this.isClosed = true;
        this.batch.clear();
        this.sfStatement.close();
    }

    @Override
    public void cancel() throws SQLException {
        logger.debug("public void cancel()");
        try {
            this.sfStatement.cancel();
        }
        catch (SFException ex) {
            throw new SnowflakeSQLException(ex, ex.getSqlState(), ex.getVendorCode(), ex.getParams());
        }
    }

    @Override
    public void clearWarnings() throws SQLException {
        logger.debug("public void clearWarnings()");
        this.sqlWarnings = null;
    }

    @Override
    public void addBatch(String sql) throws SQLException {
        logger.debug("public void addBatch(String sql)");
        if (this.isClosed.booleanValue()) {
            throw new SnowflakeSQLException(ErrorCode.STATEMENT_CLOSED, new Object[0]);
        }
        this.batch.add(new BatchEntry(sql, null));
    }

    @Override
    public void clearBatch() throws SQLException {
        logger.debug("public void clearBatch()");
        if (this.isClosed.booleanValue()) {
            throw new SnowflakeSQLException(ErrorCode.STATEMENT_CLOSED, new Object[0]);
        }
        this.batch.clear();
    }

    private void executeSetProperty(String sql) {
        logger.debug("setting property");
        String[] tokens = sql.split("\\s+");
        if (tokens == null || tokens.length < 2) {
            return;
        }
        if ("tracing".equalsIgnoreCase(tokens[1])) {
            if (tokens.length >= 3) {
                // empty if block
            }
        } else {
            this.sfStatement.executeSetProperty(sql);
        }
    }

    public SFStatement getSfStatement() {
        return this.sfStatement;
    }

    protected void appendWarning(SQLWarning w) {
        if (this.sqlWarnings == null) {
            this.sqlWarnings = w;
        } else {
            this.sqlWarnings.setNextWarning(w);
        }
    }

    final class BatchEntry {
        private final String sql;
        private final Map<String, ParameterBindingDTO> parameterBindings;

        BatchEntry(String sql, Map<String, ParameterBindingDTO> parameterBindings) {
            this.sql = sql;
            this.parameterBindings = parameterBindings;
        }

        public String getSql() {
            return this.sql;
        }

        public Map<String, ParameterBindingDTO> getParameterBindings() {
            return this.parameterBindings;
        }
    }
}

