/*
 * Decompiled with CFR 0.152.
 */
package net.snowflake.client.jdbc.cloud.storage;

import java.util.Map;

public class StageInfo {
    private StageType stageType;
    private String location;
    private Map credentials;
    private String region;
    private String endPoint;
    private String storageAccount;

    public static StageInfo createStageInfo(String locationType, String location, Map credentials, String region, String endPoint, String storageAccount) throws IllegalArgumentException {
        StageType stageType;
        switch (locationType) {
            case "AZURE": {
                stageType = StageType.AZURE;
                if (StageInfo.isSpecified(location) && StageInfo.isSpecified(endPoint) && StageInfo.isSpecified(storageAccount) && credentials != null) break;
                throw new IllegalArgumentException("Incomplete parameters specified for Azure stage");
            }
            case "S3": {
                stageType = StageType.S3;
                if (StageInfo.isSpecified(location) && StageInfo.isSpecified(region) && credentials != null) break;
                throw new IllegalArgumentException("Incomplete parameters specified for S3 stage");
            }
            case "LOCAL_FS": {
                stageType = StageType.LOCAL_FS;
                if (StageInfo.isSpecified(location)) break;
                throw new IllegalArgumentException("Incomplete parameters specific for local stage");
            }
            default: {
                throw new IllegalArgumentException("Invalid stage type: " + locationType);
            }
        }
        return new StageInfo(stageType, location, credentials, region, endPoint, storageAccount);
    }

    private StageInfo(StageType stageType, String location, Map credentials, String region, String endPoint, String storageAccount) {
        this.stageType = stageType;
        this.location = location;
        this.credentials = credentials;
        this.region = region;
        this.endPoint = endPoint;
        this.storageAccount = storageAccount;
    }

    public StageType getStageType() {
        return this.stageType;
    }

    public String getLocation() {
        return this.location;
    }

    public Map getCredentials() {
        return this.credentials;
    }

    public void setCredentials(Map credentials) {
        this.credentials = credentials;
    }

    public String getRegion() {
        return this.region;
    }

    public String getEndPoint() {
        return this.endPoint;
    }

    public String getStorageAccount() {
        return this.storageAccount;
    }

    private static boolean isSpecified(String arg) {
        return arg != null && !arg.equalsIgnoreCase("");
    }

    public static enum StageType {
        S3,
        AZURE,
        LOCAL_FS;

    }
}

