/*
 * Decompiled with CFR 0.152.
 */
package net.snowflake.client.core;

import java.io.IOException;
import java.net.URI;
import java.net.URISyntaxException;
import java.nio.charset.StandardCharsets;
import java.util.UUID;
import java.util.zip.GZIPOutputStream;
import net.snowflake.client.core.Event;
import net.snowflake.client.core.EventUtil;
import net.snowflake.client.core.HttpUtil;
import net.snowflake.client.core.IncidentV2DTO;
import net.snowflake.client.core.ObjectMapperFactory;
import net.snowflake.client.core.SFSession;
import net.snowflake.client.jdbc.SnowflakeDriver;
import net.snowflake.client.jdbc.internal.apache.commons.io.output.ByteArrayOutputStream;
import net.snowflake.client.jdbc.internal.apache.http.client.methods.HttpPost;
import net.snowflake.client.jdbc.internal.apache.http.client.utils.URIBuilder;
import net.snowflake.client.jdbc.internal.apache.http.entity.ByteArrayEntity;
import net.snowflake.client.jdbc.internal.apache.tika.utils.ExceptionUtils;
import net.snowflake.client.jdbc.internal.fasterxml.jackson.core.JsonProcessingException;
import net.snowflake.client.jdbc.internal.fasterxml.jackson.databind.ObjectMapper;
import net.snowflake.client.jdbc.internal.google.common.base.Preconditions;
import net.snowflake.client.log.SFLogger;
import net.snowflake.client.log.SFLoggerFactory;
import net.snowflake.client.util.SFTimestamp;

public class Incident
extends Event {
    private static final SFLogger logger = SFLoggerFactory.getLogger(Incident.class);
    private static final String SF_PATH_CREATE_INCIDENT_V2 = "/incidents/v2/create-incident";
    final String serverUrl;
    final String sessionToken;
    final String driverName = "jdbc";
    final String driverVersion = SnowflakeDriver.implementVersion;
    final String signature;
    final String errorMessage;
    final String errorStackTrace;
    final String osName;
    final String osVersion;
    final String jobId;
    final String requestId;
    final String timestamp = SFTimestamp.getUTCNow() + ".000";
    final String uuid = UUID.randomUUID().toString();

    public Incident(SFSession session, Throwable exc, String jobId, String requestId) {
        this(session, jobId, requestId, exc.getMessage(), ExceptionUtils.getStackTrace(exc), String.valueOf(exc.getStackTrace()[0]));
    }

    public Incident(String serverUrl, String sessionToken, Throwable exc, String jobId, String requestId) {
        this(serverUrl, sessionToken, jobId, requestId, exc.getMessage(), ExceptionUtils.getStackTrace(exc), String.valueOf(exc.getStackTrace()[0]));
    }

    Incident(SFSession session, String jobId, String requestId, String errorMessage, String errorStackTrace, String raiser) {
        this(session.getServerUrl(), session.getSessionToken(), jobId, requestId, errorMessage, errorStackTrace, raiser);
    }

    Incident(String serverUrl, String sessionToken, String jobId, String requestId, String errorMessage, String errorStackTrace, String raiser) {
        super(Event.EventType.INCIDENT, errorMessage);
        this.serverUrl = serverUrl;
        this.sessionToken = sessionToken;
        this.jobId = jobId;
        this.requestId = requestId;
        this.signature = Incident.generateSignature(errorMessage, raiser);
        this.errorMessage = errorMessage;
        this.errorStackTrace = errorStackTrace;
        this.osName = System.getProperty("os.name");
        this.osVersion = System.getProperty("os.version");
    }

    private static String generateSignature(String errorMessage, String raiser) {
        return errorMessage + " at " + raiser;
    }

    @Override
    public void flush() {
        URI incidentURI;
        String dtoDump;
        ObjectMapper mapper = ObjectMapperFactory.getObjectMapper();
        try {
            dtoDump = mapper.writeValueAsString(new IncidentV2DTO(this));
        }
        catch (JsonProcessingException ex) {
            logger.error("Incident registration failed, could not map incident report to json string. Exception: {}", ex.getMessage());
            return;
        }
        Preconditions.checkNotNull(dtoDump);
        try {
            URIBuilder uriBuilder = new URIBuilder(this.serverUrl);
            uriBuilder.setPath(SF_PATH_CREATE_INCIDENT_V2);
            incidentURI = uriBuilder.build();
        }
        catch (URISyntaxException ex) {
            logger.error("Incident registration failed, URI could not be built. Exception: {}", ex.getMessage());
            return;
        }
        HttpPost postRequest = new HttpPost(incidentURI);
        postRequest.setHeader("Authorization", "Snowflake Token=\"" + this.sessionToken + "\"");
        ByteArrayEntity input = null;
        try {
            ByteArrayOutputStream baos = new ByteArrayOutputStream();
            GZIPOutputStream gzos = new GZIPOutputStream(baos);
            byte[] bytes = dtoDump.getBytes(StandardCharsets.UTF_8);
            gzos.write(bytes);
            gzos.finish();
            input = new ByteArrayEntity(baos.toByteArray());
            input.setContentType("application/json");
        }
        catch (IOException exc) {
            logger.debug("Incident registration failed, could not compress payload. Exception: {}", exc.getMessage());
        }
        postRequest.setEntity(input);
        postRequest.addHeader("content-encoding", "gzip");
        try {
            String response = HttpUtil.executeRequest(postRequest, 1000, 0, null);
            logger.debug("Incident registration was successful. Response: '{}'", response);
        }
        catch (Exception ex) {
            logger.error("Incident registration request failed, exception: {}", ex.getMessage());
        }
    }

    void trigger() {
        EventUtil.triggerIncident(this);
    }
}

