/*
 * Decompiled with CFR 0.152.
 */
package net.snowflake.client.core;

import java.sql.SQLException;
import net.snowflake.client.core.ResultUtil;
import net.snowflake.client.core.SFArrowResultSet;
import net.snowflake.client.core.SFBaseResultSet;
import net.snowflake.client.core.SFResultSet;
import net.snowflake.client.core.SFSession;
import net.snowflake.client.core.SFStatement;
import net.snowflake.client.jdbc.ErrorCode;
import net.snowflake.client.jdbc.SnowflakeSQLException;
import net.snowflake.client.jdbc.internal.fasterxml.jackson.databind.JsonNode;

class SFResultSetFactory {
    SFResultSetFactory() {
    }

    static SFBaseResultSet getResultSet(JsonNode result, SFStatement statement, boolean sortResult) throws SQLException {
        SFSession session = statement.getSession();
        ResultUtil.ResultInput resultInput = new ResultUtil.ResultInput();
        resultInput.setResultJSON(result).setConnectionTimeout(session.getHttpClientConnectionTimeout()).setSocketTimeout(session.getHttpClientSocketTimeout()).setNetworkTimeoutInMilli(session.getNetworkTimeoutInMilli());
        ResultUtil.ResultOutput resultOutput = ResultUtil.processResult(resultInput, statement);
        switch (resultOutput.queryResultFormat) {
            case ARROW: {
                return new SFArrowResultSet(resultOutput, statement, sortResult);
            }
            case JSON: {
                return new SFResultSet(resultOutput, statement, sortResult);
            }
        }
        throw new SnowflakeSQLException(ErrorCode.INTERNAL_ERROR, "Unsupported query result format: " + resultOutput.queryResultFormat.name());
    }
}

