/*
 * Decompiled with CFR 0.152.
 */
package net.snowflake.client.core.arrow;

import java.math.BigDecimal;
import net.snowflake.client.core.SFException;
import net.snowflake.client.core.arrow.AbstractArrowVectorConverter;
import net.snowflake.client.jdbc.ErrorCode;
import net.snowflake.client.jdbc.SnowflakeType;
import net.snowflake.client.jdbc.internal.apache.arrow.vector.BigIntVector;
import net.snowflake.client.jdbc.internal.apache.arrow.vector.ValueVector;

public class BigIntToFixedConverter
extends AbstractArrowVectorConverter {
    private BigIntVector bigIntVector;
    private Integer sfScale;

    public BigIntToFixedConverter(ValueVector fieldVector) {
        super(String.format("%s(%s,%s)", new Object[]{SnowflakeType.FIXED, fieldVector.getField().getMetadata().get("precision"), fieldVector.getField().getMetadata().get("scale")}), fieldVector);
        this.bigIntVector = (BigIntVector)fieldVector;
        String scaleStr = fieldVector.getField().getMetadata().get("scale");
        this.sfScale = Integer.parseInt(scaleStr);
    }

    @Override
    public byte toByte(int index) throws SFException {
        long longVal = this.toLong(index);
        byte byteVal = (byte)longVal;
        if ((long)byteVal == longVal) {
            return byteVal;
        }
        throw new SFException(ErrorCode.INVALID_VALUE_CONVERT, this.logicalTypeStr, "byte", longVal);
    }

    @Override
    public short toShort(int index) throws SFException {
        long longVal = this.toLong(index);
        short shortVal = (short)longVal;
        if ((long)shortVal == longVal) {
            return shortVal;
        }
        throw new SFException(ErrorCode.INVALID_VALUE_CONVERT, this.logicalTypeStr, "byte", longVal);
    }

    @Override
    public int toInt(int index) throws SFException {
        long longVal = this.toLong(index);
        int intVal = (int)longVal;
        if ((long)intVal == longVal) {
            return intVal;
        }
        throw new SFException(ErrorCode.INVALID_VALUE_CONVERT, this.logicalTypeStr, "byte", longVal);
    }

    @Override
    public long toLong(int index) throws SFException {
        if (this.bigIntVector.isNull(index)) {
            return 0L;
        }
        if (this.sfScale != 0) {
            long val = this.bigIntVector.getDataBuffer().getLong(index * 8);
            throw new SFException(ErrorCode.INVALID_VALUE_CONVERT, this.logicalTypeStr, "long", val);
        }
        return this.bigIntVector.getDataBuffer().getLong(index * 8);
    }

    @Override
    public BigDecimal toBigDecimal(int index) {
        if (this.bigIntVector.isNull(index)) {
            return null;
        }
        long val = this.bigIntVector.getDataBuffer().getLong(index * 8);
        return BigDecimal.valueOf(val, this.sfScale);
    }

    @Override
    public Object toObject(int index) throws SFException {
        return this.isNull(index) ? null : (this.sfScale == 0 ? Long.valueOf(this.toLong(index)) : this.toBigDecimal(index));
    }

    @Override
    public String toString(int index) {
        return this.isNull(index) ? null : this.toBigDecimal(index).toString();
    }
}

