/*
 * Decompiled with CFR 0.152.
 */
package net.snowflake.client.core.arrow;

import java.math.BigDecimal;
import net.snowflake.client.core.SFException;
import net.snowflake.client.core.arrow.AbstractArrowVectorConverter;
import net.snowflake.client.jdbc.ErrorCode;
import net.snowflake.client.jdbc.SnowflakeType;
import net.snowflake.client.jdbc.internal.apache.arrow.vector.TinyIntVector;
import net.snowflake.client.jdbc.internal.apache.arrow.vector.ValueVector;

public class TinyIntToFixedConverter
extends AbstractArrowVectorConverter {
    private TinyIntVector tinyIntVector;
    private Integer sfScale;

    public TinyIntToFixedConverter(ValueVector fieldVector) {
        super(String.format("%s(%s,%s)", new Object[]{SnowflakeType.FIXED, fieldVector.getField().getMetadata().get("precision"), fieldVector.getField().getMetadata().get("scale")}), fieldVector);
        this.tinyIntVector = (TinyIntVector)fieldVector;
        String scaleStr = fieldVector.getField().getMetadata().get("scale");
        this.sfScale = Integer.parseInt(scaleStr);
    }

    @Override
    public byte toByte(int index) throws SFException {
        if (this.tinyIntVector.isNull(index)) {
            return 0;
        }
        if (this.sfScale != 0) {
            byte val = this.tinyIntVector.getDataBuffer().getByte(index * 1);
            throw new SFException(ErrorCode.INVALID_VALUE_CONVERT, this.logicalTypeStr, "byte", val);
        }
        return this.tinyIntVector.getDataBuffer().getByte(index * 1);
    }

    @Override
    public short toShort(int index) throws SFException {
        return this.toByte(index);
    }

    @Override
    public int toInt(int index) throws SFException {
        return this.toByte(index);
    }

    @Override
    public long toLong(int index) throws SFException {
        return this.toByte(index);
    }

    @Override
    public BigDecimal toBigDecimal(int index) {
        if (this.tinyIntVector.isNull(index)) {
            return null;
        }
        byte val = this.tinyIntVector.getDataBuffer().getByte(index * 1);
        return BigDecimal.valueOf(val, this.sfScale);
    }

    @Override
    public Object toObject(int index) throws SFException {
        return this.isNull(index) ? null : (this.sfScale == 0 ? Byte.valueOf(this.toByte(index)) : this.toBigDecimal(index));
    }

    @Override
    public String toString(int index) {
        return this.isNull(index) ? null : this.toBigDecimal(index).toString();
    }
}

