/*
 * Decompiled with CFR 0.152.
 */
package net.snowflake.client.jdbc;

import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import net.snowflake.client.core.DataConversionContext;
import net.snowflake.client.core.arrow.ArrowVectorConverter;
import net.snowflake.client.core.arrow.BigIntToFixedConverter;
import net.snowflake.client.core.arrow.DoubleToRealConverter;
import net.snowflake.client.core.arrow.IntToDateConverter;
import net.snowflake.client.core.arrow.IntToFixedConverter;
import net.snowflake.client.core.arrow.SmallIntToFixedConverter;
import net.snowflake.client.core.arrow.TinyIntToBooleanConverter;
import net.snowflake.client.core.arrow.TinyIntToFixedConverter;
import net.snowflake.client.core.arrow.VarBinaryToBinaryConverter;
import net.snowflake.client.core.arrow.VarBinaryToTextConverter;
import net.snowflake.client.jdbc.SnowflakeResultChunk;
import net.snowflake.client.jdbc.SnowflakeType;
import net.snowflake.client.jdbc.internal.apache.arrow.memory.BufferAllocator;
import net.snowflake.client.jdbc.internal.apache.arrow.memory.RootAllocator;
import net.snowflake.client.jdbc.internal.apache.arrow.vector.FieldVector;
import net.snowflake.client.jdbc.internal.apache.arrow.vector.ValueVector;
import net.snowflake.client.jdbc.internal.apache.arrow.vector.VectorSchemaRoot;
import net.snowflake.client.jdbc.internal.apache.arrow.vector.ipc.ArrowStreamReader;
import net.snowflake.client.jdbc.internal.apache.arrow.vector.types.Types;
import net.snowflake.client.jdbc.internal.apache.arrow.vector.util.TransferPair;

public class ArrowResultChunk
extends SnowflakeResultChunk {
    private List<List<ValueVector>> batchOfVectors = new ArrayList<List<ValueVector>>();
    private static RootAllocator rootAllocator = new RootAllocator(Integer.MAX_VALUE);

    public ArrowResultChunk(String url, int rowCount, int colCount, int uncompressedSize) {
        super(url, rowCount, colCount, uncompressedSize);
    }

    private void addBatchData(List<ValueVector> batch) {
        this.batchOfVectors.add(batch);
    }

    public static void readArrowStream(InputStream is, ArrowResultChunk resultChunk) throws IOException {
        try (ArrowStreamReader reader = new ArrowStreamReader(is, (BufferAllocator)rootAllocator);){
            while (reader.loadNextBatch()) {
                ArrayList<ValueVector> valueVectors = new ArrayList<ValueVector>();
                VectorSchemaRoot root = reader.getVectorSchemaRoot();
                for (FieldVector f : root.getFieldVectors()) {
                    TransferPair t = f.getTransferPair(rootAllocator);
                    t.transfer();
                    valueVectors.add(t.getTo());
                }
                resultChunk.addBatchData(valueVectors);
            }
        }
    }

    @Override
    public long computeNeededChunkMemory() {
        return this.getUncompressedSize();
    }

    @Override
    public void freeData() {
        this.batchOfVectors.forEach(list -> list.forEach(ValueVector::clear));
    }

    private static List<ArrowVectorConverter> initConverters(List<ValueVector> vectors, DataConversionContext context) {
        ArrayList<ArrowVectorConverter> converters = new ArrayList<ArrowVectorConverter>();
        vectors.forEach(vector -> {
            Types.MinorType type = Types.getMinorTypeForArrowType(vector.getField().getType());
            Map<String, String> customMeta = vector.getField().getMetadata();
            switch (SnowflakeType.valueOf(customMeta.get("logicalType"))) {
                case BOOLEAN: {
                    converters.add(new TinyIntToBooleanConverter((ValueVector)vector));
                    break;
                }
                case FIXED: {
                    switch (type) {
                        case TINYINT: {
                            converters.add(new TinyIntToFixedConverter((ValueVector)vector));
                            break;
                        }
                        case SMALLINT: {
                            converters.add(new SmallIntToFixedConverter((ValueVector)vector));
                            break;
                        }
                        case INT: {
                            converters.add(new IntToFixedConverter((ValueVector)vector));
                            break;
                        }
                        case BIGINT: {
                            converters.add(new BigIntToFixedConverter((ValueVector)vector));
                        }
                    }
                    break;
                }
                case REAL: {
                    converters.add(new DoubleToRealConverter((ValueVector)vector));
                    break;
                }
                case TEXT: {
                    converters.add(new VarBinaryToTextConverter((ValueVector)vector));
                    break;
                }
                case DATE: {
                    converters.add(new IntToDateConverter((ValueVector)vector, context.getDateFormatter()));
                    break;
                }
                case BINARY: {
                    converters.add(new VarBinaryToBinaryConverter((ValueVector)vector, context.getBinaryFormatter()));
                }
            }
        });
        return converters;
    }

    public ArrowChunkIterator getIterator(DataConversionContext context) {
        return new ArrowChunkIterator(this, context);
    }

    public static ArrowChunkIterator getEmptyChunkIterator() {
        return new ArrowChunkIterator(new EmptyArrowResultChunk());
    }

    private static class EmptyArrowResultChunk
    extends ArrowResultChunk {
        EmptyArrowResultChunk() {
            super("", 0, 0, 0);
        }

        @Override
        public final long computeNeededChunkMemory() {
            return 0L;
        }

        @Override
        public final void freeData() {
        }
    }

    public static class ArrowChunkIterator {
        private ArrowResultChunk resultChunk;
        private int currentRecordBatchIndex;
        private int totalRecordBatch;
        private int currentRowInRecordBatch;
        private int rowCountInCurrentRecordBatch;
        private List<ArrowVectorConverter> currentConverters;
        private final DataConversionContext dataConversionContext;

        ArrowChunkIterator(ArrowResultChunk resultChunk, DataConversionContext conversionContext) {
            this.resultChunk = resultChunk;
            this.currentRecordBatchIndex = -1;
            this.totalRecordBatch = resultChunk.batchOfVectors.size();
            this.currentRowInRecordBatch = -1;
            this.rowCountInCurrentRecordBatch = 0;
            this.dataConversionContext = conversionContext;
        }

        ArrowChunkIterator(EmptyArrowResultChunk emptyArrowResultChunk) {
            this.resultChunk = emptyArrowResultChunk;
            this.currentRecordBatchIndex = 0;
            this.totalRecordBatch = 0;
            this.currentRowInRecordBatch = -1;
            this.rowCountInCurrentRecordBatch = 0;
            this.currentConverters = Collections.emptyList();
            this.dataConversionContext = null;
        }

        public boolean next() {
            ++this.currentRowInRecordBatch;
            if (this.currentRowInRecordBatch < this.rowCountInCurrentRecordBatch) {
                return true;
            }
            ++this.currentRecordBatchIndex;
            if (this.currentRecordBatchIndex < this.totalRecordBatch) {
                this.currentRowInRecordBatch = 0;
                this.rowCountInCurrentRecordBatch = ((ValueVector)((List)this.resultChunk.batchOfVectors.get(this.currentRecordBatchIndex)).get(0)).getValueCount();
                this.currentConverters = ArrowResultChunk.initConverters((List)this.resultChunk.batchOfVectors.get(this.currentRecordBatchIndex), this.dataConversionContext);
                return true;
            }
            return false;
        }

        public boolean isLast() {
            return this.currentRecordBatchIndex + 1 == this.totalRecordBatch && this.currentRowInRecordBatch + 1 == this.rowCountInCurrentRecordBatch;
        }

        public boolean isAfterLast() {
            return this.currentRecordBatchIndex >= this.totalRecordBatch && this.currentRowInRecordBatch >= this.rowCountInCurrentRecordBatch;
        }

        public ArrowResultChunk getChunk() {
            return this.resultChunk;
        }

        public ArrowVectorConverter getCurrentConverter(int columnIndex) {
            return this.currentConverters.get(columnIndex);
        }

        public int getCurrentRowInRecordBatch() {
            return this.currentRowInRecordBatch;
        }
    }
}

