/*
 * Decompiled with CFR 0.152.
 */
package net.snowflake.client.jdbc.internal.apache.arrow.vector.complex.impl;

import java.math.BigDecimal;
import net.snowflake.client.jdbc.internal.apache.arrow.vector.DecimalVector;
import net.snowflake.client.jdbc.internal.apache.arrow.vector.complex.impl.AbstractFieldWriter;
import net.snowflake.client.jdbc.internal.apache.arrow.vector.holders.DecimalHolder;
import net.snowflake.client.jdbc.internal.apache.arrow.vector.holders.NullableDecimalHolder;
import net.snowflake.client.jdbc.internal.apache.arrow.vector.types.pojo.Field;
import net.snowflake.client.jdbc.internal.io.netty.buffer.ArrowBuf;

public class DecimalWriterImpl
extends AbstractFieldWriter {
    final DecimalVector vector;

    public DecimalWriterImpl(DecimalVector vector) {
        this.vector = vector;
    }

    @Override
    public Field getField() {
        return this.vector.getField();
    }

    @Override
    public int getValueCapacity() {
        return this.vector.getValueCapacity();
    }

    @Override
    public void allocate() {
        this.vector.allocateNew();
    }

    @Override
    public void close() {
        this.vector.close();
    }

    @Override
    public void clear() {
        this.vector.clear();
    }

    @Override
    protected int idx() {
        return super.idx();
    }

    @Override
    public void write(DecimalHolder h) {
        this.vector.setSafe(this.idx(), h);
        this.vector.setValueCount(this.idx() + 1);
    }

    public void write(NullableDecimalHolder h) {
        this.vector.setSafe(this.idx(), h);
        this.vector.setValueCount(this.idx() + 1);
    }

    @Override
    public void writeDecimal(int start, ArrowBuf buffer) {
        this.vector.setSafe(this.idx(), 1, start, buffer);
        this.vector.setValueCount(this.idx() + 1);
    }

    @Override
    public void writeDecimal(BigDecimal value) {
        this.vector.setSafe(this.idx(), value);
        this.vector.setValueCount(this.idx() + 1);
    }

    @Override
    public void writeBigEndianBytesToDecimal(byte[] value) {
        this.vector.setBigEndianSafe(this.idx(), value);
        this.vector.setValueCount(this.idx() + 1);
    }

    @Override
    public void writeNull() {
        this.vector.setNull(this.idx());
        this.vector.setValueCount(this.idx() + 1);
    }
}

