/*
 * Decompiled with CFR 0.152.
 */
package net.snowflake.client.jdbc.internal.apache.arrow.vector.dictionary;

import java.util.Objects;
import net.snowflake.client.jdbc.internal.apache.arrow.vector.FieldVector;
import net.snowflake.client.jdbc.internal.apache.arrow.vector.types.pojo.ArrowType;
import net.snowflake.client.jdbc.internal.apache.arrow.vector.types.pojo.DictionaryEncoding;

public class Dictionary {
    private final DictionaryEncoding encoding;
    private final FieldVector dictionary;

    public Dictionary(FieldVector dictionary, DictionaryEncoding encoding) {
        this.dictionary = dictionary;
        this.encoding = encoding;
    }

    public FieldVector getVector() {
        return this.dictionary;
    }

    public DictionaryEncoding getEncoding() {
        return this.encoding;
    }

    public ArrowType getVectorType() {
        return this.dictionary.getField().getType();
    }

    public String toString() {
        return "Dictionary " + this.encoding + " " + this.dictionary;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Dictionary that = (Dictionary)o;
        return Objects.equals(this.encoding, that.encoding) && Objects.equals(this.dictionary, that.dictionary);
    }

    public int hashCode() {
        return Objects.hash(this.encoding, this.dictionary);
    }
}

