/*
 * Decompiled with CFR 0.152.
 */
package net.snowflake.client.jdbc.internal.apache.arrow.vector;

import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import net.snowflake.client.jdbc.internal.apache.arrow.memory.BaseAllocator;
import net.snowflake.client.jdbc.internal.apache.arrow.memory.BufferAllocator;
import net.snowflake.client.jdbc.internal.apache.arrow.memory.OutOfMemoryException;
import net.snowflake.client.jdbc.internal.apache.arrow.vector.BaseValueVector;
import net.snowflake.client.jdbc.internal.apache.arrow.vector.BitVectorHelper;
import net.snowflake.client.jdbc.internal.apache.arrow.vector.BufferBacked;
import net.snowflake.client.jdbc.internal.apache.arrow.vector.FieldVector;
import net.snowflake.client.jdbc.internal.apache.arrow.vector.VariableWidthVector;
import net.snowflake.client.jdbc.internal.apache.arrow.vector.VectorDefinitionSetter;
import net.snowflake.client.jdbc.internal.apache.arrow.vector.ipc.message.ArrowFieldNode;
import net.snowflake.client.jdbc.internal.apache.arrow.vector.types.pojo.Field;
import net.snowflake.client.jdbc.internal.apache.arrow.vector.types.pojo.FieldType;
import net.snowflake.client.jdbc.internal.apache.arrow.vector.util.CallBack;
import net.snowflake.client.jdbc.internal.apache.arrow.vector.util.OversizedAllocationException;
import net.snowflake.client.jdbc.internal.apache.arrow.vector.util.TransferPair;
import net.snowflake.client.jdbc.internal.io.netty.buffer.ArrowBuf;

public abstract class BaseVariableWidthVector
extends BaseValueVector
implements VariableWidthVector,
FieldVector,
VectorDefinitionSetter {
    private static final int DEFAULT_RECORD_BYTE_COUNT = 8;
    private static final int INITIAL_BYTE_COUNT = 31760;
    private int lastValueCapacity = 3969;
    private int lastValueAllocationSizeInBytes = 31760;
    public static final int OFFSET_WIDTH = 4;
    protected static final byte[] emptyByteArray = new byte[0];
    protected ArrowBuf validityBuffer;
    protected ArrowBuf valueBuffer;
    protected ArrowBuf offsetBuffer;
    protected int valueCount;
    protected int lastSet;
    protected final Field field;

    public BaseVariableWidthVector(String name, BufferAllocator allocator, FieldType fieldType) {
        super(name, allocator);
        this.field = new Field(name, fieldType, null);
        this.valueCount = 0;
        this.lastSet = -1;
        this.offsetBuffer = allocator.getEmpty();
        this.validityBuffer = allocator.getEmpty();
        this.valueBuffer = allocator.getEmpty();
    }

    @Override
    public ArrowBuf getValidityBuffer() {
        return this.validityBuffer;
    }

    @Override
    public ArrowBuf getDataBuffer() {
        return this.valueBuffer;
    }

    @Override
    public ArrowBuf getOffsetBuffer() {
        return this.offsetBuffer;
    }

    @Override
    public long getOffsetBufferAddress() {
        return this.offsetBuffer.memoryAddress();
    }

    @Override
    public long getValidityBufferAddress() {
        return this.validityBuffer.memoryAddress();
    }

    @Override
    public long getDataBufferAddress() {
        return this.valueBuffer.memoryAddress();
    }

    @Override
    public void setInitialCapacity(int valueCount) {
        long size = (long)valueCount * 8L;
        this.checkDataBufferSize(size);
        this.computeAndCheckOffsetsBufferSize(valueCount);
        this.lastValueAllocationSizeInBytes = (int)size;
        this.lastValueCapacity = valueCount;
    }

    @Override
    public void setInitialCapacity(int valueCount, double density) {
        long size = Math.max((long)((double)valueCount * density), 1L);
        this.checkDataBufferSize(size);
        this.computeAndCheckOffsetsBufferSize(valueCount);
        this.lastValueAllocationSizeInBytes = (int)size;
        this.lastValueCapacity = valueCount;
    }

    public double getDensity() {
        if (this.valueCount == 0) {
            return 0.0;
        }
        int startOffset = this.offsetBuffer.getInt(0);
        int endOffset = this.offsetBuffer.getInt(this.valueCount * 4);
        double totalListSize = endOffset - startOffset;
        return totalListSize / (double)this.valueCount;
    }

    @Override
    public int getValueCapacity() {
        int offsetValueCapacity = Math.max(this.getOffsetBufferValueCapacity() - 1, 0);
        return Math.min(offsetValueCapacity, this.getValidityBufferValueCapacity());
    }

    private int getValidityBufferValueCapacity() {
        return (int)((long)this.validityBuffer.capacity() * 8L);
    }

    private int getOffsetBufferValueCapacity() {
        return (int)((double)this.offsetBuffer.capacity() * 1.0 / 4.0);
    }

    public void zeroVector() {
        this.initValidityBuffer();
        this.initOffsetBuffer();
        this.valueBuffer.setZero(0, this.valueBuffer.capacity());
    }

    private void initValidityBuffer() {
        this.validityBuffer.setZero(0, this.validityBuffer.capacity());
    }

    private void initOffsetBuffer() {
        this.offsetBuffer.setZero(0, this.offsetBuffer.capacity());
    }

    @Override
    public void reset() {
        this.zeroVector();
        this.lastSet = -1;
        this.valueCount = 0;
    }

    @Override
    public void close() {
        this.clear();
    }

    @Override
    public void clear() {
        this.validityBuffer = this.releaseBuffer(this.validityBuffer);
        this.valueBuffer = this.releaseBuffer(this.valueBuffer);
        this.offsetBuffer = this.releaseBuffer(this.offsetBuffer);
        this.lastSet = -1;
        this.valueCount = 0;
    }

    @Override
    @Deprecated
    public List<BufferBacked> getFieldInnerVectors() {
        throw new UnsupportedOperationException("There are no inner vectors. Use getFieldBuffers");
    }

    @Override
    public void initializeChildrenFromFields(List<Field> children) {
        if (!children.isEmpty()) {
            throw new IllegalArgumentException("primitive type vector can not have children");
        }
    }

    @Override
    public List<FieldVector> getChildrenFromFields() {
        return Collections.emptyList();
    }

    @Override
    public void loadFieldBuffers(ArrowFieldNode fieldNode, List<ArrowBuf> ownBuffers) {
        ArrowBuf bitBuffer = ownBuffers.get(0);
        ArrowBuf offBuffer = ownBuffers.get(1);
        ArrowBuf dataBuffer = ownBuffers.get(2);
        this.validityBuffer.release();
        this.validityBuffer = BitVectorHelper.loadValidityBuffer(fieldNode, bitBuffer, this.allocator);
        this.offsetBuffer.release();
        this.offsetBuffer = offBuffer.retain(this.allocator);
        this.valueBuffer.release();
        this.valueBuffer = dataBuffer.retain(this.allocator);
        this.lastSet = fieldNode.getLength() - 1;
        this.valueCount = fieldNode.getLength();
    }

    @Override
    public List<ArrowBuf> getFieldBuffers() {
        ArrayList<ArrowBuf> result = new ArrayList<ArrowBuf>(3);
        this.setReaderAndWriterIndex();
        result.add(this.validityBuffer);
        result.add(this.offsetBuffer);
        result.add(this.valueBuffer);
        return result;
    }

    private void setReaderAndWriterIndex() {
        this.validityBuffer.readerIndex(0);
        this.offsetBuffer.readerIndex(0);
        this.valueBuffer.readerIndex(0);
        if (this.valueCount == 0) {
            this.validityBuffer.writerIndex(0);
            this.offsetBuffer.writerIndex(0);
            this.valueBuffer.writerIndex(0);
        } else {
            int lastDataOffset = this.getstartOffset(this.valueCount);
            this.validityBuffer.writerIndex(BaseVariableWidthVector.getValidityBufferSizeFromCount(this.valueCount));
            this.offsetBuffer.writerIndex((this.valueCount + 1) * 4);
            this.valueBuffer.writerIndex(lastDataOffset);
        }
    }

    @Override
    public void allocateNew() {
        if (!this.allocateNewSafe()) {
            throw new OutOfMemoryException("Failure while allocating memory.");
        }
    }

    @Override
    public boolean allocateNewSafe() {
        this.checkDataBufferSize(this.lastValueAllocationSizeInBytes);
        this.computeAndCheckOffsetsBufferSize(this.lastValueCapacity);
        this.clear();
        try {
            this.allocateBytes(this.lastValueAllocationSizeInBytes, this.lastValueCapacity);
        }
        catch (Exception e) {
            this.clear();
            return false;
        }
        return true;
    }

    @Override
    public void allocateNew(int totalBytes, int valueCount) {
        assert (totalBytes >= 0);
        this.checkDataBufferSize(totalBytes);
        this.computeAndCheckOffsetsBufferSize(valueCount);
        this.clear();
        try {
            this.allocateBytes(totalBytes, valueCount);
        }
        catch (Exception e) {
            this.clear();
            throw e;
        }
    }

    private void checkDataBufferSize(long size) {
        if (size > (long)MAX_ALLOCATION_SIZE) {
            throw new OversizedAllocationException("Memory required for vector  is (" + size + "), which is more than max allowed (" + MAX_ALLOCATION_SIZE + ")");
        }
    }

    private long computeAndCheckOffsetsBufferSize(int valueCount) {
        long size = this.computeCombinedBufferSize(valueCount + 1, 4);
        if (size > (long)MAX_ALLOCATION_SIZE) {
            throw new OversizedAllocationException("Memory required for vector capacity " + valueCount + " is (" + size + "), which is more than max allowed (" + MAX_ALLOCATION_SIZE + ")");
        }
        return size;
    }

    private void allocateBytes(int valueBufferSize, int valueCount) {
        int curSize = valueBufferSize;
        this.valueBuffer = this.allocator.buffer(curSize);
        this.valueBuffer.readerIndex(0);
        BaseValueVector.DataAndValidityBuffers buffers = this.allocFixedDataAndValidityBufs(valueCount + 1, 4);
        this.offsetBuffer = buffers.getDataBuf();
        this.validityBuffer = buffers.getValidityBuf();
        this.initOffsetBuffer();
        this.initValidityBuffer();
        this.lastValueCapacity = this.getValueCapacity();
        this.lastValueAllocationSizeInBytes = this.valueBuffer.capacity();
    }

    private void allocateOffsetBuffer(long size) {
        int curSize = (int)size;
        this.offsetBuffer = this.allocator.buffer(curSize);
        this.offsetBuffer.readerIndex(0);
        this.initOffsetBuffer();
    }

    private void allocateValidityBuffer(long size) {
        int curSize = (int)size;
        this.validityBuffer = this.allocator.buffer(curSize);
        this.validityBuffer.readerIndex(0);
        this.initValidityBuffer();
    }

    @Override
    public void reAlloc() {
        this.reallocDataBuffer();
        this.reallocValidityAndOffsetBuffers();
    }

    public void reallocDataBuffer() {
        long baseSize = this.lastValueAllocationSizeInBytes;
        int currentBufferCapacity = this.valueBuffer.capacity();
        if (baseSize < (long)currentBufferCapacity) {
            baseSize = currentBufferCapacity;
        }
        long newAllocationSize = baseSize * 2L;
        newAllocationSize = BaseAllocator.nextPowerOfTwo(newAllocationSize);
        assert (newAllocationSize >= 1L);
        this.checkDataBufferSize(newAllocationSize);
        ArrowBuf newBuf = this.allocator.buffer((int)newAllocationSize);
        newBuf.setBytes(0, this.valueBuffer, 0, currentBufferCapacity);
        this.valueBuffer.release();
        this.valueBuffer = newBuf;
        this.lastValueAllocationSizeInBytes = this.valueBuffer.capacity();
    }

    public void reallocValidityAndOffsetBuffers() {
        int targetOffsetCount = this.offsetBuffer.capacity() / 4 * 2;
        if (targetOffsetCount == 0) {
            targetOffsetCount = this.lastValueCapacity > 0 ? 2 * (this.lastValueCapacity + 1) : 7942;
        }
        this.computeAndCheckOffsetsBufferSize(targetOffsetCount);
        BaseValueVector.DataAndValidityBuffers buffers = this.allocFixedDataAndValidityBufs(targetOffsetCount, 4);
        ArrowBuf newOffsetBuffer = buffers.getDataBuf();
        newOffsetBuffer.setBytes(0, this.offsetBuffer, 0, this.offsetBuffer.capacity());
        newOffsetBuffer.setZero(this.offsetBuffer.capacity(), newOffsetBuffer.capacity() - this.offsetBuffer.capacity());
        this.offsetBuffer.release();
        this.offsetBuffer = newOffsetBuffer;
        ArrowBuf newValidityBuffer = buffers.getValidityBuf();
        newValidityBuffer.setBytes(0, this.validityBuffer, 0, this.validityBuffer.capacity());
        newValidityBuffer.setZero(this.validityBuffer.capacity(), newValidityBuffer.capacity() - this.validityBuffer.capacity());
        this.validityBuffer.release();
        this.validityBuffer = newValidityBuffer;
        this.lastValueCapacity = this.getValueCapacity();
    }

    @Override
    public int getByteCapacity() {
        return this.valueBuffer.capacity();
    }

    @Override
    public int getCurrentSizeInBytes() {
        return 0;
    }

    @Override
    public int getBufferSize() {
        return this.getBufferSizeFor(this.valueCount);
    }

    @Override
    public int getBufferSizeFor(int valueCount) {
        if (valueCount == 0) {
            return 0;
        }
        int validityBufferSize = BaseVariableWidthVector.getValidityBufferSizeFromCount(valueCount);
        int offsetBufferSize = (valueCount + 1) * 4;
        int dataBufferSize = this.offsetBuffer.getInt(valueCount * 4);
        return validityBufferSize + offsetBufferSize + dataBufferSize;
    }

    @Override
    public Field getField() {
        return this.field;
    }

    @Override
    public ArrowBuf[] getBuffers(boolean clear) {
        this.setReaderAndWriterIndex();
        ArrowBuf[] buffers = this.getBufferSize() == 0 ? new ArrowBuf[]{} : new ArrowBuf[]{this.validityBuffer, this.offsetBuffer, this.valueBuffer};
        if (clear) {
            for (ArrowBuf buffer : buffers) {
                buffer.retain(1);
            }
            this.clear();
        }
        return buffers;
    }

    @Override
    public TransferPair getTransferPair(String ref, BufferAllocator allocator, CallBack callBack) {
        return this.getTransferPair(ref, allocator);
    }

    @Override
    public TransferPair getTransferPair(BufferAllocator allocator) {
        return this.getTransferPair(this.name, allocator);
    }

    @Override
    public abstract TransferPair getTransferPair(String var1, BufferAllocator var2);

    public void transferTo(BaseVariableWidthVector target) {
        this.compareTypes(target, "transferTo");
        target.clear();
        target.validityBuffer = this.validityBuffer.transferOwnership((BufferAllocator)target.allocator).buffer;
        target.valueBuffer = this.valueBuffer.transferOwnership((BufferAllocator)target.allocator).buffer;
        target.offsetBuffer = this.offsetBuffer.transferOwnership((BufferAllocator)target.allocator).buffer;
        target.setLastSet(this.lastSet);
        if (this.valueCount > 0) {
            target.setValueCount(this.valueCount);
        }
        this.clear();
    }

    public void splitAndTransferTo(int startIndex, int length, BaseVariableWidthVector target) {
        this.compareTypes(target, "splitAndTransferTo");
        target.clear();
        this.splitAndTransferValidityBuffer(startIndex, length, target);
        this.splitAndTransferOffsetBuffer(startIndex, length, target);
        target.setLastSet(length - 1);
        if (length > 0) {
            target.setValueCount(length);
        }
    }

    private void splitAndTransferOffsetBuffer(int startIndex, int length, BaseVariableWidthVector target) {
        int start = this.offsetBuffer.getInt(startIndex * 4);
        int end = this.offsetBuffer.getInt((startIndex + length) * 4);
        int dataLength = end - start;
        target.allocateOffsetBuffer((length + 1) * 4);
        for (int i = 0; i < length + 1; ++i) {
            int relativeSourceOffset = this.offsetBuffer.getInt((startIndex + i) * 4) - start;
            target.offsetBuffer.setInt(i * 4, relativeSourceOffset);
        }
        target.valueBuffer = this.valueBuffer.slice((int)start, (int)dataLength).transferOwnership((BufferAllocator)target.allocator).buffer;
    }

    private void splitAndTransferValidityBuffer(int startIndex, int length, BaseVariableWidthVector target) {
        assert (startIndex + length <= this.valueCount);
        int firstByteSource = BitVectorHelper.byteIndex(startIndex);
        int lastByteSource = BitVectorHelper.byteIndex(this.valueCount - 1);
        int byteSizeTarget = BaseVariableWidthVector.getValidityBufferSizeFromCount(length);
        int offset = startIndex % 8;
        if (length > 0) {
            if (offset == 0) {
                if (target.validityBuffer != null) {
                    target.validityBuffer.release();
                }
                target.validityBuffer = this.validityBuffer.slice(firstByteSource, byteSizeTarget);
                target.validityBuffer.retain(1);
            } else {
                byte b1;
                target.allocateValidityBuffer(byteSizeTarget);
                for (int i = 0; i < byteSizeTarget - 1; ++i) {
                    byte b12 = BitVectorHelper.getBitsFromCurrentByte(this.validityBuffer, firstByteSource + i, offset);
                    byte b2 = BitVectorHelper.getBitsFromNextByte(this.validityBuffer, firstByteSource + i + 1, offset);
                    target.validityBuffer.setByte(i, b12 + b2);
                }
                if (firstByteSource + byteSizeTarget - 1 < lastByteSource) {
                    b1 = BitVectorHelper.getBitsFromCurrentByte(this.validityBuffer, firstByteSource + byteSizeTarget - 1, offset);
                    byte b2 = BitVectorHelper.getBitsFromNextByte(this.validityBuffer, firstByteSource + byteSizeTarget, offset);
                    target.validityBuffer.setByte(byteSizeTarget - 1, b1 + b2);
                } else {
                    b1 = BitVectorHelper.getBitsFromCurrentByte(this.validityBuffer, firstByteSource + byteSizeTarget - 1, offset);
                    target.validityBuffer.setByte(byteSizeTarget - 1, b1);
                }
            }
        }
    }

    @Override
    public int getNullCount() {
        return BitVectorHelper.getNullCount(this.validityBuffer, this.valueCount);
    }

    public boolean isSafe(int index) {
        return index < this.getValueCapacity();
    }

    @Override
    public boolean isNull(int index) {
        return this.isSet(index) == 0;
    }

    public int isSet(int index) {
        int byteIndex = index >> 3;
        byte b = this.validityBuffer.getByte(byteIndex);
        int bitIndex = index & 7;
        return b >> bitIndex & 1;
    }

    @Override
    public int getValueCount() {
        return this.valueCount;
    }

    @Override
    public void setValueCount(int valueCount) {
        assert (valueCount >= 0);
        this.valueCount = valueCount;
        while (valueCount > this.getValueCapacity()) {
            this.reallocValidityAndOffsetBuffers();
        }
        this.fillHoles(valueCount);
        this.lastSet = valueCount - 1;
        this.setReaderAndWriterIndex();
    }

    public void fillEmpties(int index) {
        this.handleSafe(index, emptyByteArray.length);
        this.fillHoles(index);
        this.lastSet = index - 1;
    }

    public void setLastSet(int value) {
        this.lastSet = value;
    }

    public int getLastSet() {
        return this.lastSet;
    }

    public long getStartEnd(int index) {
        return this.offsetBuffer.getLong(index * 4);
    }

    @Override
    public void setIndexDefined(int index) {
        while (index >= this.getValidityBufferValueCapacity()) {
            this.reallocValidityAndOffsetBuffers();
        }
        BitVectorHelper.setValidityBitToOne(this.validityBuffer, index);
    }

    public void setValueLengthSafe(int index, int length) {
        assert (index >= 0);
        this.handleSafe(index, length);
        this.fillHoles(index);
        int startOffset = this.getstartOffset(index);
        this.offsetBuffer.setInt((index + 1) * 4, startOffset + length);
        this.lastSet = index;
    }

    public int getValueLength(int index) {
        assert (index >= 0);
        if (this.isSet(index) == 0) {
            return 0;
        }
        int startOffset = this.getstartOffset(index);
        int dataLength = this.offsetBuffer.getInt((index + 1) * 4) - startOffset;
        return dataLength;
    }

    public void set(int index, byte[] value) {
        assert (index >= 0);
        this.fillHoles(index);
        BitVectorHelper.setValidityBitToOne(this.validityBuffer, index);
        this.setBytes(index, value, 0, value.length);
        this.lastSet = index;
    }

    public void setSafe(int index, byte[] value) {
        assert (index >= 0);
        this.fillEmpties(index);
        this.handleSafe(index, value.length);
        BitVectorHelper.setValidityBitToOne(this.validityBuffer, index);
        this.setBytes(index, value, 0, value.length);
        this.lastSet = index;
    }

    public void set(int index, byte[] value, int start, int length) {
        assert (index >= 0);
        this.fillHoles(index);
        BitVectorHelper.setValidityBitToOne(this.validityBuffer, index);
        this.setBytes(index, value, start, length);
        this.lastSet = index;
    }

    public void setSafe(int index, byte[] value, int start, int length) {
        assert (index >= 0);
        this.fillEmpties(index);
        this.handleSafe(index, length);
        BitVectorHelper.setValidityBitToOne(this.validityBuffer, index);
        this.setBytes(index, value, start, length);
        this.lastSet = index;
    }

    public void set(int index, ByteBuffer value, int start, int length) {
        assert (index >= 0);
        this.fillHoles(index);
        BitVectorHelper.setValidityBitToOne(this.validityBuffer, index);
        int startOffset = this.getstartOffset(index);
        this.offsetBuffer.setInt((index + 1) * 4, startOffset + length);
        this.valueBuffer.setBytes(startOffset, value, start, length);
        this.lastSet = index;
    }

    public void setSafe(int index, ByteBuffer value, int start, int length) {
        assert (index >= 0);
        this.fillEmpties(index);
        this.handleSafe(index, length);
        BitVectorHelper.setValidityBitToOne(this.validityBuffer, index);
        int startOffset = this.getstartOffset(index);
        this.offsetBuffer.setInt((index + 1) * 4, startOffset + length);
        this.valueBuffer.setBytes(startOffset, value, start, length);
        this.lastSet = index;
    }

    public void setNull(int index) {
        while (index >= this.getValidityBufferValueCapacity()) {
            this.reallocValidityAndOffsetBuffers();
        }
        BitVectorHelper.setValidityBit(this.validityBuffer, index, 0);
    }

    public void set(int index, int isSet, int start, int end, ArrowBuf buffer) {
        assert (index >= 0);
        int dataLength = end - start;
        this.fillHoles(index);
        BitVectorHelper.setValidityBit(this.validityBuffer, index, isSet);
        int startOffset = this.offsetBuffer.getInt(index * 4);
        this.offsetBuffer.setInt((index + 1) * 4, startOffset + dataLength);
        this.valueBuffer.setBytes(startOffset, buffer, start, dataLength);
        this.lastSet = index;
    }

    public void setSafe(int index, int isSet, int start, int end, ArrowBuf buffer) {
        assert (index >= 0);
        int dataLength = end - start;
        this.fillEmpties(index);
        this.handleSafe(index, dataLength);
        BitVectorHelper.setValidityBit(this.validityBuffer, index, isSet);
        int startOffset = this.offsetBuffer.getInt(index * 4);
        this.offsetBuffer.setInt((index + 1) * 4, startOffset + dataLength);
        this.valueBuffer.setBytes(startOffset, buffer, start, dataLength);
        this.lastSet = index;
    }

    public void set(int index, int start, int length, ArrowBuf buffer) {
        assert (index >= 0);
        this.fillHoles(index);
        BitVectorHelper.setValidityBitToOne(this.validityBuffer, index);
        int startOffset = this.offsetBuffer.getInt(index * 4);
        this.offsetBuffer.setInt((index + 1) * 4, startOffset + length);
        ArrowBuf bb = buffer.slice(start, length);
        this.valueBuffer.setBytes(startOffset, bb);
        this.lastSet = index;
    }

    public void setSafe(int index, int start, int length, ArrowBuf buffer) {
        assert (index >= 0);
        this.fillEmpties(index);
        this.handleSafe(index, length);
        BitVectorHelper.setValidityBitToOne(this.validityBuffer, index);
        int startOffset = this.offsetBuffer.getInt(index * 4);
        this.offsetBuffer.setInt((index + 1) * 4, startOffset + length);
        ArrowBuf bb = buffer.slice(start, length);
        this.valueBuffer.setBytes(startOffset, bb);
        this.lastSet = index;
    }

    protected final void fillHoles(int index) {
        for (int i = this.lastSet + 1; i < index; ++i) {
            this.setBytes(i, emptyByteArray, 0, emptyByteArray.length);
        }
        this.lastSet = index - 1;
    }

    protected final void setBytes(int index, byte[] value, int start, int length) {
        int startOffset = this.getstartOffset(index);
        this.offsetBuffer.setInt((index + 1) * 4, startOffset + length);
        this.valueBuffer.setBytes(startOffset, value, start, length);
    }

    protected final int getstartOffset(int index) {
        return this.offsetBuffer.getInt(index * 4);
    }

    protected final void handleSafe(int index, int dataLength) {
        while (index >= this.getValueCapacity()) {
            this.reallocValidityAndOffsetBuffers();
        }
        int startOffset = this.getstartOffset(index);
        while (this.valueBuffer.capacity() < startOffset + dataLength) {
            this.reallocDataBuffer();
        }
    }

    public static byte[] get(ArrowBuf data, ArrowBuf offset, int index) {
        int currentStartOffset = offset.getInt(index * 4);
        int dataLength = offset.getInt((index + 1) * 4) - currentStartOffset;
        byte[] result = new byte[dataLength];
        data.getBytes(currentStartOffset, result, 0, dataLength);
        return result;
    }

    public static ArrowBuf set(ArrowBuf buffer, BufferAllocator allocator, int valueCount, int index, int value) {
        if (buffer == null) {
            buffer = allocator.buffer(valueCount * 4);
        }
        buffer.setInt(index * 4, value);
        if (index == valueCount - 1) {
            buffer.writerIndex(valueCount * 4);
        }
        return buffer;
    }
}

