/*
 * Decompiled with CFR 0.152.
 */
package net.snowflake.client.jdbc.internal.apache.arrow.vector;

import java.time.LocalDateTime;
import net.snowflake.client.jdbc.internal.apache.arrow.memory.BufferAllocator;
import net.snowflake.client.jdbc.internal.apache.arrow.vector.BaseFixedWidthVector;
import net.snowflake.client.jdbc.internal.apache.arrow.vector.BitVectorHelper;
import net.snowflake.client.jdbc.internal.apache.arrow.vector.ValueVector;
import net.snowflake.client.jdbc.internal.apache.arrow.vector.complex.impl.DateMilliReaderImpl;
import net.snowflake.client.jdbc.internal.apache.arrow.vector.complex.reader.FieldReader;
import net.snowflake.client.jdbc.internal.apache.arrow.vector.holders.DateMilliHolder;
import net.snowflake.client.jdbc.internal.apache.arrow.vector.holders.NullableDateMilliHolder;
import net.snowflake.client.jdbc.internal.apache.arrow.vector.types.Types;
import net.snowflake.client.jdbc.internal.apache.arrow.vector.types.pojo.FieldType;
import net.snowflake.client.jdbc.internal.apache.arrow.vector.util.DateUtility;
import net.snowflake.client.jdbc.internal.apache.arrow.vector.util.TransferPair;
import net.snowflake.client.jdbc.internal.io.netty.buffer.ArrowBuf;

public class DateMilliVector
extends BaseFixedWidthVector {
    private static final byte TYPE_WIDTH = 8;
    private final FieldReader reader = new DateMilliReaderImpl(this);

    public DateMilliVector(String name, BufferAllocator allocator) {
        this(name, FieldType.nullable(Types.MinorType.DATEMILLI.getType()), allocator);
    }

    public DateMilliVector(String name, FieldType fieldType, BufferAllocator allocator) {
        super(name, allocator, fieldType, 8);
    }

    @Override
    public FieldReader getReader() {
        return this.reader;
    }

    @Override
    public Types.MinorType getMinorType() {
        return Types.MinorType.DATEMILLI;
    }

    public long get(int index) throws IllegalStateException {
        if (this.isSet(index) == 0) {
            throw new IllegalStateException("Value at index is null");
        }
        return this.valueBuffer.getLong(index * 8);
    }

    public void get(int index, NullableDateMilliHolder holder) {
        if (this.isSet(index) == 0) {
            holder.isSet = 0;
            return;
        }
        holder.isSet = 1;
        holder.value = this.valueBuffer.getLong(index * 8);
    }

    @Override
    public LocalDateTime getObject(int index) {
        if (this.isSet(index) == 0) {
            return null;
        }
        long millis = this.valueBuffer.getLong(index * 8);
        return DateUtility.getLocalDateTimeFromEpochMilli(millis);
    }

    public void copyFrom(int fromIndex, int thisIndex, DateMilliVector from) {
        BitVectorHelper.setValidityBit(this.validityBuffer, thisIndex, from.isSet(fromIndex));
        long value = from.valueBuffer.getLong(fromIndex * 8);
        this.valueBuffer.setLong(thisIndex * 8, value);
    }

    public void copyFromSafe(int fromIndex, int thisIndex, DateMilliVector from) {
        this.handleSafe(thisIndex);
        this.copyFrom(fromIndex, thisIndex, from);
    }

    private void setValue(int index, long value) {
        this.valueBuffer.setLong(index * 8, value);
    }

    public void set(int index, long value) {
        BitVectorHelper.setValidityBitToOne(this.validityBuffer, index);
        this.setValue(index, value);
    }

    public void set(int index, NullableDateMilliHolder holder) throws IllegalArgumentException {
        if (holder.isSet < 0) {
            throw new IllegalArgumentException();
        }
        if (holder.isSet > 0) {
            BitVectorHelper.setValidityBitToOne(this.validityBuffer, index);
            this.setValue(index, holder.value);
        } else {
            BitVectorHelper.setValidityBit(this.validityBuffer, index, 0);
        }
    }

    public void set(int index, DateMilliHolder holder) {
        BitVectorHelper.setValidityBitToOne(this.validityBuffer, index);
        this.setValue(index, holder.value);
    }

    public void setSafe(int index, long value) {
        this.handleSafe(index);
        this.set(index, value);
    }

    public void setSafe(int index, NullableDateMilliHolder holder) throws IllegalArgumentException {
        this.handleSafe(index);
        this.set(index, holder);
    }

    public void setSafe(int index, DateMilliHolder holder) {
        this.handleSafe(index);
        this.set(index, holder);
    }

    public void setNull(int index) {
        this.handleSafe(index);
        BitVectorHelper.setValidityBit(this.validityBuffer, index, 0);
    }

    public void set(int index, int isSet, long value) {
        if (isSet > 0) {
            this.set(index, value);
        } else {
            BitVectorHelper.setValidityBit(this.validityBuffer, index, 0);
        }
    }

    public void setSafe(int index, int isSet, long value) {
        this.handleSafe(index);
        this.set(index, isSet, value);
    }

    public static long get(ArrowBuf buffer, int index) {
        return buffer.getLong(index * 8);
    }

    @Override
    public TransferPair getTransferPair(String ref, BufferAllocator allocator) {
        return new TransferImpl(ref, allocator);
    }

    @Override
    public TransferPair makeTransferPair(ValueVector to) {
        return new TransferImpl((DateMilliVector)to);
    }

    private class TransferImpl
    implements TransferPair {
        DateMilliVector to;

        public TransferImpl(String ref, BufferAllocator allocator) {
            this.to = new DateMilliVector(ref, DateMilliVector.this.field.getFieldType(), allocator);
        }

        public TransferImpl(DateMilliVector to) {
            this.to = to;
        }

        @Override
        public DateMilliVector getTo() {
            return this.to;
        }

        @Override
        public void transfer() {
            DateMilliVector.this.transferTo(this.to);
        }

        @Override
        public void splitAndTransfer(int startIndex, int length) {
            DateMilliVector.this.splitAndTransferTo(startIndex, length, this.to);
        }

        @Override
        public void copyValueSafe(int fromIndex, int toIndex) {
            this.to.copyFromSafe(fromIndex, toIndex, DateMilliVector.this);
        }
    }
}

