/*
 * Decompiled with CFR 0.152.
 */
package net.snowflake.client.jdbc.internal.apache.arrow.vector;

import java.math.BigDecimal;
import net.snowflake.client.jdbc.internal.apache.arrow.memory.BufferAllocator;
import net.snowflake.client.jdbc.internal.apache.arrow.vector.BaseFixedWidthVector;
import net.snowflake.client.jdbc.internal.apache.arrow.vector.BitVectorHelper;
import net.snowflake.client.jdbc.internal.apache.arrow.vector.ValueVector;
import net.snowflake.client.jdbc.internal.apache.arrow.vector.complex.impl.DecimalReaderImpl;
import net.snowflake.client.jdbc.internal.apache.arrow.vector.complex.reader.FieldReader;
import net.snowflake.client.jdbc.internal.apache.arrow.vector.holders.DecimalHolder;
import net.snowflake.client.jdbc.internal.apache.arrow.vector.holders.NullableDecimalHolder;
import net.snowflake.client.jdbc.internal.apache.arrow.vector.types.Types;
import net.snowflake.client.jdbc.internal.apache.arrow.vector.types.pojo.ArrowType;
import net.snowflake.client.jdbc.internal.apache.arrow.vector.types.pojo.FieldType;
import net.snowflake.client.jdbc.internal.apache.arrow.vector.util.DecimalUtility;
import net.snowflake.client.jdbc.internal.apache.arrow.vector.util.TransferPair;
import net.snowflake.client.jdbc.internal.io.netty.buffer.ArrowBuf;

public class DecimalVector
extends BaseFixedWidthVector {
    public static final byte TYPE_WIDTH = 16;
    private final FieldReader reader;
    private final int precision;
    private final int scale;

    public DecimalVector(String name, BufferAllocator allocator, int precision, int scale) {
        this(name, FieldType.nullable(new ArrowType.Decimal(precision, scale)), allocator);
    }

    public DecimalVector(String name, FieldType fieldType, BufferAllocator allocator) {
        super(name, allocator, fieldType, 16);
        ArrowType.Decimal arrowType = (ArrowType.Decimal)fieldType.getType();
        this.reader = new DecimalReaderImpl(this);
        this.precision = arrowType.getPrecision();
        this.scale = arrowType.getScale();
    }

    @Override
    public FieldReader getReader() {
        return this.reader;
    }

    @Override
    public Types.MinorType getMinorType() {
        return Types.MinorType.DECIMAL;
    }

    public ArrowBuf get(int index) throws IllegalStateException {
        if (this.isSet(index) == 0) {
            throw new IllegalStateException("Value at index is null");
        }
        return this.valueBuffer.slice(index * 16, 16);
    }

    public void get(int index, NullableDecimalHolder holder) {
        if (this.isSet(index) == 0) {
            holder.isSet = 0;
            return;
        }
        holder.isSet = 1;
        holder.buffer = this.valueBuffer;
        holder.precision = this.precision;
        holder.scale = this.scale;
        holder.start = index * 16;
    }

    @Override
    public BigDecimal getObject(int index) {
        if (this.isSet(index) == 0) {
            return null;
        }
        return DecimalUtility.getBigDecimalFromArrowBuf(this.valueBuffer, index, this.scale);
    }

    public void copyFrom(int fromIndex, int thisIndex, DecimalVector from) {
        BitVectorHelper.setValidityBit(this.validityBuffer, thisIndex, from.isSet(fromIndex));
        from.valueBuffer.getBytes(fromIndex * 16, this.valueBuffer, thisIndex * 16, 16);
    }

    public void copyFromSafe(int fromIndex, int thisIndex, DecimalVector from) {
        this.handleSafe(thisIndex);
        this.copyFrom(fromIndex, thisIndex, from);
    }

    public int getScale() {
        return this.scale;
    }

    public void set(int index, ArrowBuf buffer) {
        BitVectorHelper.setValidityBitToOne(this.validityBuffer, index);
        this.valueBuffer.setBytes(index * 16, buffer, 0, 16);
    }

    public void setBigEndian(int index, byte[] value) {
        BitVectorHelper.setValidityBitToOne(this.validityBuffer, index);
        int length = value.length;
        int startIndex = index * 16;
        if (length == 16) {
            for (int i = 15; i >= 3; i -= 4) {
                this.valueBuffer.setByte(startIndex, value[i]);
                this.valueBuffer.setByte(startIndex + 1, value[i - 1]);
                this.valueBuffer.setByte(startIndex + 2, value[i - 2]);
                this.valueBuffer.setByte(startIndex + 3, value[i - 3]);
                startIndex += 4;
            }
            return;
        }
        if (length == 0) {
            this.valueBuffer.setZero(startIndex, 16);
            return;
        }
        if (length < 16) {
            for (int i = length - 1; i >= 0; --i) {
                this.valueBuffer.setByte(startIndex, value[i]);
                ++startIndex;
            }
            byte pad = (byte)(value[0] < 0 ? 255 : 0);
            int maxStartIndex = (index + 1) * 16;
            while (startIndex < maxStartIndex) {
                this.valueBuffer.setByte(startIndex, pad);
                ++startIndex;
            }
            return;
        }
        throw new IllegalArgumentException("Invalid decimal value length. Valid length in [1 - 16], got " + length);
    }

    public void set(int index, int start, ArrowBuf buffer) {
        BitVectorHelper.setValidityBitToOne(this.validityBuffer, index);
        this.valueBuffer.setBytes(index * 16, buffer, start, 16);
    }

    public void setSafe(int index, int start, ArrowBuf buffer, int length) {
        this.handleSafe(index);
        BitVectorHelper.setValidityBitToOne(this.validityBuffer, index);
        int startIndexInVector = index * 16;
        this.valueBuffer.setBytes(startIndexInVector, buffer, start, length);
        if (length < 16) {
            byte msb = buffer.getByte(start + length - 1);
            byte pad = (byte)(msb < 0 ? 255 : 0);
            int startIndex = startIndexInVector + length;
            int endIndex = startIndexInVector + 16;
            for (int i = startIndex; i < endIndex; ++i) {
                this.valueBuffer.setByte(i, pad);
            }
        }
    }

    public void setBigEndianSafe(int index, int start, ArrowBuf buffer, int length) {
        this.handleSafe(index);
        BitVectorHelper.setValidityBitToOne(this.validityBuffer, index);
        int startIndexInVector = index * 16;
        for (int i = start + length - 1; i >= start; --i) {
            this.valueBuffer.setByte(startIndexInVector, buffer.getByte(i));
            ++startIndexInVector;
        }
        if (length < 16) {
            byte msb = buffer.getByte(start);
            byte pad = (byte)(msb < 0 ? 255 : 0);
            int endIndex = startIndexInVector + 16 - length;
            for (int i = startIndexInVector; i < endIndex; ++i) {
                this.valueBuffer.setByte(i, pad);
            }
        }
    }

    public void set(int index, BigDecimal value) {
        BitVectorHelper.setValidityBitToOne(this.validityBuffer, index);
        DecimalUtility.checkPrecisionAndScale(value, this.precision, this.scale);
        DecimalUtility.writeBigDecimalToArrowBuf(value, this.valueBuffer, index);
    }

    public void set(int index, NullableDecimalHolder holder) throws IllegalArgumentException {
        if (holder.isSet < 0) {
            throw new IllegalArgumentException();
        }
        if (holder.isSet > 0) {
            BitVectorHelper.setValidityBitToOne(this.validityBuffer, index);
            this.valueBuffer.setBytes(index * 16, holder.buffer, holder.start, 16);
        } else {
            BitVectorHelper.setValidityBit(this.validityBuffer, index, 0);
        }
    }

    public void set(int index, DecimalHolder holder) {
        BitVectorHelper.setValidityBitToOne(this.validityBuffer, index);
        this.valueBuffer.setBytes(index * 16, holder.buffer, holder.start, 16);
    }

    public void setSafe(int index, ArrowBuf buffer) {
        this.handleSafe(index);
        this.set(index, buffer);
    }

    public void setBigEndianSafe(int index, byte[] value) {
        this.handleSafe(index);
        this.setBigEndian(index, value);
    }

    public void setSafe(int index, int start, ArrowBuf buffer) {
        this.handleSafe(index);
        this.set(index, start, buffer);
    }

    public void setSafe(int index, BigDecimal value) {
        this.handleSafe(index);
        this.set(index, value);
    }

    public void setSafe(int index, NullableDecimalHolder holder) throws IllegalArgumentException {
        this.handleSafe(index);
        this.set(index, holder);
    }

    public void setSafe(int index, DecimalHolder holder) {
        this.handleSafe(index);
        this.set(index, holder);
    }

    public void setNull(int index) {
        this.handleSafe(index);
        BitVectorHelper.setValidityBit(this.validityBuffer, index, 0);
    }

    public void set(int index, int isSet, int start, ArrowBuf buffer) {
        if (isSet > 0) {
            this.set(index, start, buffer);
        } else {
            BitVectorHelper.setValidityBit(this.validityBuffer, index, 0);
        }
    }

    public void setSafe(int index, int isSet, int start, ArrowBuf buffer) {
        this.handleSafe(index);
        this.set(index, isSet, start, buffer);
    }

    @Override
    public TransferPair getTransferPair(String ref, BufferAllocator allocator) {
        return new TransferImpl(ref, allocator);
    }

    @Override
    public TransferPair makeTransferPair(ValueVector to) {
        return new TransferImpl((DecimalVector)to);
    }

    private class TransferImpl
    implements TransferPair {
        DecimalVector to;

        public TransferImpl(String ref, BufferAllocator allocator) {
            this.to = new DecimalVector(ref, allocator, DecimalVector.this.precision, DecimalVector.this.scale);
        }

        public TransferImpl(DecimalVector to) {
            this.to = to;
        }

        @Override
        public DecimalVector getTo() {
            return this.to;
        }

        @Override
        public void transfer() {
            DecimalVector.this.transferTo(this.to);
        }

        @Override
        public void splitAndTransfer(int startIndex, int length) {
            DecimalVector.this.splitAndTransferTo(startIndex, length, this.to);
        }

        @Override
        public void copyValueSafe(int fromIndex, int toIndex) {
            this.to.copyFromSafe(fromIndex, toIndex, DecimalVector.this);
        }
    }
}

