/*
 * Decompiled with CFR 0.152.
 */
package net.snowflake.client.jdbc.internal.apache.arrow.vector.util;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import net.snowflake.client.jdbc.internal.apache.arrow.memory.BufferAllocator;
import net.snowflake.client.jdbc.internal.apache.arrow.vector.FieldVector;
import net.snowflake.client.jdbc.internal.apache.arrow.vector.dictionary.Dictionary;
import net.snowflake.client.jdbc.internal.apache.arrow.vector.dictionary.DictionaryProvider;
import net.snowflake.client.jdbc.internal.apache.arrow.vector.types.pojo.ArrowType;
import net.snowflake.client.jdbc.internal.apache.arrow.vector.types.pojo.DictionaryEncoding;
import net.snowflake.client.jdbc.internal.apache.arrow.vector.types.pojo.Field;
import net.snowflake.client.jdbc.internal.apache.arrow.vector.types.pojo.FieldType;

public class DictionaryUtility {
    public static Field toMessageFormat(Field field, DictionaryProvider provider, Set<Long> dictionaryIdsUsed) {
        ArrowType type;
        DictionaryEncoding encoding = field.getDictionary();
        List<Field> children = field.getChildren();
        if (encoding == null && children.isEmpty()) {
            return field;
        }
        ArrayList<Field> updatedChildren = new ArrayList<Field>(children.size());
        for (Field child : children) {
            updatedChildren.add(DictionaryUtility.toMessageFormat(child, provider, dictionaryIdsUsed));
        }
        if (encoding == null) {
            type = field.getType();
        } else {
            long id = encoding.getId();
            Dictionary dictionary = provider.lookup(id);
            if (dictionary == null) {
                throw new IllegalArgumentException("Could not find dictionary with ID " + id);
            }
            type = dictionary.getVectorType();
            dictionaryIdsUsed.add(id);
        }
        return new Field(field.getName(), new FieldType(field.isNullable(), type, encoding, field.getMetadata()), updatedChildren);
    }

    public static Field toMemoryFormat(Field field, BufferAllocator allocator, Map<Long, Dictionary> dictionaries) {
        ArrowType type;
        DictionaryEncoding encoding = field.getDictionary();
        List<Field> children = field.getChildren();
        if (encoding == null && children.isEmpty()) {
            return field;
        }
        ArrayList<Field> updatedChildren = new ArrayList<Field>(children.size());
        for (Field child : children) {
            updatedChildren.add(DictionaryUtility.toMemoryFormat(child, allocator, dictionaries));
        }
        if (encoding == null) {
            type = field.getType();
        } else {
            type = encoding.getIndexType();
            if (type == null) {
                type = new ArrowType.Int(32, true);
            }
            if (!dictionaries.containsKey(encoding.getId())) {
                String dictName = "DICT" + encoding.getId();
                Field dictionaryField = new Field(dictName, new FieldType(false, field.getType(), null, null), children);
                FieldVector dictionaryVector = dictionaryField.createVector(allocator);
                dictionaries.put(encoding.getId(), new Dictionary(dictionaryVector, encoding));
            }
        }
        return new Field(field.getName(), new FieldType(field.isNullable(), type, encoding, field.getMetadata()), updatedChildren);
    }
}

