/*
 * Decompiled with CFR 0.152.
 */
package net.snowflake.client.jdbc.internal.com.carrotsearch.hppc;

import net.snowflake.client.jdbc.internal.com.carrotsearch.hppc.BitMixer;
import net.snowflake.client.jdbc.internal.com.carrotsearch.hppc.ByteFloatHashMap;
import net.snowflake.client.jdbc.internal.com.carrotsearch.hppc.HashOrderMixing;

public class ByteFloatScatterMap
extends ByteFloatHashMap {
    public ByteFloatScatterMap() {
        this(4);
    }

    public ByteFloatScatterMap(int expectedElements) {
        this(expectedElements, 0.75);
    }

    public ByteFloatScatterMap(int expectedElements, double loadFactor) {
        super(expectedElements, loadFactor, HashOrderMixing.none());
    }

    @Override
    protected int hashKey(byte key) {
        return BitMixer.mixPhi(key);
    }

    public static ByteFloatScatterMap from(byte[] keys, float[] values) {
        if (keys.length != values.length) {
            throw new IllegalArgumentException("Arrays of keys and values must have an identical length.");
        }
        ByteFloatScatterMap map = new ByteFloatScatterMap(keys.length);
        for (int i = 0; i < keys.length; ++i) {
            map.put(keys[i], values[i]);
        }
        return map;
    }
}

