/*
 * Decompiled with CFR 0.152.
 */
package net.snowflake.client.jdbc.internal.com.carrotsearch.hppc;

import net.snowflake.client.jdbc.internal.com.carrotsearch.hppc.BitMixer;
import net.snowflake.client.jdbc.internal.com.carrotsearch.hppc.FloatByteHashMap;
import net.snowflake.client.jdbc.internal.com.carrotsearch.hppc.HashOrderMixing;

public class FloatByteScatterMap
extends FloatByteHashMap {
    public FloatByteScatterMap() {
        this(4);
    }

    public FloatByteScatterMap(int expectedElements) {
        this(expectedElements, 0.75);
    }

    public FloatByteScatterMap(int expectedElements, double loadFactor) {
        super(expectedElements, loadFactor, HashOrderMixing.none());
    }

    @Override
    protected int hashKey(float key) {
        return BitMixer.mixPhi(key);
    }

    public static FloatByteScatterMap from(float[] keys, byte[] values) {
        if (keys.length != values.length) {
            throw new IllegalArgumentException("Arrays of keys and values must have an identical length.");
        }
        FloatByteScatterMap map = new FloatByteScatterMap(keys.length);
        for (int i = 0; i < keys.length; ++i) {
            map.put(keys[i], values[i]);
        }
        return map;
    }
}

