/*
 * Decompiled with CFR 0.152.
 */
package net.snowflake.client.jdbc.internal.org.bouncycastle.cms.jcajce;

import java.io.IOException;
import java.security.AlgorithmParameters;
import java.security.GeneralSecurityException;
import java.security.Key;
import java.security.KeyPair;
import java.security.KeyPairGenerator;
import java.security.PrivateKey;
import java.security.Provider;
import java.security.PublicKey;
import java.security.SecureRandom;
import java.security.cert.CertificateEncodingException;
import java.security.cert.X509Certificate;
import java.security.spec.AlgorithmParameterSpec;
import java.util.ArrayList;
import java.util.List;
import javax.crypto.Cipher;
import javax.crypto.KeyAgreement;
import javax.crypto.SecretKey;
import net.snowflake.client.jdbc.internal.org.bouncycastle.asn1.ASN1EncodableVector;
import net.snowflake.client.jdbc.internal.org.bouncycastle.asn1.ASN1ObjectIdentifier;
import net.snowflake.client.jdbc.internal.org.bouncycastle.asn1.ASN1Sequence;
import net.snowflake.client.jdbc.internal.org.bouncycastle.asn1.DEROctetString;
import net.snowflake.client.jdbc.internal.org.bouncycastle.asn1.DERSequence;
import net.snowflake.client.jdbc.internal.org.bouncycastle.asn1.cms.KeyAgreeRecipientIdentifier;
import net.snowflake.client.jdbc.internal.org.bouncycastle.asn1.cms.OriginatorPublicKey;
import net.snowflake.client.jdbc.internal.org.bouncycastle.asn1.cms.RecipientEncryptedKey;
import net.snowflake.client.jdbc.internal.org.bouncycastle.asn1.cms.RecipientKeyIdentifier;
import net.snowflake.client.jdbc.internal.org.bouncycastle.asn1.cms.ecc.MQVuserKeyingMaterial;
import net.snowflake.client.jdbc.internal.org.bouncycastle.asn1.pkcs.PKCSObjectIdentifiers;
import net.snowflake.client.jdbc.internal.org.bouncycastle.asn1.x509.AlgorithmIdentifier;
import net.snowflake.client.jdbc.internal.org.bouncycastle.asn1.x509.SubjectPublicKeyInfo;
import net.snowflake.client.jdbc.internal.org.bouncycastle.cms.CMSException;
import net.snowflake.client.jdbc.internal.org.bouncycastle.cms.KeyAgreeRecipientInfoGenerator;
import net.snowflake.client.jdbc.internal.org.bouncycastle.cms.jcajce.CMSUtils;
import net.snowflake.client.jdbc.internal.org.bouncycastle.cms.jcajce.DefaultJcaJceExtHelper;
import net.snowflake.client.jdbc.internal.org.bouncycastle.cms.jcajce.EnvelopedDataHelper;
import net.snowflake.client.jdbc.internal.org.bouncycastle.cms.jcajce.KeyMaterialGenerator;
import net.snowflake.client.jdbc.internal.org.bouncycastle.cms.jcajce.NamedJcaJceExtHelper;
import net.snowflake.client.jdbc.internal.org.bouncycastle.cms.jcajce.ProviderJcaJceExtHelper;
import net.snowflake.client.jdbc.internal.org.bouncycastle.cms.jcajce.RFC5753KeyMaterialGenerator;
import net.snowflake.client.jdbc.internal.org.bouncycastle.jcajce.spec.MQVParameterSpec;
import net.snowflake.client.jdbc.internal.org.bouncycastle.jcajce.spec.UserKeyingMaterialSpec;
import net.snowflake.client.jdbc.internal.org.bouncycastle.operator.DefaultSecretKeySizeProvider;
import net.snowflake.client.jdbc.internal.org.bouncycastle.operator.GenericKey;
import net.snowflake.client.jdbc.internal.org.bouncycastle.operator.SecretKeySizeProvider;
import net.snowflake.client.jdbc.internal.org.bouncycastle.util.Arrays;

public class JceKeyAgreeRecipientInfoGenerator
extends KeyAgreeRecipientInfoGenerator {
    private SecretKeySizeProvider keySizeProvider = new DefaultSecretKeySizeProvider();
    private List recipientIDs = new ArrayList();
    private List recipientKeys = new ArrayList();
    private PublicKey senderPublicKey;
    private PrivateKey senderPrivateKey;
    private EnvelopedDataHelper helper = new EnvelopedDataHelper(new DefaultJcaJceExtHelper());
    private SecureRandom random;
    private KeyPair ephemeralKP;
    private byte[] userKeyingMaterial;
    private static KeyMaterialGenerator ecc_cms_Generator = new RFC5753KeyMaterialGenerator();

    public JceKeyAgreeRecipientInfoGenerator(ASN1ObjectIdentifier keyAgreementOID, PrivateKey senderPrivateKey, PublicKey senderPublicKey, ASN1ObjectIdentifier keyEncryptionOID) {
        super(keyAgreementOID, SubjectPublicKeyInfo.getInstance(senderPublicKey.getEncoded()), keyEncryptionOID);
        this.senderPublicKey = senderPublicKey;
        this.senderPrivateKey = senderPrivateKey;
    }

    public JceKeyAgreeRecipientInfoGenerator setUserKeyingMaterial(byte[] userKeyingMaterial) {
        this.userKeyingMaterial = Arrays.clone(userKeyingMaterial);
        return this;
    }

    public JceKeyAgreeRecipientInfoGenerator setProvider(Provider provider) {
        this.helper = new EnvelopedDataHelper(new ProviderJcaJceExtHelper(provider));
        return this;
    }

    public JceKeyAgreeRecipientInfoGenerator setProvider(String providerName) {
        this.helper = new EnvelopedDataHelper(new NamedJcaJceExtHelper(providerName));
        return this;
    }

    public JceKeyAgreeRecipientInfoGenerator setSecureRandom(SecureRandom random) {
        this.random = random;
        return this;
    }

    public JceKeyAgreeRecipientInfoGenerator addRecipient(X509Certificate recipientCert) throws CertificateEncodingException {
        this.recipientIDs.add(new KeyAgreeRecipientIdentifier(CMSUtils.getIssuerAndSerialNumber(recipientCert)));
        this.recipientKeys.add(recipientCert.getPublicKey());
        return this;
    }

    public JceKeyAgreeRecipientInfoGenerator addRecipient(byte[] subjectKeyID, PublicKey publicKey) throws CertificateEncodingException {
        this.recipientIDs.add(new KeyAgreeRecipientIdentifier(new RecipientKeyIdentifier(subjectKeyID)));
        this.recipientKeys.add(publicKey);
        return this;
    }

    /*
     * WARNING - void declaration
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public ASN1Sequence generateRecipientEncryptedKeys(AlgorithmIdentifier keyAgreeAlgorithm, AlgorithmIdentifier keyEncryptionAlgorithm, GenericKey contentEncryptionKey) throws CMSException {
        if (this.recipientIDs.isEmpty()) {
            throw new CMSException("No recipients associated with generator - use addRecipient()");
        }
        this.init(keyAgreeAlgorithm.getAlgorithm());
        PrivateKey senderPrivateKey = this.senderPrivateKey;
        ASN1ObjectIdentifier keyAgreementOID = keyAgreeAlgorithm.getAlgorithm();
        ASN1EncodableVector recipientEncryptedKeys = new ASN1EncodableVector();
        for (int i = 0; i != this.recipientIDs.size(); ++i) {
            PublicKey recipientPublicKey = (PublicKey)this.recipientKeys.get(i);
            KeyAgreeRecipientIdentifier karId = (KeyAgreeRecipientIdentifier)this.recipientIDs.get(i);
            try {
                void var10_10;
                ASN1ObjectIdentifier keyEncAlg = keyEncryptionAlgorithm.getAlgorithm();
                if (CMSUtils.isMQV(keyAgreementOID)) {
                    MQVParameterSpec mQVParameterSpec = new MQVParameterSpec(this.ephemeralKP, recipientPublicKey, this.userKeyingMaterial);
                } else if (CMSUtils.isEC(keyAgreementOID)) {
                    byte[] ukmKeyingMaterial = ecc_cms_Generator.generateKDFMaterial(keyEncryptionAlgorithm, this.keySizeProvider.getKeySize(keyEncAlg), this.userKeyingMaterial);
                    UserKeyingMaterialSpec userKeyingMaterialSpec = new UserKeyingMaterialSpec(ukmKeyingMaterial);
                } else if (CMSUtils.isRFC2631(keyAgreementOID)) {
                    if (this.userKeyingMaterial != null) {
                        UserKeyingMaterialSpec userKeyingMaterialSpec = new UserKeyingMaterialSpec(this.userKeyingMaterial);
                    } else {
                        if (keyAgreementOID.equals(PKCSObjectIdentifiers.id_alg_SSDH)) {
                            throw new CMSException("User keying material must be set for static keys.");
                        }
                        Object var10_14 = null;
                    }
                } else {
                    if (!CMSUtils.isGOST(keyAgreementOID)) throw new CMSException("Unknown key agreement algorithm: " + keyAgreementOID);
                    if (this.userKeyingMaterial == null) throw new CMSException("User keying material must be set for static keys.");
                    UserKeyingMaterialSpec userKeyingMaterialSpec = new UserKeyingMaterialSpec(this.userKeyingMaterial);
                }
                KeyAgreement keyAgreement = this.helper.createKeyAgreement(keyAgreementOID);
                keyAgreement.init(senderPrivateKey, (AlgorithmParameterSpec)var10_10, this.random);
                keyAgreement.doPhase(recipientPublicKey, true);
                SecretKey keyEncryptionKey = keyAgreement.generateSecret(keyEncAlg.getId());
                Cipher keyEncryptionCipher = this.helper.createCipher(keyEncAlg);
                keyEncryptionCipher.init(3, (Key)keyEncryptionKey, this.random);
                byte[] encryptedKeyBytes = keyEncryptionCipher.wrap(this.helper.getJceKey(contentEncryptionKey));
                DEROctetString encryptedKey = new DEROctetString(encryptedKeyBytes);
                recipientEncryptedKeys.add(new RecipientEncryptedKey(karId, encryptedKey));
                continue;
            }
            catch (GeneralSecurityException generalSecurityException) {
                throw new CMSException("cannot perform agreement step: " + generalSecurityException.getMessage(), generalSecurityException);
            }
        }
        return new DERSequence(recipientEncryptedKeys);
    }

    protected byte[] getUserKeyingMaterial(AlgorithmIdentifier keyAgreeAlg) throws CMSException {
        this.init(keyAgreeAlg.getAlgorithm());
        if (this.ephemeralKP != null) {
            OriginatorPublicKey originatorPublicKey = this.createOriginatorPublicKey(SubjectPublicKeyInfo.getInstance(this.ephemeralKP.getPublic().getEncoded()));
            try {
                if (this.userKeyingMaterial != null) {
                    return new MQVuserKeyingMaterial(originatorPublicKey, new DEROctetString(this.userKeyingMaterial)).getEncoded();
                }
                return new MQVuserKeyingMaterial(originatorPublicKey, null).getEncoded();
            }
            catch (IOException e) {
                throw new CMSException("unable to encode user keying material: " + e.getMessage(), e);
            }
        }
        return this.userKeyingMaterial;
    }

    private void init(ASN1ObjectIdentifier keyAgreementOID) throws CMSException {
        if (this.random == null) {
            this.random = new SecureRandom();
        }
        if (CMSUtils.isMQV(keyAgreementOID) && this.ephemeralKP == null) {
            try {
                SubjectPublicKeyInfo pubInfo = SubjectPublicKeyInfo.getInstance(this.senderPublicKey.getEncoded());
                AlgorithmParameters ecAlgParams = this.helper.createAlgorithmParameters(keyAgreementOID);
                ecAlgParams.init(pubInfo.getAlgorithm().getParameters().toASN1Primitive().getEncoded());
                KeyPairGenerator ephemKPG = this.helper.createKeyPairGenerator(keyAgreementOID);
                ephemKPG.initialize(ecAlgParams.getParameterSpec(AlgorithmParameterSpec.class), this.random);
                this.ephemeralKP = ephemKPG.generateKeyPair();
            }
            catch (Exception e) {
                throw new CMSException("cannot determine MQV ephemeral key pair parameters from public key: " + e, e);
            }
        }
    }
}

