/*
 * Decompiled with CFR 0.152.
 */
package net.snowflake.client.jdbc.internal.org.bouncycastle.crypto;

import java.util.Arrays;
import net.snowflake.client.jdbc.internal.org.bouncycastle.crypto.Algorithm;
import net.snowflake.client.jdbc.internal.org.bouncycastle.crypto.CryptoServicesRegistrar;
import net.snowflake.client.jdbc.internal.org.bouncycastle.crypto.Parameters;
import net.snowflake.client.jdbc.internal.org.bouncycastle.crypto.SymmetricKey;
import net.snowflake.client.jdbc.internal.org.bouncycastle.crypto.fips.FipsOperationError;
import net.snowflake.client.jdbc.internal.org.bouncycastle.crypto.internal.Permissions;

public final class SymmetricSecretKey
implements SymmetricKey {
    private final boolean approvedModeOnly = CryptoServicesRegistrar.isInApprovedOnlyMode();
    private int hashCode;
    private Algorithm algorithm;
    private byte[] bytes;

    public SymmetricSecretKey(Algorithm algorithm, byte[] byArray) {
        this.algorithm = algorithm;
        this.hashCode = this.calculateHashCode();
        this.bytes = (byte[])byArray.clone();
    }

    public SymmetricSecretKey(Parameters parameters, byte[] byArray) {
        this.algorithm = parameters.getAlgorithm();
        this.hashCode = this.calculateHashCode();
        this.bytes = (byte[])byArray.clone();
    }

    public Algorithm getAlgorithm() {
        return this.algorithm;
    }

    private void zeroize() {
        for (int i = 0; i != this.bytes.length; ++i) {
            this.bytes[i] = 0;
        }
        this.bytes = null;
        this.algorithm = null;
        this.hashCode = 0;
    }

    public byte[] getKeyBytes() {
        this.checkApprovedOnlyModeStatus();
        SecurityManager securityManager = System.getSecurityManager();
        if (securityManager != null) {
            securityManager.checkPermission(Permissions.CanOutputSecretKey);
        }
        return (byte[])this.bytes.clone();
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (!(object instanceof SymmetricSecretKey)) {
            return false;
        }
        SymmetricSecretKey symmetricSecretKey = (SymmetricSecretKey)object;
        if (!this.getAlgorithm().equals(symmetricSecretKey.getAlgorithm())) {
            return false;
        }
        return Arrays.equals(this.bytes, symmetricSecretKey.bytes);
    }

    public int hashCode() {
        this.checkApprovedOnlyModeStatus();
        return this.hashCode;
    }

    private int calculateHashCode() {
        this.checkApprovedOnlyModeStatus();
        int n = this.getAlgorithm().hashCode();
        n = 31 * n + Arrays.hashCode(this.bytes);
        return n;
    }

    protected void finalize() throws Throwable {
        this.zeroize();
    }

    final void checkApprovedOnlyModeStatus() {
        if (this.approvedModeOnly != CryptoServicesRegistrar.isInApprovedOnlyMode()) {
            throw new FipsOperationError("attempt to use key created in " + (this.approvedModeOnly ? "approved mode" : "unapproved mode") + " in alternate mode.");
        }
    }
}

