/*
 * Decompiled with CFR 0.152.
 */
package net.snowflake.client.jdbc.internal.org.bouncycastle.crypto.asymmetric;

import java.io.IOException;
import java.math.BigInteger;
import net.snowflake.client.jdbc.internal.org.bouncycastle.asn1.ASN1Integer;
import net.snowflake.client.jdbc.internal.org.bouncycastle.asn1.DERBitString;
import net.snowflake.client.jdbc.internal.org.bouncycastle.asn1.oiw.ElGamalParameter;
import net.snowflake.client.jdbc.internal.org.bouncycastle.asn1.oiw.OIWObjectIdentifiers;
import net.snowflake.client.jdbc.internal.org.bouncycastle.asn1.pkcs.DHParameter;
import net.snowflake.client.jdbc.internal.org.bouncycastle.asn1.pkcs.PKCSObjectIdentifiers;
import net.snowflake.client.jdbc.internal.org.bouncycastle.asn1.pkcs.PrivateKeyInfo;
import net.snowflake.client.jdbc.internal.org.bouncycastle.asn1.x509.AlgorithmIdentifier;
import net.snowflake.client.jdbc.internal.org.bouncycastle.asn1.x9.DomainParameters;
import net.snowflake.client.jdbc.internal.org.bouncycastle.asn1.x9.ValidationParams;
import net.snowflake.client.jdbc.internal.org.bouncycastle.asn1.x9.X9ObjectIdentifiers;
import net.snowflake.client.jdbc.internal.org.bouncycastle.crypto.Algorithm;
import net.snowflake.client.jdbc.internal.org.bouncycastle.crypto.AsymmetricPrivateKey;
import net.snowflake.client.jdbc.internal.org.bouncycastle.crypto.asymmetric.AsymmetricDHKey;
import net.snowflake.client.jdbc.internal.org.bouncycastle.crypto.asymmetric.DHDomainParameters;
import net.snowflake.client.jdbc.internal.org.bouncycastle.crypto.asymmetric.DHValidationParameters;
import net.snowflake.client.jdbc.internal.org.bouncycastle.crypto.asymmetric.KeyUtils;
import net.snowflake.client.jdbc.internal.org.bouncycastle.crypto.internal.Permissions;

public final class AsymmetricDHPrivateKey
extends AsymmetricDHKey
implements AsymmetricPrivateKey {
    private final int hashCode;
    private BigInteger x;

    public AsymmetricDHPrivateKey(Algorithm algorithm, DHDomainParameters dHDomainParameters, BigInteger bigInteger) {
        super(algorithm, dHDomainParameters);
        this.x = bigInteger;
        this.hashCode = this.calculateHashCode();
    }

    public AsymmetricDHPrivateKey(Algorithm algorithm, byte[] byArray) {
        this(algorithm, PrivateKeyInfo.getInstance(byArray));
    }

    public AsymmetricDHPrivateKey(Algorithm algorithm, PrivateKeyInfo privateKeyInfo) {
        super(algorithm, privateKeyInfo.getPrivateKeyAlgorithm());
        this.x = AsymmetricDHPrivateKey.parsePrivateKey(privateKeyInfo);
        this.hashCode = this.calculateHashCode();
    }

    private static BigInteger parsePrivateKey(PrivateKeyInfo privateKeyInfo) {
        try {
            return ASN1Integer.getInstance(privateKeyInfo.parsePrivateKey()).getValue();
        }
        catch (IOException iOException) {
            throw new IllegalArgumentException("Unable to parse DSA private key: " + iOException.getMessage(), iOException);
        }
    }

    public final byte[] getEncoded() {
        DHDomainParameters dHDomainParameters = this.getDomainParameters();
        if (dHDomainParameters.getQ() == null) {
            if (this.getAlgorithm().getName().startsWith("ELGAMAL")) {
                return KeyUtils.getEncodedPrivateKeyInfo(new AlgorithmIdentifier(OIWObjectIdentifiers.elGamalAlgorithm, new ElGamalParameter(dHDomainParameters.getP(), dHDomainParameters.getG())), new ASN1Integer(this.getX()));
            }
            return KeyUtils.getEncodedPrivateKeyInfo(new AlgorithmIdentifier(PKCSObjectIdentifiers.dhKeyAgreement, new DHParameter(dHDomainParameters.getP(), dHDomainParameters.getG(), dHDomainParameters.getL())), new ASN1Integer(this.getX()));
        }
        DHValidationParameters dHValidationParameters = dHDomainParameters.getValidationParameters();
        if (dHValidationParameters != null) {
            return KeyUtils.getEncodedPrivateKeyInfo(new AlgorithmIdentifier(X9ObjectIdentifiers.dhpublicnumber, new DomainParameters(dHDomainParameters.getP(), dHDomainParameters.getG(), dHDomainParameters.getQ(), dHDomainParameters.getJ(), new ValidationParams(new DERBitString(dHValidationParameters.getSeed()), new ASN1Integer(dHValidationParameters.getCounter())))), new ASN1Integer(this.getX()));
        }
        return KeyUtils.getEncodedPrivateKeyInfo(new AlgorithmIdentifier(X9ObjectIdentifiers.dhpublicnumber, new DomainParameters(dHDomainParameters.getP(), dHDomainParameters.getG(), dHDomainParameters.getQ(), dHDomainParameters.getJ(), null)), new ASN1Integer(this.getX()));
    }

    public BigInteger getX() {
        this.checkApprovedOnlyModeStatus();
        KeyUtils.checkPermission(Permissions.CanOutputPrivateKey);
        return this.x;
    }

    private void zeroize() {
        this.x = null;
    }

    public int hashCode() {
        return this.hashCode;
    }

    private int calculateHashCode() {
        int n = this.x.hashCode();
        n = 31 * n + this.getDomainParameters().hashCode();
        return n;
    }

    protected void finalize() throws Throwable {
        this.zeroize();
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (!(object instanceof AsymmetricDHPrivateKey)) {
            return false;
        }
        AsymmetricDHPrivateKey asymmetricDHPrivateKey = (AsymmetricDHPrivateKey)object;
        return this.x.equals(asymmetricDHPrivateKey.x) && this.getDomainParameters().equals(asymmetricDHPrivateKey.getDomainParameters());
    }
}

