/*
 * Decompiled with CFR 0.152.
 */
package net.snowflake.client.jdbc.internal.org.bouncycastle.crypto.asymmetric;

import java.io.IOException;
import java.math.BigInteger;
import net.snowflake.client.jdbc.internal.org.bouncycastle.asn1.ASN1Encodable;
import net.snowflake.client.jdbc.internal.org.bouncycastle.asn1.ASN1Integer;
import net.snowflake.client.jdbc.internal.org.bouncycastle.asn1.pkcs.PrivateKeyInfo;
import net.snowflake.client.jdbc.internal.org.bouncycastle.asn1.sec.ECPrivateKey;
import net.snowflake.client.jdbc.internal.org.bouncycastle.asn1.ua.DSTU4145ECBinary;
import net.snowflake.client.jdbc.internal.org.bouncycastle.asn1.ua.DSTU4145Params;
import net.snowflake.client.jdbc.internal.org.bouncycastle.asn1.ua.UAObjectIdentifiers;
import net.snowflake.client.jdbc.internal.org.bouncycastle.asn1.x509.AlgorithmIdentifier;
import net.snowflake.client.jdbc.internal.org.bouncycastle.crypto.Algorithm;
import net.snowflake.client.jdbc.internal.org.bouncycastle.crypto.AsymmetricPrivateKey;
import net.snowflake.client.jdbc.internal.org.bouncycastle.crypto.asymmetric.AsymmetricDSTU4145Key;
import net.snowflake.client.jdbc.internal.org.bouncycastle.crypto.asymmetric.DSTU4145Parameters;
import net.snowflake.client.jdbc.internal.org.bouncycastle.crypto.asymmetric.KeyUtils;
import net.snowflake.client.jdbc.internal.org.bouncycastle.crypto.asymmetric.NamedECDomainParameters;
import net.snowflake.client.jdbc.internal.org.bouncycastle.crypto.internal.Permissions;
import net.snowflake.client.jdbc.internal.org.bouncycastle.math.ec.ECCurve;

public final class AsymmetricDSTU4145PrivateKey
extends AsymmetricDSTU4145Key
implements AsymmetricPrivateKey {
    private final int hashCode;
    private PrivateKeyInfo privKeyInfo;
    private BigInteger d;

    public AsymmetricDSTU4145PrivateKey(Algorithm algorithm, DSTU4145Parameters dSTU4145Parameters, BigInteger bigInteger) {
        super(algorithm, dSTU4145Parameters);
        this.d = bigInteger;
        this.hashCode = this.calculateHashCode();
    }

    public AsymmetricDSTU4145PrivateKey(Algorithm algorithm, byte[] byArray) {
        this(algorithm, PrivateKeyInfo.getInstance(byArray));
    }

    public AsymmetricDSTU4145PrivateKey(Algorithm algorithm, PrivateKeyInfo privateKeyInfo) {
        super(algorithm, privateKeyInfo.getPrivateKeyAlgorithm());
        this.privKeyInfo = privateKeyInfo;
        this.d = AsymmetricDSTU4145PrivateKey.parsePrivateKey(privateKeyInfo);
        this.hashCode = this.calculateHashCode();
    }

    private static BigInteger parsePrivateKey(PrivateKeyInfo privateKeyInfo) {
        try {
            ASN1Encodable aSN1Encodable = privateKeyInfo.parsePrivateKey();
            if (aSN1Encodable instanceof ASN1Integer) {
                ASN1Integer aSN1Integer = ASN1Integer.getInstance(aSN1Encodable);
                return aSN1Integer.getValue();
            }
            return ECPrivateKey.getInstance(aSN1Encodable).getKey();
        }
        catch (IOException iOException) {
            throw new IllegalArgumentException("invalid info structure in DSTU4145 private key");
        }
    }

    public final byte[] getEncoded() {
        this.checkApprovedOnlyModeStatus();
        KeyUtils.checkPermission(Permissions.CanOutputPrivateKey);
        if (this.privKeyInfo != null) {
            return KeyUtils.getEncodedInfo(this.privKeyInfo);
        }
        DSTU4145Parameters dSTU4145Parameters = this.getParameters();
        int n = KeyUtils.getOrderBitLength(dSTU4145Parameters.getDomainParameters());
        if (dSTU4145Parameters.getDomainParameters() instanceof NamedECDomainParameters) {
            NamedECDomainParameters namedECDomainParameters = (NamedECDomainParameters)dSTU4145Parameters.getDomainParameters();
            DSTU4145Params dSTU4145Params = new DSTU4145Params(namedECDomainParameters.getID(), dSTU4145Parameters.getDKE());
            ECPrivateKey eCPrivateKey = new ECPrivateKey(n, this.getS(), (ASN1Encodable)dSTU4145Params);
            return KeyUtils.getEncodedPrivateKeyInfo(new AlgorithmIdentifier(UAObjectIdentifiers.dstu4145be, dSTU4145Params), eCPrivateKey);
        }
        if (dSTU4145Parameters.getDomainParameters().getCurve() instanceof ECCurve.AbstractF2m) {
            DSTU4145ECBinary dSTU4145ECBinary = new DSTU4145ECBinary(dSTU4145Parameters.getDomainParameters());
            DSTU4145Params dSTU4145Params = new DSTU4145Params(dSTU4145ECBinary);
            ECPrivateKey eCPrivateKey = new ECPrivateKey(n, this.getS(), (ASN1Encodable)dSTU4145Params);
            return KeyUtils.getEncodedPrivateKeyInfo(new AlgorithmIdentifier(UAObjectIdentifiers.dstu4145be, dSTU4145Params), eCPrivateKey);
        }
        throw new IllegalArgumentException("Unable to encode binary parameters");
    }

    public BigInteger getS() {
        this.checkApprovedOnlyModeStatus();
        KeyUtils.checkPermission(Permissions.CanOutputPrivateKey);
        return this.d;
    }

    public boolean equals(Object object) {
        this.checkApprovedOnlyModeStatus();
        if (this == object) {
            return true;
        }
        if (!(object instanceof AsymmetricDSTU4145PrivateKey)) {
            return false;
        }
        AsymmetricDSTU4145PrivateKey asymmetricDSTU4145PrivateKey = (AsymmetricDSTU4145PrivateKey)object;
        if (this.d == null ? asymmetricDSTU4145PrivateKey.d != null : !this.d.equals(asymmetricDSTU4145PrivateKey.d)) {
            return false;
        }
        return this.getParameters().equals(asymmetricDSTU4145PrivateKey.getParameters());
    }

    public int hashCode() {
        this.checkApprovedOnlyModeStatus();
        return this.hashCode;
    }

    private int calculateHashCode() {
        int n = this.d.hashCode();
        n = 31 * n + this.getParameters().hashCode();
        return n;
    }

    protected void finalize() throws Throwable {
        super.finalize();
        this.zeroize();
    }

    private void zeroize() {
        this.d = null;
    }
}

